/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core.application.update;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.application.internal.CoreApplicationActivator;
import org.jkiss.dbeaver.core.application.update.CheckForUpdateAction;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

class VersionUpdateDialog
extends Dialog {
    private VersionDescriptor newVersion;
    private static final int INFO_ID = 1000;
    private Font boldFont;
    private boolean autoCheck;
    private Button dontShowAgainCheck;

    public VersionUpdateDialog(Shell parentShell, VersionDescriptor newVersion, boolean autoCheck) {
        super(parentShell);
        this.newVersion = newVersion;
        this.autoCheck = autoCheck;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CoreMessages.dialog_version_update_title);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        Group propGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.dialog_version_update_title, (int)2, (int)1808, (int)0);
        this.boldFont = UIUtils.makeBoldFont((Font)composite.getFont());
        Label titleLabel = new Label((Composite)propGroup, 0);
        titleLabel.setText(NLS.bind((String)(this.newVersion == null ? CoreMessages.dialog_version_update_no_new_version : CoreMessages.dialog_version_update_available_new_version), (Object)GeneralUtils.getProductName()));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        titleLabel.setLayoutData((Object)gd);
        titleLabel.setFont(this.boldFont);
        String versionStr = GeneralUtils.getProductVersion().toString();
        UIUtils.createControlLabel((Composite)propGroup, (String)CoreMessages.dialog_version_update_current_version);
        new Label((Composite)propGroup, 0).setText(versionStr);
        UIUtils.createControlLabel((Composite)propGroup, (String)CoreMessages.dialog_version_update_new_version);
        new Label((Composite)propGroup, 0).setText(this.newVersion == null ? versionStr : String.valueOf(this.newVersion.getProgramVersion().toString()) + "    (" + this.newVersion.getUpdateTime() + ")");
        if (this.newVersion != null) {
            Label notesLabel = UIUtils.createControlLabel((Composite)propGroup, (String)CoreMessages.dialog_version_update_notes);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            notesLabel.setLayoutData((Object)gd);
            Text notesText = new Text((Composite)propGroup, 584);
            notesText.setText(this.newVersion.getReleaseNotes());
            gd = new GridData(1808);
            gd.horizontalSpan = 2;
            gd.heightHint = notesText.getLineHeight() * 20;
            notesText.setLayoutData((Object)gd);
            Label hintLabel = new Label((Composite)propGroup, 0);
            hintLabel.setText(NLS.bind((String)CoreMessages.dialog_version_update_press_more_info_, (Object)this.newVersion.getPlainVersion()));
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            hintLabel.setLayoutData((Object)gd);
            hintLabel.setFont(this.boldFont);
        }
        return parent;
    }

    public boolean close() {
        this.boldFont.dispose();
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.autoCheck && this.newVersion != null) {
            ++((GridLayout)parent.getLayout()).numColumns;
            this.dontShowAgainCheck = UIUtils.createCheckbox((Composite)parent, (String)("Don't show for the version " + this.newVersion.getPlainVersion()), (boolean)false);
        }
        if (this.newVersion != null) {
            this.createButton(parent, 1000, CoreMessages.dialog_version_update_button_more_info, true);
        }
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, this.newVersion == null);
    }

    protected void buttonPressed(int buttonId) {
        if (this.dontShowAgainCheck != null && this.dontShowAgainCheck.getSelection()) {
            CoreApplicationActivator.getDefault().getPreferenceStore().setValue("suppressUpdateCheck." + this.newVersion.getPlainVersion(), true);
        }
        if (buttonId == 1000) {
            if (this.newVersion != null) {
                UIUtils.launchProgram((String)this.newVersion.getBaseURL());
            }
        } else if (buttonId == 10) {
            IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
            CheckForUpdateAction.activateStandardHandler(window);
            try {
                ActionUtils.runCommand((String)"org.eclipse.equinox.p2.ui.sdk.update", (IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
            finally {
                CheckForUpdateAction.deactivateStandardHandler(window);
            }
        }
        this.close();
    }

    public static boolean isSuppressed(VersionDescriptor version) {
        CoreApplicationActivator activator = CoreApplicationActivator.getDefault();
        return activator != null && activator.getPreferenceStore().getBoolean("suppressUpdateCheck." + version.getPlainVersion());
    }
}

