/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core.application;

import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.application.about.AboutBoxAction;
import org.jkiss.dbeaver.core.application.update.CheckForUpdateAction;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.actions.common.EmergentExitAction;
import org.jkiss.dbeaver.ui.actions.common.ToggleViewAction;
import org.jkiss.dbeaver.ui.controls.StatusLineContributionItemEx;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private static final Log log = Log.getLog(ApplicationActionBarAdvisor.class);
    public static final String M_ALT_HELP = "dbhelp";
    protected IActionDelegate emergentExitAction;
    protected IActionDelegate aboutAction;
    protected CheckForUpdateAction checkUpdatesAction;
    protected ActionFactory.IWorkbenchAction showHelpAction;
    protected ActionFactory.IWorkbenchAction newWindowAction;
    private ActionFactory.IWorkbenchAction openWorkspaceAction;
    private static final String[] actionSetId = new String[]{"org.eclipse.ui.WorkingSetActionSet", "org.eclipse.ui.edit.text.actionSet.annotationNavigation", "org.eclipse.mylyn.tasks.ui.navigation"};

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    private void removeUnWantedActions() {
        IActionSetDescriptor[] actionSets;
        ActionSetRegistry asr = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] iActionSetDescriptorArray = actionSets = asr.getActionSets();
        int n = actionSets.length;
        int n2 = 0;
        while (n2 < n) {
            IActionSetDescriptor actionSet = iActionSetDescriptorArray[n2];
            String[] stringArray = actionSetId;
            int n3 = actionSetId.length;
            int n4 = 0;
            while (n4 < n3) {
                String element = stringArray[n4];
                if (element.equals(actionSet.getId())) {
                    log.debug((Object)("Disable Eclipse action set '" + actionSet.getId() + "'"));
                    IExtension ext = actionSet.getConfigurationElement().getDeclaringExtension();
                    asr.removeExtension(ext, new Object[]{actionSet});
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected boolean isShowAltHelp() {
        return true;
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.removeUnWantedActions();
        this.register((IAction)ActionFactory.SAVE.create(window));
        this.register((IAction)ActionFactory.SAVE_AS.create(window));
        this.register((IAction)ActionFactory.SAVE_ALL.create(window));
        this.register((IAction)ActionFactory.CLOSE.create(window));
        this.register((IAction)ActionFactory.PRINT.create(window));
        this.aboutAction = new AboutBoxAction(window);
        this.emergentExitAction = new EmergentExitAction(window);
        this.showHelpAction = ActionFactory.HELP_CONTENTS.create(window);
        this.register((IAction)this.showHelpAction);
        this.checkUpdatesAction = new CheckForUpdateAction();
        this.newWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(window);
        this.register((IAction)this.newWindowAction);
        this.openWorkspaceAction = IDEActionFactory.OPEN_WORKSPACE.create(window);
        this.register((IAction)this.openWorkspaceAction);
        CheckForUpdateAction.deactivateStandardHandler(window);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        boolean showAltHelp = this.isShowAltHelp();
        MenuManager fileMenu = new MenuManager(CoreMessages.actions_menu_file, "file");
        MenuManager editMenu = new MenuManager(CoreMessages.actions_menu_edit, "edit");
        MenuManager navigateMenu = new MenuManager(CoreMessages.actions_menu_navigate, "navigate");
        MenuManager windowMenu = new MenuManager(CoreMessages.actions_menu_window, "window");
        MenuManager helpMenu = new MenuManager(CoreMessages.actions_menu_help, "help");
        menuBar.add((IContributionItem)fileMenu);
        menuBar.add((IContributionItem)editMenu);
        menuBar.add((IContributionItem)navigateMenu);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)windowMenu);
        menuBar.add((IContributionItem)helpMenu);
        IWorkbenchWindow workbenchWindow = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        fileMenu.add((IContributionItem)new GroupMarker("fileStart"));
        fileMenu.add((IContributionItem)new GroupMarker("new.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker("close.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker("print.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker("open.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker("import.ext"));
        fileMenu.add((IContributionItem)new Separator());
        MenuManager recentEditors = new MenuManager("Recent editors");
        recentEditors.add(ContributionItemFactory.REOPEN_EDITORS.create(workbenchWindow));
        recentEditors.add((IContributionItem)new GroupMarker("mru"));
        fileMenu.add((IContributionItem)recentEditors);
        fileMenu.add((IContributionItem)new GroupMarker("additions"));
        fileMenu.add((IAction)this.openWorkspaceAction);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add(ActionUtils.makeAction((IActionDelegate)this.emergentExitAction, null, null, (String)CoreMessages.actions_menu_exit_emergency, null, null));
        fileMenu.add((IContributionItem)new GroupMarker("fileEnd"));
        ActionSetRegistry asr = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor actionSet = asr.findActionSet("org.eclipse.ui.edit.text.actionSet.convertLineDelimitersTo");
        if (actionSet != null) {
            MenuManager convertLDMenu = new MenuManager(actionSet.getLabel());
            IConfigurationElement[] iConfigurationElementArray = actionSet.getConfigurationElement().getChildren("action");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement action = iConfigurationElementArray[n2];
                String actionClassName = action.getAttribute("class");
                if (!CommonUtils.isEmpty((String)actionClassName)) {
                    try {
                        Bundle actionBundle = Platform.getBundle((String)action.getContributor().getName());
                        Class actionClass = actionBundle.loadClass(actionClassName);
                        convertLDMenu.add((IAction)actionClass.newInstance());
                    }
                    catch (Throwable e) {
                        log.error((Object)e);
                    }
                }
                ++n2;
            }
            editMenu.add((IContributionItem)convertLDMenu);
        }
        navigateMenu.add((IContributionItem)new GroupMarker("navStart"));
        navigateMenu.add((IContributionItem)new Separator("open.ext"));
        navigateMenu.add((IContributionItem)new Separator("show.ext"));
        navigateMenu.add((IContributionItem)new Separator("additions"));
        navigateMenu.add((IContributionItem)new GroupMarker("navEnd"));
        navigateMenu.add((IContributionItem)new GroupMarker("group.application"));
        windowMenu.add((IAction)this.newWindowAction);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)new ToggleViewAction("org.jkiss.dbeaver.core.databaseNavigator"));
        windowMenu.add((IAction)new ToggleViewAction("org.jkiss.dbeaver.core.projectNavigator"));
        windowMenu.add((IAction)new ToggleViewAction("org.jkiss.dbeaver.core.projectExplorer"));
        MenuManager showViewMenuMgr = new MenuManager(CoreMessages.actions_menu_window_showView, "showView");
        IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        showViewMenuMgr.add(showViewMenu);
        windowMenu.add((IContributionItem)showViewMenuMgr);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IContributionItem)new GroupMarker("perspective"));
        windowMenu.add((IContributionItem)new GroupMarker("additions"));
        windowMenu.add((IContributionItem)new Separator());
        helpMenu.add(ActionUtils.makeAction((IActionDelegate)this.aboutAction, null, null, (String)CoreMessages.actions_menu_about, null, null));
        helpMenu.add((IAction)this.showHelpAction);
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchWindow, (String)"org.eclipse.ui.help.installationDialog"));
        helpMenu.add((IContributionItem)new GroupMarker("additions"));
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)new ToolBarManager(0x804000), "dbeaver-general"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)new ToolBarManager(0x820000), "dbeaver-transactions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)new ToolBarManager(0x820000), "dbeaver-edit"));
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        StatusLineContributionItemEx tzItem = new StatusLineContributionItemEx("Time Zone");
        tzItem.setText(TimeZone.getDefault().getDisplayName(false, 0));
        tzItem.setToolTip(TimeZone.getDefault().getDisplayName(true, 1));
        statusLine.add((IContributionItem)tzItem);
        StatusLineContributionItemEx localeItem = new StatusLineContributionItemEx("Locale");
        localeItem.setText(Locale.getDefault().toString());
        localeItem.setToolTip(Locale.getDefault().getDisplayName());
        statusLine.add((IContributionItem)localeItem);
    }
}

