/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.import_config.wizards.navicat;

public class DatatypeConverter {
    private static final byte[] decodeMap = DatatypeConverter.initDecodeMap();
    private static final byte PADDING = 127;
    private static final char[] hexCode = "0123456789ABCDEF".toCharArray();

    private static byte[] initDecodeMap() {
        byte[] map = new byte[128];
        int i = 0;
        while (i < 128) {
            map[i] = -1;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            map[i] = (byte)(i - 65);
            ++i;
        }
        i = 97;
        while (i <= 122) {
            map[i] = (byte)(i - 97 + 26);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            map[i] = (byte)(i - 48 + 52);
            ++i;
        }
        map[43] = 62;
        map[47] = 63;
        map[61] = 127;
        return map;
    }

    public static byte[] parseHexBinary(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("hexBinary needs to be even-length: " + s);
        }
        byte[] out = new byte[len / 2];
        int i = 0;
        while (i < len) {
            int h = DatatypeConverter.hexToBin(s.charAt(i));
            int l = DatatypeConverter.hexToBin(s.charAt(i + 1));
            if (h == -1 || l == -1) {
                throw new IllegalArgumentException("contains illegal character for hexBinary: " + s);
            }
            out[i / 2] = (byte)(h * 16 + l);
            i += 2;
        }
        return out;
    }

    private static int hexToBin(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }

    public static String printHexBinary(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
            ++n2;
        }
        return r.toString();
    }
}

