/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.txn;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.qm.QMEventFilter;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMSessionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.querylog.QueryLogViewer;
import org.jkiss.utils.CommonUtils;

public abstract class TransactionInfoDialog
extends Dialog {
    private static final QMEventFilter VOID_FILTER = event -> false;
    private final IWorkbenchPart activeEditor;
    protected QueryLogViewer logViewer;
    private Button showAllCheck;
    protected Button showPreviousCheck;

    public TransactionInfoDialog(Shell parentShell, IWorkbenchPart activeEditor) {
        super(parentShell);
        this.activeEditor = activeEditor;
    }

    protected boolean isResizable() {
        return true;
    }

    protected abstract DBCExecutionContext getCurrentContext();

    protected void createTransactionLogPanel(Composite composite) {
        DBCExecutionContext context = this.getCurrentContext();
        QMEventFilter filter = context == null ? VOID_FILTER : this.createContextFilter(context);
        this.logViewer = new QueryLogViewer(composite, this.activeEditor.getSite(), filter, false, true);
        this.logViewer.setUseDefaultFilter(false);
        Object gd = this.logViewer.getControl().getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).heightHint = this.logViewer.getControl().getHeaderHeight() + this.logViewer.getControl().getItemHeight() * 5;
        }
        this.showAllCheck = UIUtils.createCheckbox((Composite)composite, (String)"Show all queries", (String)"Show all transaction queries. Otherwise shows only modifying queries.", (boolean)false, (int)1);
        this.showAllCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionInfoDialog.this.updateTransactionFilter();
            }
        });
        this.showPreviousCheck = UIUtils.createCheckbox((Composite)composite, (String)"Show previous transactions", (String)"Show previous transactions. Otherwise shows only active one.", (boolean)false, (int)1);
        this.showPreviousCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionInfoDialog.this.updateTransactionFilter();
            }
        });
    }

    protected void updateTransactionFilter() {
        DBCExecutionContext context = this.getCurrentContext();
        QMEventFilter filter = context == null ? VOID_FILTER : this.createContextFilter(context);
        this.logViewer.setFilter(filter);
        this.logViewer.refresh();
    }

    protected QMEventFilter createContextFilter(DBCExecutionContext executionContext) {
        if (executionContext == null) {
            return VOID_FILTER;
        }
        boolean showAll = this.showAllCheck != null && this.showAllCheck.getSelection();
        boolean showPrevious = this.showPreviousCheck != null && this.showPreviousCheck.getSelection();
        QMMSessionInfo currentSession = QMUtils.getCurrentSession((DBCExecutionContext)executionContext);
        QMMTransactionSavepointInfo currentSP = QMUtils.getCurrentTransaction((DBCExecutionContext)executionContext);
        QMEventFilter filter = event -> {
            QMMObject object = event.getObject();
            if (object instanceof QMMStatementExecuteInfo) {
                QMMStatementExecuteInfo exec = (QMMStatementExecuteInfo)object;
                if (!showPrevious && !CommonUtils.equalObjects((Object)exec.getSavepoint(), (Object)currentSP)) {
                    return false;
                }
                if (!showAll && !CommonUtils.equalObjects((Object)exec.getStatement().getSession(), (Object)currentSession)) {
                    return false;
                }
                DBCExecutionPurpose purpose = exec.getStatement().getPurpose();
                if (purpose == DBCExecutionPurpose.META || purpose == DBCExecutionPurpose.UTIL) {
                    return false;
                }
                return showAll || exec.isTransactional();
            }
            return false;
        };
        return filter;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }
}

