/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferSettings;
import org.jkiss.utils.CommonUtils;

public class DatabaseProducerSettings
implements IDataTransferSettings {
    private static final int DEFAULT_SEGMENT_SIZE = 100000;
    private int segmentSize = 100000;
    private boolean openNewConnections = true;
    private boolean queryRowCount = true;
    private boolean selectedRowsOnly = false;
    private boolean selectedColumnsOnly = false;
    private ExtractType extractType = ExtractType.SINGLE_QUERY;

    public int getSegmentSize() {
        return this.segmentSize;
    }

    public void setSegmentSize(int segmentSize) {
        if (segmentSize > 0) {
            this.segmentSize = segmentSize;
        }
    }

    public boolean isQueryRowCount() {
        return this.queryRowCount;
    }

    public void setQueryRowCount(boolean queryRowCount) {
        this.queryRowCount = queryRowCount;
    }

    public boolean isSelectedRowsOnly() {
        return this.selectedRowsOnly;
    }

    public void setSelectedRowsOnly(boolean selectedRowsOnly) {
        this.selectedRowsOnly = selectedRowsOnly;
    }

    public boolean isSelectedColumnsOnly() {
        return this.selectedColumnsOnly;
    }

    public void setSelectedColumnsOnly(boolean selectedColumnsOnly) {
        this.selectedColumnsOnly = selectedColumnsOnly;
    }

    public boolean isOpenNewConnections() {
        return this.openNewConnections;
    }

    public void setOpenNewConnections(boolean openNewConnections) {
        this.openNewConnections = openNewConnections;
    }

    public ExtractType getExtractType() {
        return this.extractType;
    }

    public void setExtractType(ExtractType extractType) {
        this.extractType = extractType;
    }

    @Override
    public void loadSettings(IRunnableContext runnableContext, DataTransferSettings dataTransferSettings, IDialogSettings dialogSettings) {
        if (dialogSettings.get("extractType") != null) {
            try {
                this.extractType = ExtractType.valueOf(dialogSettings.get("extractType"));
            }
            catch (IllegalArgumentException e) {
                this.extractType = ExtractType.SINGLE_QUERY;
            }
        }
        try {
            this.segmentSize = dialogSettings.getInt("segmentSize");
        }
        catch (NumberFormatException e) {
            this.segmentSize = 100000;
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("openNewConnections"))) {
            this.openNewConnections = dialogSettings.getBoolean("openNewConnections");
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("queryRowCount"))) {
            this.queryRowCount = dialogSettings.getBoolean("queryRowCount");
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("selectedColumnsOnly"))) {
            this.selectedColumnsOnly = dialogSettings.getBoolean("selectedColumnsOnly");
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("selectedRowsOnly"))) {
            this.selectedRowsOnly = dialogSettings.getBoolean("selectedRowsOnly");
        }
    }

    @Override
    public void saveSettings(IDialogSettings dialogSettings) {
        dialogSettings.put("extractType", this.extractType.name());
        dialogSettings.put("segmentSize", this.segmentSize);
        dialogSettings.put("openNewConnections", this.openNewConnections);
        dialogSettings.put("queryRowCount", this.queryRowCount);
        dialogSettings.put("selectedColumnsOnly", this.selectedColumnsOnly);
        dialogSettings.put("selectedRowsOnly", this.selectedRowsOnly);
    }

    public static enum ExtractType {
        SINGLE_QUERY,
        SEGMENTS;

    }
}

