// -*- mode: C; -*-
#version 110

uniform sampler2D tex_noise;	// (diffuse) color map, RGB

varying vec2 texcoord, texcoord2;

void main()
{
	vec2 offset = texcoord.xy;
	vec2 shift = texcoord2.xy;
//	vec3 col = vec3(0.4, 0.8, 1.0);
	float n0 = texture2D(tex_noise, offset.xy + shift.xy).x;
	float n1 = texture2D(tex_noise, offset.xy * 2.0 - shift.xy).x;
	float n2 = texture2D(tex_noise, offset.xy * 4.0 + shift.xy).x;
	float n3 = texture2D(tex_noise, offset.xy * 8.0 - shift.xy).x;
	float n4 = texture2D(tex_noise, offset.xy * 16.0 + shift.xy).x;
	float n5 = texture2D(tex_noise, offset.xy * 32.0 - shift.xy).x;
	float n6 = texture2D(tex_noise, offset.xy * 64.0 + shift.xy).x;
	float n_sum =
		  n0 * 0.5
		+ n1 * 0.25
		+ n2 * 0.125
		+ n3 * 0.0625
		+ n4 * 0.03125
		+ n5 * 0.015625
		+ n6 * 0.0078125;
//	n_sum = n_sum * 1.5;
	n_sum = max(0.0, n_sum * 2.0 - 1.0);
	gl_FragColor = vec4(0.2, 0.8, 1.0, n_sum);
//	gl_FragColor = vec4(vec3(n_sum, n_sum, n_sum) * col, 1.0);
}
