/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.CompressionMethod;
import com.android.builder.internal.packaging.zip.GPFlags;
import com.android.builder.internal.packaging.zip.utils.MsDosDateTimeUtils;
import com.google.common.base.Preconditions;
import java.util.Arrays;

public class CentralDirectoryHeader
implements Cloneable {
    private String mName;
    private long mCrc32;
    private long mCompressedSize;
    private long mUncompressedSize;
    private CompressionMethod mMethod;
    private long mMadeBy;
    private long mVersionExtract;
    private GPFlags mGpBit;
    private long mLastModTime;
    private long mLastModDate;
    private byte[] mExtraField;
    private byte[] mComment;
    private long mInternalAttributes;
    private long mExternalAttributes;
    private long mOffset;

    CentralDirectoryHeader(String name, long compressedSize, long uncompressedSize, CompressionMethod method) {
        this.mName = name;
        this.mCompressedSize = compressedSize;
        this.mUncompressedSize = uncompressedSize;
        this.mMethod = method;
        this.mCrc32 = 0L;
        if (method == CompressionMethod.STORE) {
            Preconditions.checkArgument((uncompressedSize == compressedSize ? 1 : 0) != 0, (Object)("File data with STORE but compressed size != uncompressed size (" + compressedSize + " vs " + uncompressedSize + " )"));
        }
        this.mMadeBy = 0L;
        this.mGpBit = GPFlags.makeDefault();
        this.mLastModTime = MsDosDateTimeUtils.packCurrentTime();
        this.mLastModDate = MsDosDateTimeUtils.packCurrentDate();
        this.mExtraField = new byte[0];
        this.mComment = new byte[0];
        this.mInternalAttributes = 0L;
        this.mExternalAttributes = 0L;
        this.mOffset = -1L;
        this.mVersionExtract = name.endsWith("/") || method == CompressionMethod.DEFLATE ? 20L : 10L;
    }

    public String getName() {
        return this.mName;
    }

    public long getUncompressedSize() {
        return this.mUncompressedSize;
    }

    public long getCompressedSize() {
        return this.mCompressedSize;
    }

    public void setCompressedSize(long compressedSize) {
        Preconditions.checkState((this.mMethod == CompressionMethod.DEFLATE ? 1 : 0) != 0, (Object)"Cannot set the compressed size if compression method is not DEFLATE.");
        this.mCompressedSize = compressedSize;
    }

    public CompressionMethod getMethod() {
        return this.mMethod;
    }

    public void setMethod(CompressionMethod method) {
        if (method == CompressionMethod.STORE) {
            Preconditions.checkState((this.mCompressedSize == this.mUncompressedSize ? 1 : 0) != 0, (String)"Cannot mark a file as STORE if the compressed size (%s) is not the same as the uncompressed size (%s).", (Object[])new Object[]{this.mCompressedSize, this.mUncompressedSize});
        }
        this.mMethod = method;
    }

    public long getCrc32() {
        return this.mCrc32;
    }

    public void setCrc32(long crc32) {
        this.mCrc32 = crc32;
    }

    public long getMadeBy() {
        return this.mMadeBy;
    }

    public void setMadeBy(long madeBy) {
        this.mMadeBy = madeBy;
    }

    public long getVersionExtract() {
        return this.mVersionExtract;
    }

    public void setVersionExtract(long versionExtract) {
        this.mVersionExtract = versionExtract;
    }

    public GPFlags getGpBit() {
        return this.mGpBit;
    }

    public void setGpBit(GPFlags gpBit) {
        this.mGpBit = gpBit;
    }

    public long getLastModTime() {
        return this.mLastModTime;
    }

    public void setLastModTime(long lastModTime) {
        this.mLastModTime = lastModTime;
    }

    public long getLastModDate() {
        return this.mLastModDate;
    }

    public void setLastModDate(long lastModDate) {
        this.mLastModDate = lastModDate;
    }

    public byte[] getExtraField() {
        return this.mExtraField;
    }

    public void setExtraField(byte[] extraField) {
        this.mExtraField = extraField;
    }

    public byte[] getComment() {
        return this.mComment;
    }

    public void setComment(byte[] comment) {
        this.mComment = comment;
    }

    public long getInternalAttributes() {
        return this.mInternalAttributes;
    }

    public void setInternalAttributes(long internalAttributes) {
        this.mInternalAttributes = internalAttributes;
    }

    public long getExternalAttributes() {
        return this.mExternalAttributes;
    }

    public void setExternalAttributes(long externalAttributes) {
        this.mExternalAttributes = externalAttributes;
    }

    public long getOffset() {
        return this.mOffset;
    }

    public void setOffset(long offset) {
        this.mOffset = offset;
    }

    protected CentralDirectoryHeader clone() throws CloneNotSupportedException {
        CentralDirectoryHeader cdr = (CentralDirectoryHeader)super.clone();
        cdr.mExtraField = Arrays.copyOf(this.mExtraField, this.mExtraField.length);
        cdr.mComment = Arrays.copyOf(this.mComment, this.mComment.length);
        return cdr;
    }
}

