(function() {
  var CompositeDisposable, Disposable, MRUListView, TabBarView, _, getIconServices, layout, ref;

  ref = require('atom'), CompositeDisposable = ref.CompositeDisposable, Disposable = ref.Disposable;

  getIconServices = require('./get-icon-services');

  layout = require('./layout');

  TabBarView = require('./tab-bar-view');

  MRUListView = require('./mru-list-view');

  _ = require('underscore-plus');

  module.exports = {
    activate: function(state) {
      var base, base1, base2, base3, base4, enableMruConfigKey, keyBindSource, paneContainers, ref1;
      this.subscriptions = new CompositeDisposable();
      layout.activate();
      this.tabBarViews = [];
      this.mruListViews = [];
      keyBindSource = 'tabs package';
      enableMruConfigKey = 'tabs.enableMruTabSwitching';
      this.updateTraversalKeybinds = function() {
        var bindings, disabledBindings;
        bindings = atom.keymaps.findKeyBindings({
          target: document.body,
          keystrokes: 'ctrl-tab'
        });
        if (bindings.length > 1 && bindings[0].source !== keyBindSource) {
          return;
        }
        bindings = atom.keymaps.findKeyBindings({
          target: document.body,
          keystrokes: 'ctrl-shift-tab'
        });
        if (bindings.length > 1 && bindings[0].source !== keyBindSource) {
          return;
        }
        if (atom.config.get(enableMruConfigKey)) {
          return atom.keymaps.removeBindingsFromSource(keyBindSource);
        } else {
          disabledBindings = {
            'body': {
              'ctrl-tab': 'pane:show-next-item',
              'ctrl-tab ^ctrl': 'unset!',
              'ctrl-shift-tab': 'pane:show-previous-item',
              'ctrl-shift-tab ^ctrl': 'unset!'
            }
          };
          return atom.keymaps.add(keyBindSource, disabledBindings, 0);
        }
      };
      this.subscriptions.add(atom.config.observe(enableMruConfigKey, (function(_this) {
        return function() {
          return _this.updateTraversalKeybinds();
        };
      })(this)));
      this.subscriptions.add(typeof (base = atom.keymaps).onDidLoadUserKeymap === "function" ? base.onDidLoadUserKeymap((function(_this) {
        return function() {
          return _this.updateTraversalKeybinds();
        };
      })(this)) : void 0);
      this.subscriptions.add(atom.commands.add('atom-workspace', {
        'tabs:close-all-tabs': (function(_this) {
          return function() {
            var i, ref1, results, tabBarView;
            ref1 = _this.tabBarViews;
            results = [];
            for (i = ref1.length - 1; i >= 0; i += -1) {
              tabBarView = ref1[i];
              results.push(tabBarView.closeAllTabs());
            }
            return results;
          };
        })(this)
      }));
      paneContainers = {
        center: (ref1 = typeof (base1 = atom.workspace).getCenter === "function" ? base1.getCenter() : void 0) != null ? ref1 : atom.workspace,
        left: typeof (base2 = atom.workspace).getLeftDock === "function" ? base2.getLeftDock() : void 0,
        right: typeof (base3 = atom.workspace).getRightDock === "function" ? base3.getRightDock() : void 0,
        bottom: typeof (base4 = atom.workspace).getBottomDock === "function" ? base4.getBottomDock() : void 0
      };
      return Object.keys(paneContainers).forEach((function(_this) {
        return function(location) {
          var container;
          container = paneContainers[location];
          if (!container) {
            return;
          }
          return _this.subscriptions.add(container.observePanes(function(pane) {
            var mruListView, paneElement, tabBarView;
            tabBarView = new TabBarView(pane, location);
            mruListView = new MRUListView;
            mruListView.initialize(pane);
            paneElement = pane.getElement();
            paneElement.insertBefore(tabBarView.element, paneElement.firstChild);
            _this.tabBarViews.push(tabBarView);
            pane.onDidDestroy(function() {
              return _.remove(_this.tabBarViews, tabBarView);
            });
            _this.mruListViews.push(mruListView);
            return pane.onDidDestroy(function() {
              return _.remove(_this.mruListViews, mruListView);
            });
          }));
        };
      })(this));
    },
    deactivate: function() {
      var i, j, len, len1, mruListView, ref1, ref2, ref3, tabBarView;
      layout.deactivate();
      this.subscriptions.dispose();
      if ((ref1 = this.fileIconsDisposable) != null) {
        ref1.dispose();
      }
      ref2 = this.tabBarViews;
      for (i = 0, len = ref2.length; i < len; i++) {
        tabBarView = ref2[i];
        tabBarView.destroy();
      }
      ref3 = this.mruListViews;
      for (j = 0, len1 = ref3.length; j < len1; j++) {
        mruListView = ref3[j];
        mruListView.destroy();
      }
    },
    consumeElementIcons: function(service) {
      getIconServices().setElementIcons(service);
      this.updateFileIcons();
      return new Disposable((function(_this) {
        return function() {
          getIconServices().resetElementIcons();
          return _this.updateFileIcons();
        };
      })(this));
    },
    consumeFileIcons: function(service) {
      getIconServices().setFileIcons(service);
      this.updateFileIcons();
      return new Disposable((function(_this) {
        return function() {
          getIconServices().resetFileIcons();
          return _this.updateFileIcons();
        };
      })(this));
    },
    updateFileIcons: function() {
      var i, len, ref1, results, tabBarView, tabView;
      ref1 = this.tabBarViews;
      results = [];
      for (i = 0, len = ref1.length; i < len; i++) {
        tabBarView = ref1[i];
        results.push((function() {
          var j, len1, ref2, results1;
          ref2 = tabBarView.getTabs();
          results1 = [];
          for (j = 0, len1 = ref2.length; j < len1; j++) {
            tabView = ref2[j];
            results1.push(tabView.updateIcon());
          }
          return results1;
        })());
      }
      return results;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNS4xL291dC9hcHAvbm9kZV9tb2R1bGVzL3RhYnMvbGliL21haW4uY29mZmVlIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0FBQUEsTUFBQTs7RUFBQSxNQUFvQyxPQUFBLENBQVEsTUFBUixDQUFwQyxFQUFDLDZDQUFELEVBQXNCOztFQUN0QixlQUFBLEdBQWtCLE9BQUEsQ0FBUSxxQkFBUjs7RUFDbEIsTUFBQSxHQUFTLE9BQUEsQ0FBUSxVQUFSOztFQUNULFVBQUEsR0FBYSxPQUFBLENBQVEsZ0JBQVI7O0VBQ2IsV0FBQSxHQUFjLE9BQUEsQ0FBUSxpQkFBUjs7RUFDZCxDQUFBLEdBQUksT0FBQSxDQUFRLGlCQUFSOztFQUVKLE1BQU0sQ0FBQyxPQUFQLEdBQ0U7SUFBQSxRQUFBLEVBQVUsU0FBQyxLQUFEO0FBQ1IsVUFBQTtNQUFBLElBQUMsQ0FBQSxhQUFELEdBQWlCLElBQUksbUJBQUosQ0FBQTtNQUNqQixNQUFNLENBQUMsUUFBUCxDQUFBO01BQ0EsSUFBQyxDQUFBLFdBQUQsR0FBZTtNQUNmLElBQUMsQ0FBQSxZQUFELEdBQWdCO01BRWhCLGFBQUEsR0FBZ0I7TUFDaEIsa0JBQUEsR0FBcUI7TUFFckIsSUFBQyxDQUFBLHVCQUFELEdBQTJCLFNBQUE7QUFFekIsWUFBQTtRQUFBLFFBQUEsR0FBVyxJQUFJLENBQUMsT0FBTyxDQUFDLGVBQWIsQ0FDVDtVQUFBLE1BQUEsRUFBUSxRQUFRLENBQUMsSUFBakI7VUFDQSxVQUFBLEVBQVksVUFEWjtTQURTO1FBR1gsSUFBVSxRQUFRLENBQUMsTUFBVCxHQUFrQixDQUFsQixJQUF3QixRQUFTLENBQUEsQ0FBQSxDQUFFLENBQUMsTUFBWixLQUF3QixhQUExRDtBQUFBLGlCQUFBOztRQUNBLFFBQUEsR0FBVyxJQUFJLENBQUMsT0FBTyxDQUFDLGVBQWIsQ0FDVDtVQUFBLE1BQUEsRUFBUSxRQUFRLENBQUMsSUFBakI7VUFDQSxVQUFBLEVBQVksZ0JBRFo7U0FEUztRQUdYLElBQVUsUUFBUSxDQUFDLE1BQVQsR0FBa0IsQ0FBbEIsSUFBd0IsUUFBUyxDQUFBLENBQUEsQ0FBRSxDQUFDLE1BQVosS0FBd0IsYUFBMUQ7QUFBQSxpQkFBQTs7UUFFQSxJQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBWixDQUFnQixrQkFBaEIsQ0FBSDtpQkFDRSxJQUFJLENBQUMsT0FBTyxDQUFDLHdCQUFiLENBQXNDLGFBQXRDLEVBREY7U0FBQSxNQUFBO1VBR0UsZ0JBQUEsR0FDRTtZQUFBLE1BQUEsRUFDRTtjQUFBLFVBQUEsRUFBWSxxQkFBWjtjQUNBLGdCQUFBLEVBQWtCLFFBRGxCO2NBRUEsZ0JBQUEsRUFBa0IseUJBRmxCO2NBR0Esc0JBQUEsRUFBd0IsUUFIeEI7YUFERjs7aUJBS0YsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFiLENBQWlCLGFBQWpCLEVBQWdDLGdCQUFoQyxFQUFrRCxDQUFsRCxFQVRGOztNQVh5QjtNQXNCM0IsSUFBQyxDQUFBLGFBQWEsQ0FBQyxHQUFmLENBQW1CLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBWixDQUFvQixrQkFBcEIsRUFBd0MsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFBO2lCQUFHLEtBQUMsQ0FBQSx1QkFBRCxDQUFBO1FBQUg7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQXhDLENBQW5CO01BQ0EsSUFBQyxDQUFBLGFBQWEsQ0FBQyxHQUFmLHVFQUErQixDQUFDLG9CQUFxQixDQUFBLFNBQUEsS0FBQTtlQUFBLFNBQUE7aUJBQUcsS0FBQyxDQUFBLHVCQUFELENBQUE7UUFBSDtNQUFBLENBQUEsQ0FBQSxDQUFBLElBQUEsV0FBckQ7TUFJQSxJQUFDLENBQUEsYUFBYSxDQUFDLEdBQWYsQ0FBbUIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFkLENBQWtCLGdCQUFsQixFQUNqQjtRQUFBLHFCQUFBLEVBQXVCLENBQUEsU0FBQSxLQUFBO2lCQUFBLFNBQUE7QUFHckIsZ0JBQUE7QUFBQTtBQUFBO2lCQUFBLG9DQUFBOzsyQkFDRSxVQUFVLENBQUMsWUFBWCxDQUFBO0FBREY7O1VBSHFCO1FBQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUF2QjtPQURpQixDQUFuQjtNQU9BLGNBQUEsR0FDRTtRQUFBLE1BQUEsa0hBQXNDLElBQUksQ0FBQyxTQUEzQztRQUNBLElBQUEsb0VBQW9CLENBQUMsc0JBRHJCO1FBRUEsS0FBQSxxRUFBcUIsQ0FBQyx1QkFGdEI7UUFHQSxNQUFBLHNFQUFzQixDQUFDLHdCQUh2Qjs7YUFLRixNQUFNLENBQUMsSUFBUCxDQUFZLGNBQVosQ0FBMkIsQ0FBQyxPQUE1QixDQUFvQyxDQUFBLFNBQUEsS0FBQTtlQUFBLFNBQUMsUUFBRDtBQUNsQyxjQUFBO1VBQUEsU0FBQSxHQUFZLGNBQWUsQ0FBQSxRQUFBO1VBQzNCLElBQUEsQ0FBYyxTQUFkO0FBQUEsbUJBQUE7O2lCQUNBLEtBQUMsQ0FBQSxhQUFhLENBQUMsR0FBZixDQUFtQixTQUFTLENBQUMsWUFBVixDQUF1QixTQUFDLElBQUQ7QUFDeEMsZ0JBQUE7WUFBQSxVQUFBLEdBQWEsSUFBSSxVQUFKLENBQWUsSUFBZixFQUFxQixRQUFyQjtZQUNiLFdBQUEsR0FBYyxJQUFJO1lBQ2xCLFdBQVcsQ0FBQyxVQUFaLENBQXVCLElBQXZCO1lBRUEsV0FBQSxHQUFjLElBQUksQ0FBQyxVQUFMLENBQUE7WUFDZCxXQUFXLENBQUMsWUFBWixDQUF5QixVQUFVLENBQUMsT0FBcEMsRUFBNkMsV0FBVyxDQUFDLFVBQXpEO1lBRUEsS0FBQyxDQUFBLFdBQVcsQ0FBQyxJQUFiLENBQWtCLFVBQWxCO1lBQ0EsSUFBSSxDQUFDLFlBQUwsQ0FBa0IsU0FBQTtxQkFBRyxDQUFDLENBQUMsTUFBRixDQUFTLEtBQUMsQ0FBQSxXQUFWLEVBQXVCLFVBQXZCO1lBQUgsQ0FBbEI7WUFDQSxLQUFDLENBQUEsWUFBWSxDQUFDLElBQWQsQ0FBbUIsV0FBbkI7bUJBQ0EsSUFBSSxDQUFDLFlBQUwsQ0FBa0IsU0FBQTtxQkFBRyxDQUFDLENBQUMsTUFBRixDQUFTLEtBQUMsQ0FBQSxZQUFWLEVBQXdCLFdBQXhCO1lBQUgsQ0FBbEI7VUFYd0MsQ0FBdkIsQ0FBbkI7UUFIa0M7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQXBDO0lBakRRLENBQVY7SUFpRUEsVUFBQSxFQUFZLFNBQUE7QUFDVixVQUFBO01BQUEsTUFBTSxDQUFDLFVBQVAsQ0FBQTtNQUNBLElBQUMsQ0FBQSxhQUFhLENBQUMsT0FBZixDQUFBOztZQUNvQixDQUFFLE9BQXRCLENBQUE7O0FBQ0E7QUFBQSxXQUFBLHNDQUFBOztRQUFBLFVBQVUsQ0FBQyxPQUFYLENBQUE7QUFBQTtBQUNBO0FBQUEsV0FBQSx3Q0FBQTs7UUFBQSxXQUFXLENBQUMsT0FBWixDQUFBO0FBQUE7SUFMVSxDQWpFWjtJQXlFQSxtQkFBQSxFQUFxQixTQUFDLE9BQUQ7TUFDbkIsZUFBQSxDQUFBLENBQWlCLENBQUMsZUFBbEIsQ0FBa0MsT0FBbEM7TUFDQSxJQUFDLENBQUEsZUFBRCxDQUFBO2FBQ0EsSUFBSSxVQUFKLENBQWUsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFBO1VBQ2IsZUFBQSxDQUFBLENBQWlCLENBQUMsaUJBQWxCLENBQUE7aUJBQ0EsS0FBQyxDQUFBLGVBQUQsQ0FBQTtRQUZhO01BQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUFmO0lBSG1CLENBekVyQjtJQWdGQSxnQkFBQSxFQUFrQixTQUFDLE9BQUQ7TUFDaEIsZUFBQSxDQUFBLENBQWlCLENBQUMsWUFBbEIsQ0FBK0IsT0FBL0I7TUFDQSxJQUFDLENBQUEsZUFBRCxDQUFBO2FBQ0EsSUFBSSxVQUFKLENBQWUsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFBO1VBQ2IsZUFBQSxDQUFBLENBQWlCLENBQUMsY0FBbEIsQ0FBQTtpQkFDQSxLQUFDLENBQUEsZUFBRCxDQUFBO1FBRmE7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQWY7SUFIZ0IsQ0FoRmxCO0lBdUZBLGVBQUEsRUFBaUIsU0FBQTtBQUNmLFVBQUE7QUFBQTtBQUFBO1dBQUEsc0NBQUE7Ozs7QUFDRTtBQUFBO2VBQUEsd0NBQUE7OzBCQUFBLE9BQU8sQ0FBQyxVQUFSLENBQUE7QUFBQTs7O0FBREY7O0lBRGUsQ0F2RmpCOztBQVJGIiwic291cmNlc0NvbnRlbnQiOlsie0NvbXBvc2l0ZURpc3Bvc2FibGUsIERpc3Bvc2FibGV9ID0gcmVxdWlyZSAnYXRvbSdcbmdldEljb25TZXJ2aWNlcyA9IHJlcXVpcmUgJy4vZ2V0LWljb24tc2VydmljZXMnXG5sYXlvdXQgPSByZXF1aXJlICcuL2xheW91dCdcblRhYkJhclZpZXcgPSByZXF1aXJlICcuL3RhYi1iYXItdmlldydcbk1SVUxpc3RWaWV3ID0gcmVxdWlyZSAnLi9tcnUtbGlzdC12aWV3J1xuXyA9IHJlcXVpcmUgJ3VuZGVyc2NvcmUtcGx1cydcblxubW9kdWxlLmV4cG9ydHMgPVxuICBhY3RpdmF0ZTogKHN0YXRlKSAtPlxuICAgIEBzdWJzY3JpcHRpb25zID0gbmV3IENvbXBvc2l0ZURpc3Bvc2FibGUoKVxuICAgIGxheW91dC5hY3RpdmF0ZSgpXG4gICAgQHRhYkJhclZpZXdzID0gW11cbiAgICBAbXJ1TGlzdFZpZXdzID0gW11cblxuICAgIGtleUJpbmRTb3VyY2UgPSAndGFicyBwYWNrYWdlJ1xuICAgIGVuYWJsZU1ydUNvbmZpZ0tleSA9ICd0YWJzLmVuYWJsZU1ydVRhYlN3aXRjaGluZydcblxuICAgIEB1cGRhdGVUcmF2ZXJzYWxLZXliaW5kcyA9IC0+XG4gICAgICAjIFdlIGRvbid0IG1vZGlmeSBrZXliaW5kaW5ncyBiYXNlZCBvbiBvdXIgc2V0dGluZyBpZiB0aGUgdXNlciBoYXMgYWxyZWFkeSB0d2Vha2VkIHRoZW0uXG4gICAgICBiaW5kaW5ncyA9IGF0b20ua2V5bWFwcy5maW5kS2V5QmluZGluZ3MoXG4gICAgICAgIHRhcmdldDogZG9jdW1lbnQuYm9keSxcbiAgICAgICAga2V5c3Ryb2tlczogJ2N0cmwtdGFiJylcbiAgICAgIHJldHVybiBpZiBiaW5kaW5ncy5sZW5ndGggPiAxIGFuZCBiaW5kaW5nc1swXS5zb3VyY2UgaXNudCBrZXlCaW5kU291cmNlXG4gICAgICBiaW5kaW5ncyA9IGF0b20ua2V5bWFwcy5maW5kS2V5QmluZGluZ3MoXG4gICAgICAgIHRhcmdldDogZG9jdW1lbnQuYm9keSxcbiAgICAgICAga2V5c3Ryb2tlczogJ2N0cmwtc2hpZnQtdGFiJylcbiAgICAgIHJldHVybiBpZiBiaW5kaW5ncy5sZW5ndGggPiAxIGFuZCBiaW5kaW5nc1swXS5zb3VyY2UgaXNudCBrZXlCaW5kU291cmNlXG5cbiAgICAgIGlmIGF0b20uY29uZmlnLmdldChlbmFibGVNcnVDb25maWdLZXkpXG4gICAgICAgIGF0b20ua2V5bWFwcy5yZW1vdmVCaW5kaW5nc0Zyb21Tb3VyY2Uoa2V5QmluZFNvdXJjZSlcbiAgICAgIGVsc2VcbiAgICAgICAgZGlzYWJsZWRCaW5kaW5ncyA9XG4gICAgICAgICAgJ2JvZHknOlxuICAgICAgICAgICAgJ2N0cmwtdGFiJzogJ3BhbmU6c2hvdy1uZXh0LWl0ZW0nXG4gICAgICAgICAgICAnY3RybC10YWIgXmN0cmwnOiAndW5zZXQhJ1xuICAgICAgICAgICAgJ2N0cmwtc2hpZnQtdGFiJzogJ3BhbmU6c2hvdy1wcmV2aW91cy1pdGVtJ1xuICAgICAgICAgICAgJ2N0cmwtc2hpZnQtdGFiIF5jdHJsJzogJ3Vuc2V0ISdcbiAgICAgICAgYXRvbS5rZXltYXBzLmFkZChrZXlCaW5kU291cmNlLCBkaXNhYmxlZEJpbmRpbmdzLCAwKVxuXG4gICAgQHN1YnNjcmlwdGlvbnMuYWRkIGF0b20uY29uZmlnLm9ic2VydmUgZW5hYmxlTXJ1Q29uZmlnS2V5LCA9PiBAdXBkYXRlVHJhdmVyc2FsS2V5YmluZHMoKVxuICAgIEBzdWJzY3JpcHRpb25zLmFkZCBhdG9tLmtleW1hcHMub25EaWRMb2FkVXNlcktleW1hcD8gPT4gQHVwZGF0ZVRyYXZlcnNhbEtleWJpbmRzKClcblxuICAgICMgSWYgdGhlIGNvbW1hbmQgYnViYmxlcyB1cCB3aXRob3V0IGJlaW5nIGhhbmRsZWQgYnkgYSBwYXJ0aWN1bGFyIHBhbmUsXG4gICAgIyBjbG9zZSBhbGwgdGFicyBpbiBhbGwgcGFuZXNcbiAgICBAc3Vic2NyaXB0aW9ucy5hZGQgYXRvbS5jb21tYW5kcy5hZGQgJ2F0b20td29ya3NwYWNlJyxcbiAgICAgICd0YWJzOmNsb3NlLWFsbC10YWJzJzogPT5cbiAgICAgICAgIyBXZSBsb29wIGJhY2t3YXJkcyBiZWNhdXNlIHRoZSBwYW5lcyBhcmVcbiAgICAgICAgIyByZW1vdmVkIGZyb20gdGhlIGFycmF5IGFzIHdlIGdvXG4gICAgICAgIGZvciB0YWJCYXJWaWV3IGluIEB0YWJCYXJWaWV3cyBieSAtMVxuICAgICAgICAgIHRhYkJhclZpZXcuY2xvc2VBbGxUYWJzKClcblxuICAgIHBhbmVDb250YWluZXJzID1cbiAgICAgIGNlbnRlcjogYXRvbS53b3Jrc3BhY2UuZ2V0Q2VudGVyPygpID8gYXRvbS53b3Jrc3BhY2VcbiAgICAgIGxlZnQ6IGF0b20ud29ya3NwYWNlLmdldExlZnREb2NrPygpXG4gICAgICByaWdodDogYXRvbS53b3Jrc3BhY2UuZ2V0UmlnaHREb2NrPygpXG4gICAgICBib3R0b206IGF0b20ud29ya3NwYWNlLmdldEJvdHRvbURvY2s/KClcblxuICAgIE9iamVjdC5rZXlzKHBhbmVDb250YWluZXJzKS5mb3JFYWNoIChsb2NhdGlvbikgPT5cbiAgICAgIGNvbnRhaW5lciA9IHBhbmVDb250YWluZXJzW2xvY2F0aW9uXVxuICAgICAgcmV0dXJuIHVubGVzcyBjb250YWluZXJcbiAgICAgIEBzdWJzY3JpcHRpb25zLmFkZCBjb250YWluZXIub2JzZXJ2ZVBhbmVzIChwYW5lKSA9PlxuICAgICAgICB0YWJCYXJWaWV3ID0gbmV3IFRhYkJhclZpZXcocGFuZSwgbG9jYXRpb24pXG4gICAgICAgIG1ydUxpc3RWaWV3ID0gbmV3IE1SVUxpc3RWaWV3XG4gICAgICAgIG1ydUxpc3RWaWV3LmluaXRpYWxpemUocGFuZSlcblxuICAgICAgICBwYW5lRWxlbWVudCA9IHBhbmUuZ2V0RWxlbWVudCgpXG4gICAgICAgIHBhbmVFbGVtZW50Lmluc2VydEJlZm9yZSh0YWJCYXJWaWV3LmVsZW1lbnQsIHBhbmVFbGVtZW50LmZpcnN0Q2hpbGQpXG5cbiAgICAgICAgQHRhYkJhclZpZXdzLnB1c2godGFiQmFyVmlldylcbiAgICAgICAgcGFuZS5vbkRpZERlc3Ryb3kgPT4gXy5yZW1vdmUoQHRhYkJhclZpZXdzLCB0YWJCYXJWaWV3KVxuICAgICAgICBAbXJ1TGlzdFZpZXdzLnB1c2gobXJ1TGlzdFZpZXcpXG4gICAgICAgIHBhbmUub25EaWREZXN0cm95ID0+IF8ucmVtb3ZlKEBtcnVMaXN0Vmlld3MsIG1ydUxpc3RWaWV3KVxuXG4gIGRlYWN0aXZhdGU6IC0+XG4gICAgbGF5b3V0LmRlYWN0aXZhdGUoKVxuICAgIEBzdWJzY3JpcHRpb25zLmRpc3Bvc2UoKVxuICAgIEBmaWxlSWNvbnNEaXNwb3NhYmxlPy5kaXNwb3NlKClcbiAgICB0YWJCYXJWaWV3LmRlc3Ryb3koKSBmb3IgdGFiQmFyVmlldyBpbiBAdGFiQmFyVmlld3NcbiAgICBtcnVMaXN0Vmlldy5kZXN0cm95KCkgZm9yIG1ydUxpc3RWaWV3IGluIEBtcnVMaXN0Vmlld3NcbiAgICByZXR1cm5cblxuICBjb25zdW1lRWxlbWVudEljb25zOiAoc2VydmljZSkgLT5cbiAgICBnZXRJY29uU2VydmljZXMoKS5zZXRFbGVtZW50SWNvbnMgc2VydmljZVxuICAgIEB1cGRhdGVGaWxlSWNvbnMoKVxuICAgIG5ldyBEaXNwb3NhYmxlID0+XG4gICAgICBnZXRJY29uU2VydmljZXMoKS5yZXNldEVsZW1lbnRJY29ucygpXG4gICAgICBAdXBkYXRlRmlsZUljb25zKClcblxuICBjb25zdW1lRmlsZUljb25zOiAoc2VydmljZSkgLT5cbiAgICBnZXRJY29uU2VydmljZXMoKS5zZXRGaWxlSWNvbnMgc2VydmljZVxuICAgIEB1cGRhdGVGaWxlSWNvbnMoKVxuICAgIG5ldyBEaXNwb3NhYmxlID0+XG4gICAgICBnZXRJY29uU2VydmljZXMoKS5yZXNldEZpbGVJY29ucygpXG4gICAgICBAdXBkYXRlRmlsZUljb25zKClcblxuICB1cGRhdGVGaWxlSWNvbnM6IC0+XG4gICAgZm9yIHRhYkJhclZpZXcgaW4gQHRhYkJhclZpZXdzXG4gICAgICB0YWJWaWV3LnVwZGF0ZUljb24oKSBmb3IgdGFiVmlldyBpbiB0YWJCYXJWaWV3LmdldFRhYnMoKVxuIl19
