'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _githubLoginView = require('./github-login-view');

var _githubLoginView2 = _interopRequireDefault(_githubLoginView);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class QueryErrorView extends _react2.default.Component {

  render() {
    const e = this.props.error;

    if (e.response) {
      switch (e.response.status) {
        case 401:
          return this.render401();
        case 200:
          // Do the default
          break;
        default:
          return this.renderUnknown(e.response, e.responseText);
      }
    }

    if (e.errors) {
      return this.renderGraphQLErrors(e.errors);
    }

    return _react2.default.createElement(_errorView2.default, _extends({
      title: e.message,
      descriptions: [e.stack],
      preformatted: true
    }, this.errorViewProps()));
  }

  renderGraphQLErrors(errors) {
    return _react2.default.createElement(_errorView2.default, _extends({
      title: 'Query errors reported',
      descriptions: errors.map(e => e.message)
    }, this.errorViewProps()));
  }

  render401() {
    return _react2.default.createElement(
      'div',
      { className: 'github-GithubLoginView-Container' },
      _react2.default.createElement(
        _githubLoginView2.default,
        { onLogin: this.props.login },
        _react2.default.createElement(
          'p',
          null,
          'The API endpoint returned a unauthorized error. Please try to re-authenticate with the endpoint.'
        )
      )
    );
  }

  renderUnknown(response, text) {
    return _react2.default.createElement(_errorView2.default, _extends({
      title: `Received an error response: ${response.status}`,
      descriptions: [text],
      preformatted: true
    }, this.errorViewProps()));
  }

  errorViewProps() {
    return {
      retry: this.props.retry,
      logout: this.props.logout
    };
  }
}
exports.default = QueryErrorView;
QueryErrorView.propTypes = {
  error: _propTypes2.default.shape({
    name: _propTypes2.default.string.isRequired,
    message: _propTypes2.default.string.isRequired,
    stack: _propTypes2.default.string.isRequired,
    response: _propTypes2.default.shape({
      status: _propTypes2.default.number.isRequired
    }),
    responseText: _propTypes2.default.string,
    errors: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      message: _propTypes2.default.string.isRequired
    }))
  }).isRequired,
  login: _propTypes2.default.func.isRequired,
  retry: _propTypes2.default.func,
  logout: _propTypes2.default.func
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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