'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _commands = require('../atom/commands');

var _commands2 = _interopRequireDefault(_commands);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CredentialDialog extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'confirm', 'cancel', 'onUsernameChange', 'onPasswordChange', 'onRememberChange', 'focusFirstInput', 'toggleShowPassword');

    this.state = {
      username: '',
      password: '',
      remember: false,
      showPassword: false
    };
  }

  componentDidMount() {
    setTimeout(this.focusFirstInput);
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-Credentials modal native-key-bindings' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-Credentials' },
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancel }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.confirm })
      ),
      _react2.default.createElement(
        'header',
        { className: 'github-DialogPrompt' },
        this.props.prompt
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-DialogInputs' },
        this.props.includeUsername ? _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel' },
          'Username:',
          _react2.default.createElement('input', {
            type: 'text',
            ref: e => this.usernameInput = e,
            className: 'input-text github-CredentialDialog-Username',
            value: this.state.username,
            onChange: this.onUsernameChange,
            tabIndex: '1'
          })
        ) : null,
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel' },
          'Password:',
          _react2.default.createElement('input', {
            type: this.state.showPassword ? 'text' : 'password',
            ref: e => this.passwordInput = e,
            className: 'input-text github-CredentialDialog-Password',
            value: this.state.password,
            onChange: this.onPasswordChange,
            tabIndex: '2'
          }),
          _react2.default.createElement(
            'button',
            { className: 'github-DialogLabelButton', onClick: this.toggleShowPassword },
            this.state.showPassword ? 'Hide' : 'Show'
          )
        )
      ),
      _react2.default.createElement(
        'footer',
        { className: 'github-DialogButtons' },
        this.props.includeRemember ? _react2.default.createElement(
          'label',
          { className: 'github-DialogButtons-leftItem input-label' },
          _react2.default.createElement('input', {
            className: 'github-CredentialDialog-remember input-checkbox',
            type: 'checkbox',
            checked: this.state.remember,
            onChange: this.onRememberChange
          }),
          'Remember'
        ) : null,
        _react2.default.createElement(
          'button',
          { className: 'btn github-CancelButton', tabIndex: '3', onClick: this.cancel },
          'Cancel'
        ),
        _react2.default.createElement(
          'button',
          { className: 'btn btn-primary', tabIndex: '4', onClick: this.confirm },
          'Sign in'
        )
      )
    );
  }

  confirm() {
    const payload = { password: this.state.password };

    if (this.props.includeUsername) {
      payload.username = this.state.username;
    }

    if (this.props.includeRemember) {
      payload.remember = this.state.remember;
    }

    this.props.onSubmit(payload);
  }

  cancel() {
    this.props.onCancel();
  }

  onUsernameChange(e) {
    this.setState({ username: e.target.value });
  }

  onPasswordChange(e) {
    this.setState({ password: e.target.value });
  }

  onRememberChange(e) {
    this.setState({ remember: e.target.checked });
  }

  focusFirstInput() {
    (this.usernameInput || this.passwordInput).focus();
  }

  toggleShowPassword() {
    this.setState({ showPassword: !this.state.showPassword });
  }
}
exports.default = CredentialDialog;
CredentialDialog.propTypes = {
  commandRegistry: _propTypes2.default.object.isRequired,
  prompt: _propTypes2.default.string.isRequired,
  includeUsername: _propTypes2.default.bool,
  includeRemember: _propTypes2.default.bool,
  onSubmit: _propTypes2.default.func,
  onCancel: _propTypes2.default.func
};
CredentialDialog.defaultProps = {
  includeUsername: false,
  includeRemember: false,
  onSubmit: () => {},
  onCancel: () => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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