"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

class PartialFileDiscardHistory {
  constructor(maxHistoryLength) {
    this.blobHistoryByFilePath = {};
    this.maxHistoryLength = maxHistoryLength || 60;
  }

  getHistoryForPath(filePath) {
    const history = this.blobHistoryByFilePath[filePath];
    if (history) {
      return history;
    } else {
      this.setHistoryForPath(filePath, []);
      return this.blobHistoryByFilePath[filePath];
    }
  }

  setHistoryForPath(filePath, history) {
    this.blobHistoryByFilePath[filePath] = history;
  }

  getHistory() {
    return this.blobHistoryByFilePath;
  }

  setHistory(history) {
    this.blobHistoryByFilePath = history;
  }

  popHistoryForPath(filePath) {
    return this.getHistoryForPath(filePath).pop();
  }

  addHistory(filePath, snapshots) {
    const history = this.getHistoryForPath(filePath);
    history.push(snapshots);
    if (history.length >= this.maxHistoryLength) {
      this.setHistoryForPath(filePath, history.slice(Math.ceil(this.maxHistoryLength / 2)));
    }
  }

  getLastSnapshotsForPath(filePath) {
    const history = this.getHistoryForPath(filePath);
    const snapshots = history[history.length - 1];
    if (!snapshots) {
      return null;
    }
    return _extends({ filePath }, snapshots);
  }

  clearHistoryForPath(filePath) {
    this.setHistoryForPath(filePath, []);
  }
}

exports.PartialFileDiscardHistory = PartialFileDiscardHistory;
class WholeFileDiscardHistory {
  constructor(maxHistoryLength) {
    this.blobHistory = [];
    this.maxHistoryLength = maxHistoryLength || 60;
  }

  getHistory() {
    return this.blobHistory;
  }

  setHistory(history) {
    this.blobHistory = history;
  }

  popHistory() {
    return this.getHistory().pop();
  }

  addHistory(snapshotsByPath) {
    const history = this.getHistory();
    history.push(snapshotsByPath);
    if (history.length >= this.maxHistoryLength) {
      this.setHistory(history.slice(Math.ceil(this.maxHistoryLength / 2)));
    }
  }

  getLastSnapshots() {
    const history = this.getHistory();
    const snapshotsByPath = history[history.length - 1] || {};
    return Object.keys(snapshotsByPath).map(p => {
      return _extends({ filePath: p }, snapshotsByPath[p]);
    });
  }

  clearHistory() {
    this.setHistory([]);
  }
}
exports.WholeFileDiscardHistory = WholeFileDiscardHistory;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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