'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.default = IssueishLink;
exports.handleClickEvent = handleClickEvent;
exports.openIssueishLinkInNewTab = openIssueishLinkInNewTab;
exports.openLinkInBrowser = openLinkInBrowser;
exports.getDataFromGithubUrl = getDataFromGithubUrl;

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _electron = require('electron');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _issueishDetailItem = require('../items/issueish-detail-item');

var _issueishDetailItem2 = _interopRequireDefault(_issueishDetailItem);

var _reporterProxy = require('../reporter-proxy');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

// eslint-disable-next-line no-shadow
function IssueishLink(_ref) {
  let { url, children } = _ref,
      others = _objectWithoutProperties(_ref, ['url', 'children']);

  function clickHandler(event) {
    handleClickEvent(event, url);
  }

  return _react2.default.createElement(
    'a',
    _extends({}, others, { onClick: clickHandler }),
    children
  );
}

IssueishLink.propTypes = {
  url: _propTypes2.default.string.isRequired,
  children: _propTypes2.default.node
};

// eslint-disable-next-line no-shadow
function handleClickEvent(event, url) {
  event.preventDefault();
  event.stopPropagation();
  if (!event.shiftKey) {
    return openIssueishLinkInNewTab(url, { activate: !(event.metaKey || event.ctrlKey) });
  } else {
    // Open in browser if shift key held
    return openLinkInBrowser(url);
  }
}

// eslint-disable-next-line no-shadow
function openIssueishLinkInNewTab(url, options = {}) {
  const uri = getAtomUriForGithubUrl(url);
  if (uri) {
    return openInNewTab(uri, options);
  } else {
    return null;
  }
}

function openLinkInBrowser(uri) {
  return new Promise((resolve, reject) => {
    _electron.shell.openExternal(uri, {}, err => {
      if (err) {
        reject(err);
      } else {
        (0, _reporterProxy.addEvent)('open-issueish-in-browser', { package: 'github', from: 'issueish-link' });
        resolve();
      }
    });
  });
}

function getAtomUriForGithubUrl(githubUrl) {
  return getUriForData(getDataFromGithubUrl(githubUrl));
}

function getDataFromGithubUrl(githubUrl) {
  const { hostname, pathname } = _url2.default.parse(githubUrl);
  const [repoOwner, repoName, type, issueishNumber] = pathname.split('/').filter(s => s);
  return { hostname, repoOwner, repoName, type, issueishNumber: parseInt(issueishNumber, 10) };
}

function getUriForData({ hostname, repoOwner, repoName, type, issueishNumber }) {
  if (hostname !== 'github.com' || !['pull', 'issues'].includes(type) || !issueishNumber || isNaN(issueishNumber)) {
    return null;
  } else {
    return _issueishDetailItem2.default.buildURI('https://api.github.com', repoOwner, repoName, issueishNumber);
  }
}

function openInNewTab(uri, { activate } = { activate: true }) {
  return atom.workspace.open(uri, { activateItem: activate }).then(() => {
    (0, _reporterProxy.addEvent)('open-issueish-in-pane', { package: 'github', from: 'issueish-link', target: 'new-tab' });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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