'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _propTypes3 = require('../prop-types');

var _commitPreviewContainer = require('../containers/commit-preview-container');

var _commitPreviewContainer2 = _interopRequireDefault(_commitPreviewContainer);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CommitPreviewItem extends _react2.default.Component {

  static buildURI(workingDirectory) {
    return `atom-github://commit-preview?workdir=${encodeURIComponent(workingDirectory)}`;
  }

  constructor(props) {
    super(props);

    this.destroy = () => {
      /* istanbul ignore else */
      if (!this.isDestroyed) {
        this.emitter.emit('did-destroy');
        this.isDestroyed = true;
      }
    };

    this.emitter = new _eventKit.Emitter();
    this.isDestroyed = false;
    this.hasTerminatedPendingState = false;
    this.refInitialFocus = new _refHolder2.default();
  }

  terminatePendingState() {
    if (!this.hasTerminatedPendingState) {
      this.emitter.emit('did-terminate-pending-state');
      this.hasTerminatedPendingState = true;
    }
  }

  onDidTerminatePendingState(callback) {
    return this.emitter.on('did-terminate-pending-state', callback);
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  render() {
    const repository = this.props.workdirContextPool.getContext(this.props.workingDirectory).getRepository();

    return _react2.default.createElement(_commitPreviewContainer2.default, _extends({
      itemType: this.constructor,
      repository: repository
    }, this.props, {
      destroy: this.destroy,
      refInitialFocus: this.refInitialFocus
    }));
  }

  getTitle() {
    return 'Staged Changes';
  }

  getIconName() {
    return 'tasklist';
  }

  getWorkingDirectory() {
    return this.props.workingDirectory;
  }

  serialize() {
    return {
      deserializer: 'CommitPreviewStub',
      uri: CommitPreviewItem.buildURI(this.props.workingDirectory)
    };
  }

  focus() {
    this.refInitialFocus.map(focusable => focusable.focus());
  }
}
exports.default = CommitPreviewItem;
CommitPreviewItem.propTypes = {
  workdirContextPool: _propTypes3.WorkdirContextPoolPropType.isRequired,
  workingDirectory: _propTypes2.default.string.isRequired,

  discardLines: _propTypes2.default.func.isRequired,
  undoLastDiscard: _propTypes2.default.func.isRequired,
  surfaceToCommitPreviewButton: _propTypes2.default.func.isRequired
};
CommitPreviewItem.uriPattern = 'atom-github://commit-preview?workdir={workingDirectory}';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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