/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.contributions.GPGDetachedSignatureVerifier;
import cc.arduino.contributions.SignatureVerificationFailedException;
import cc.arduino.contributions.VersionComparator;
import cc.arduino.contributions.libraries.LibrariesIndexer;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ContributedTool;
import cc.arduino.contributions.packages.ContributionsIndexer;
import cc.arduino.files.DeleteFilesOnShutdown;
import cc.arduino.packages.BoardPort;
import cc.arduino.packages.DiscoveryManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.logging.impl.NoOpLog;
import processing.app.I18n;
import processing.app.Platform;
import processing.app.PreferencesData;
import processing.app.debug.LegacyTargetPackage;
import processing.app.debug.LegacyTargetPlatform;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.debug.TargetPlatformException;
import processing.app.helpers.BasicUserNotifier;
import processing.app.helpers.CommandlineParser;
import processing.app.helpers.FileUtils;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.UserNotifier;
import processing.app.helpers.filefilters.OnlyDirs;
import processing.app.helpers.filefilters.OnlyFilesWithExtension;
import processing.app.legacy.PApplet;
import processing.app.packages.LibraryList;
import processing.app.packages.UserLibrary;
import processing.app.packages.UserLibraryFolder;

public class BaseNoGui {
    public static final int REVISION = 10808;
    public static final String VERSION_NAME = "1.8.8";
    public static final String VERSION_NAME_LONG;
    static String currentDirectory;
    private static DiscoveryManager discoveryManager;
    private static File examplesFolder;
    private static File toolsFolder;
    public static Map<String, LibraryList> importToLibraryTable;
    private static List<UserLibraryFolder> librariesFolders;
    static UserNotifier notifier;
    public static Map<String, TargetPackage> packages;
    static Platform platform;
    static File portableFolder;
    static final String portableSketchbookFolder = "sketchbook";
    public static ContributionsIndexer indexer;
    public static LibrariesIndexer librariesIndexer;
    private static String boardManagerLink;
    private static File buildCache;
    protected static PropertyChangeSupport propertyChangeSupport;

    public static File absoluteFile(String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(currentDirectory, path);
        }
        return file;
    }

    public static int countLines(String what) {
        int count = 1;
        for (char c : what.toCharArray()) {
            if (c != '\n') continue;
            ++count;
        }
        return count;
    }

    public static PreferencesMap getBoardPreferences() {
        String core;
        TargetBoard board = BaseNoGui.getTargetBoard();
        if (board == null) {
            return null;
        }
        String boardId = board.getId();
        PreferencesMap prefs = new PreferencesMap(board.getPreferences());
        String extendedName = (String)prefs.get("name");
        for (String menuId : board.getMenuIds()) {
            String entry;
            if (!board.hasMenu(menuId) || (entry = PreferencesData.get("custom_" + menuId)) == null || !entry.startsWith(boardId)) continue;
            String selectionId = entry.substring(boardId.length() + 1);
            prefs.putAll(board.getMenuPreferences(menuId, selectionId));
            extendedName = extendedName + ", " + board.getMenuLabel(menuId, selectionId);
        }
        prefs.put("name", extendedName);
        ArrayList<ContributedTool> requiredTools = new ArrayList<ContributedTool>();
        ContributedPlatform p = indexer.getContributedPlaform(BaseNoGui.getTargetPlatform());
        if (p != null) {
            requiredTools.addAll(p.getResolvedTools());
        }
        if ((core = (String)prefs.get("build.core")) != null && core.contains(":")) {
            String[] split = core.split(":");
            TargetPlatform referenced = BaseNoGui.getCurrentTargetPlatformFromPackage(split[0]);
            if (referenced != null) {
                ContributedPlatform referencedPlatform = indexer.getContributedPlaform(referenced);
                if (referencedPlatform != null) {
                    requiredTools.addAll(referencedPlatform.getResolvedTools());
                }
            } else {
                String msg = I18n.tr("The current selected board needs the core '{0}' that is not installed.");
                System.out.println(I18n.format(msg, core));
            }
        }
        String prefix = "runtime.tools.";
        for (ContributedTool tool : requiredTools) {
            File folder = tool.getInstalledFolder();
            if (folder == null) continue;
            String toolPath = folder.getAbsolutePath();
            prefs.put(prefix + tool.getName() + ".path", toolPath);
            prefs.put(prefix + tool.getName() + "-" + tool.getVersion() + ".path", toolPath);
            PreferencesData.set(prefix + tool.getName() + ".path", toolPath);
            PreferencesData.set(prefix + tool.getName() + "-" + tool.getVersion() + ".path", toolPath);
        }
        return prefs;
    }

    public static File getContentFile(String name) {
        String appDir = System.getProperty("APP_DIR");
        if (appDir == null || appDir.length() == 0) {
            appDir = currentDirectory;
        }
        File installationFolder = new File(appDir);
        return new File(installationFolder, name);
    }

    public static TargetPlatform getCurrentTargetPlatformFromPackage(String pack) {
        return BaseNoGui.getTargetPlatform(pack, PreferencesData.get("target_platform"));
    }

    public static File getDefaultSketchbookFolder() {
        if (BaseNoGui.getPortableFolder() != null) {
            return new File(BaseNoGui.getPortableFolder(), BaseNoGui.getPortableSketchbookFolder());
        }
        File sketchbookFolder = null;
        try {
            sketchbookFolder = BaseNoGui.getPlatform().getDefaultSketchbookFolder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sketchbookFolder;
    }

    public static DiscoveryManager getDiscoveryManager() {
        if (discoveryManager == null) {
            discoveryManager = new DiscoveryManager();
        }
        return discoveryManager;
    }

    public static File getExamplesFolder() {
        return examplesFolder;
    }

    public static String getExamplesPath() {
        return examplesFolder.getAbsolutePath();
    }

    public static File getHardwareFolder() {
        return BaseNoGui.getContentFile("hardware");
    }

    public static String getHardwarePath() {
        return BaseNoGui.getHardwareFolder().getAbsolutePath();
    }

    public static List<UserLibraryFolder> getLibrariesFolders() {
        return librariesFolders;
    }

    public static Platform getPlatform() {
        return platform;
    }

    public static File getPortableFolder() {
        return portableFolder;
    }

    public static String getPortableSketchbookFolder() {
        return portableSketchbookFolder;
    }

    public static File getCachePath() {
        if (buildCache == null) {
            try {
                buildCache = FileUtils.createTempFolder("arduino_cache_");
                DeleteFilesOnShutdown.add(buildCache);
            }
            catch (IOException e) {
                return null;
            }
        }
        return buildCache;
    }

    public static File getSettingsFile(String filename) {
        return new File(BaseNoGui.getSettingsFolder(), filename);
    }

    public static File getSettingsFolder() {
        if (BaseNoGui.getPortableFolder() != null) {
            return BaseNoGui.getPortableFolder();
        }
        File settingsFolder = null;
        String preferencesPath = PreferencesData.get("settings.path");
        if (preferencesPath != null) {
            settingsFolder = BaseNoGui.absoluteFile(preferencesPath);
        } else {
            try {
                settingsFolder = BaseNoGui.getPlatform().getSettingsFolder();
            }
            catch (Exception e) {
                BaseNoGui.showError(I18n.tr("Problem getting data folder"), I18n.tr("Error getting the Arduino data folder."), e);
            }
        }
        if (!settingsFolder.exists() && !settingsFolder.mkdirs()) {
            BaseNoGui.showError(I18n.tr("Settings issues"), I18n.tr("Arduino cannot run because it could not\ncreate a folder to store your settings."), null);
        }
        return settingsFolder;
    }

    public static File getSketchbookFolder() {
        String sketchBookPath = PreferencesData.get("sketchbook.path");
        if (BaseNoGui.getPortableFolder() != null && !new File(sketchBookPath).isAbsolute()) {
            return new File(BaseNoGui.getPortableFolder(), sketchBookPath);
        }
        return BaseNoGui.absoluteFile(sketchBookPath);
    }

    public static File getSketchbookHardwareFolder() {
        return new File(BaseNoGui.getSketchbookFolder(), "hardware");
    }

    public static UserLibraryFolder getSketchbookLibrariesFolder() {
        File libdir = new File(BaseNoGui.getSketchbookFolder(), "libraries");
        if (!libdir.exists()) {
            FileWriter freadme = null;
            try {
                libdir.mkdirs();
                freadme = new FileWriter(new File(libdir, "readme.txt"));
                freadme.write(I18n.tr("For information on installing libraries, see: http://www.arduino.cc/en/Guide/Libraries\n"));
            }
            catch (Exception exception) {
                IOUtils.closeQuietly(freadme);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(freadme);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)freadme);
        }
        return new UserLibraryFolder(libdir, UserLibraryFolder.Location.SKETCHBOOK);
    }

    public static String getSketchbookPath() {
        File sketchbookFolder;
        String sketchbookPath = PreferencesData.get("sketchbook.path");
        if (sketchbookPath != null && !(sketchbookFolder = BaseNoGui.getPortableFolder() != null && !new File(sketchbookPath).isAbsolute() ? new File(BaseNoGui.getPortableFolder(), sketchbookPath) : BaseNoGui.absoluteFile(sketchbookPath)).exists()) {
            BaseNoGui.showWarning(I18n.tr("Sketchbook folder disappeared"), I18n.tr("The sketchbook folder no longer exists.\nArduino will switch to the default sketchbook\nlocation, and create a new sketchbook folder if\nnecessary. Arduino will then stop talking about\nhimself in the third person."), null);
            sketchbookPath = null;
        }
        return sketchbookPath;
    }

    public static TargetBoard getTargetBoard() {
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        if (targetPlatform == null) {
            return null;
        }
        String boardId = PreferencesData.get("board");
        return targetPlatform.getBoard(boardId);
    }

    public static TargetPackage getTargetPackage(String packageName) {
        return packages.get(packageName);
    }

    public static TargetPlatform getTargetPlatform() {
        String packageName = PreferencesData.get("target_package");
        String platformName = PreferencesData.get("target_platform");
        return BaseNoGui.getTargetPlatform(packageName, platformName);
    }

    public static TargetPlatform getTargetPlatform(String packageName, String platformName) {
        TargetPackage p = packages.get(packageName);
        if (p == null) {
            return null;
        }
        return p.get(platformName);
    }

    public static File getToolsFolder() {
        return toolsFolder;
    }

    public static String getToolsPath() {
        return toolsFolder.getAbsolutePath();
    }

    public static String getBoardManagerLink() {
        return boardManagerLink;
    }

    public static void setBoardManagerLink(String temp) {
        boardManagerLink = temp;
        propertyChangeSupport.firePropertyChange("boardManagerLink", "", boardManagerLink);
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public static String[] headerListFromIncludePath(File path) throws IOException {
        String[] list = path.list(new OnlyFilesWithExtension(".h", ".hh", ".hpp"));
        if (list == null) {
            throw new IOException();
        }
        return list;
    }

    protected static void dumpPrefs(CommandlineParser parser) {
        if (parser.getGetPref() != null) {
            String value = PreferencesData.get(parser.getGetPref(), null);
            if (value != null) {
                System.out.println(value);
                System.exit(0);
            } else {
                System.exit(4);
            }
        } else {
            System.out.println("#PREFDUMP#");
            PreferencesMap prefs = PreferencesData.getMap();
            for (Map.Entry entry : prefs.entrySet()) {
                System.out.println((String)entry.getKey() + "=" + (String)entry.getValue());
            }
            System.exit(0);
        }
    }

    public static void initLogger() {
        System.setProperty("org.apache.commons.logging.Log", NoOpLog.class.getCanonicalName());
        Logger.getLogger("javax.jmdns").setLevel(Level.OFF);
    }

    public static void initPackages() throws Exception {
        indexer = new ContributionsIndexer(BaseNoGui.getSettingsFolder(), BaseNoGui.getHardwareFolder(), BaseNoGui.getPlatform(), new GPGDetachedSignatureVerifier());
        try {
            indexer.parseIndex();
        }
        catch (SignatureVerificationFailedException | JsonProcessingException e) {
            File indexFile = indexer.getIndexFile("package_index.json");
            File indexSignatureFile = indexer.getIndexFile("package_index.json.sig");
            FileUtils.deleteIfExists(indexFile);
            FileUtils.deleteIfExists(indexSignatureFile);
            throw e;
        }
        indexer.syncWithFilesystem();
        packages = new LinkedHashMap<String, TargetPackage>();
        BaseNoGui.loadHardware(BaseNoGui.getHardwareFolder());
        BaseNoGui.loadContributedHardware(indexer);
        BaseNoGui.loadHardware(BaseNoGui.getSketchbookHardwareFolder());
        BaseNoGui.createToolPreferences(indexer.getInstalledTools(), true);
        librariesIndexer = new LibrariesIndexer(BaseNoGui.getSettingsFolder());
        try {
            librariesIndexer.parseIndex();
        }
        catch (JsonProcessingException e) {
            File librariesIndexFile = librariesIndexer.getIndexFile();
            FileUtils.deleteIfExists(librariesIndexFile);
        }
        if (discoveryManager == null) {
            discoveryManager = new DiscoveryManager();
        }
    }

    protected static void initPlatform() {
        try {
            Class<?> platformClass = Class.forName("processing.app.Platform");
            if (OSUtils.isMacOS()) {
                platformClass = Class.forName("processing.app.macosx.Platform");
            } else if (OSUtils.isWindows()) {
                platformClass = Class.forName("processing.app.windows.Platform");
            } else if (OSUtils.isLinux()) {
                platformClass = Class.forName("processing.app.linux.Platform");
            }
            platform = (Platform)platformClass.newInstance();
        }
        catch (Exception e) {
            BaseNoGui.showError(I18n.tr("Problem Setting the Platform"), I18n.tr("An unknown error occurred while trying to load\nplatform-specific code for your machine."), e);
        }
    }

    public static void initPortableFolder() {
        portableFolder = BaseNoGui.getContentFile("portable");
        if (!portableFolder.exists()) {
            portableFolder = null;
        }
    }

    public static void initVersion() {
        PreferencesData.set("last.ide.1.8.8.hardwarepath", BaseNoGui.getHardwarePath());
        PreferencesData.set("last.ide.1.8.8.daterun", "" + new Date().getTime() / 1000L);
    }

    public static boolean isSanitaryName(String name) {
        return BaseNoGui.sanitizeName(name).equals(name);
    }

    protected static void loadHardware(File folder) {
        if (!folder.isDirectory()) {
            return;
        }
        String[] list = folder.list(new OnlyDirs());
        if (list == null) {
            return;
        }
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        for (String target : list) {
            TargetPackage targetPackage;
            if (target.equals("tools")) continue;
            File subfolder = new File(folder, target);
            if (packages.containsKey(target)) {
                targetPackage = packages.get(target);
            } else {
                targetPackage = new LegacyTargetPackage(target);
                packages.put(target, targetPackage);
            }
            try {
                BaseNoGui.loadTargetPackage(targetPackage, subfolder);
            }
            catch (TargetPlatformException e) {
                System.out.println("WARNING: Error loading hardware folder " + new File(folder, target));
                System.out.println("  " + e.getMessage());
            }
        }
    }

    private static void loadTargetPackage(TargetPackage targetPackage, File _folder) throws TargetPlatformException {
        File[] folders = _folder.listFiles(OnlyDirs.ONLY_DIRS);
        if (folders == null) {
            return;
        }
        for (File subFolder : folders) {
            if (!subFolder.exists() || !subFolder.canRead()) continue;
            String arch = subFolder.getName();
            try {
                LegacyTargetPlatform p = new LegacyTargetPlatform(arch, subFolder, targetPackage);
                targetPackage.getPlatforms().put(arch, p);
            }
            catch (TargetPlatformException e) {
                System.err.println(e.getMessage());
            }
        }
        if (targetPackage.getPlatforms().size() == 0) {
            throw new TargetPlatformException(I18n.format(I18n.tr("No valid hardware definitions found in folder {0}."), _folder.getName()));
        }
    }

    public static String loadFile(File file) throws IOException {
        String[] contents = PApplet.loadStrings(file);
        if (contents == null) {
            return null;
        }
        return PApplet.join(contents, "\n");
    }

    public static void checkInstallationFolder() {
        if (BaseNoGui.isIDEInstalledIntoSettingsFolder()) {
            BaseNoGui.showError(I18n.tr("Incorrect IDE installation folder"), I18n.tr("Your copy of the IDE is installed in a subfolder of your settings folder.\nPlease move the IDE to another folder."), 10);
        }
        if (BaseNoGui.isIDEInstalledIntoSketchbookFolder()) {
            BaseNoGui.showError(I18n.tr("Incorrect IDE installation folder"), I18n.tr("Your copy of the IDE is installed in a subfolder of your sketchbook.\nPlease move the IDE to another folder."), 10);
        }
    }

    public static boolean isIDEInstalledIntoSketchbookFolder() {
        return PreferencesData.has("sketchbook.path") && FileUtils.isSubDirectory(new File(PreferencesData.get("sketchbook.path")), new File(PreferencesData.get("runtime.ide.path")));
    }

    public static boolean isIDEInstalledIntoSettingsFolder() {
        try {
            return FileUtils.isSubDirectory(BaseNoGui.getPlatform().getSettingsFolder(), new File(PreferencesData.get("runtime.ide.path")));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void onBoardOrPortChange() {
        examplesFolder = BaseNoGui.getContentFile("examples");
        toolsFolder = BaseNoGui.getContentFile("tools");
        librariesFolders = new ArrayList<UserLibraryFolder>();
        librariesFolders.add(new UserLibraryFolder(BaseNoGui.getContentFile("libraries"), UserLibraryFolder.Location.IDE_BUILTIN));
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        if (targetPlatform != null) {
            String referencedCore;
            TargetPlatform referencedPlatform;
            String core = BaseNoGui.getBoardPreferences().get("build.core", "arduino");
            if (core.contains(":") && (referencedPlatform = BaseNoGui.getTargetPlatform(referencedCore = core.split(":")[0], targetPlatform.getId())) != null) {
                File referencedPlatformFolder = referencedPlatform.getFolder();
                File folder = new File(referencedPlatformFolder, "libraries");
                librariesFolders.add(new UserLibraryFolder(folder, UserLibraryFolder.Location.REFERENCED_CORE));
            }
            File platformFolder = targetPlatform.getFolder();
            File folder = new File(platformFolder, "libraries");
            librariesFolders.add(new UserLibraryFolder(folder, UserLibraryFolder.Location.CORE));
        }
        librariesFolders.add(BaseNoGui.getSketchbookLibrariesFolder());
        librariesIndexer.setLibrariesFolders(librariesFolders);
        librariesIndexer.setArchitecturePriority(BaseNoGui.getTargetPlatform().getId());
        librariesIndexer.rescanLibraries();
        BaseNoGui.populateImportToLibraryTable();
    }

    protected static void loadContributedHardware(ContributionsIndexer idx) {
        for (TargetPackage pack : idx.createTargetPackages()) {
            packages.put(pack.getId(), pack);
        }
    }

    public static void createToolPreferences(Collection<ContributedTool> installedTools, boolean removeOldKeys) {
        String prefix = "runtime.tools.";
        if (removeOldKeys) {
            PreferencesData.removeAllKeysWithPrefix(prefix);
        }
        HashMap<String, String> latestVersions = new HashMap<String, String>();
        for (ContributedTool tool : installedTools) {
            File installedFolder = tool.getInstalledFolder();
            String toolPath = installedFolder != null ? installedFolder.getAbsolutePath() : "___REMOVE___";
            String toolName = tool.getName();
            String toolVersion = tool.getVersion();
            PreferencesData.set(prefix + toolName + "-" + toolVersion + ".path", toolPath);
            PreferencesData.set(prefix + tool.getPackager() + "-" + toolName + "-" + toolVersion + ".path", toolPath);
            try {
                if (latestVersions.containsKey(toolName) && !VersionComparator.greaterThan(toolVersion, (String)latestVersions.get(toolName))) continue;
                latestVersions.put(toolName, toolVersion);
                PreferencesData.set(prefix + toolName + ".path", toolPath);
            }
            catch (Exception exception) {}
        }
    }

    public static void populateImportToLibraryTable() {
        importToLibraryTable = new HashMap<String, LibraryList>();
        for (UserLibrary lib : librariesIndexer.getInstalledLibraries()) {
            try {
                String[] headers;
                for (String header : headers = BaseNoGui.headerListFromIncludePath(lib.getSrcFolder())) {
                    LibraryList list = importToLibraryTable.get(header);
                    if (list == null) {
                        list = new LibraryList();
                        list.addFirst(lib);
                        importToLibraryTable.put(header, list);
                        continue;
                    }
                    UserLibrary old = (UserLibrary)list.peekFirst();
                    boolean useThisLib = true;
                    String name = header.substring(0, header.length() - 2);
                    String oldName = old.getInstalledFolder().getName();
                    String libName = lib.getInstalledFolder().getName();
                    String name_lc = name.toLowerCase();
                    String oldName_lc = oldName.toLowerCase();
                    String libName_lc = libName.toLowerCase();
                    if (!libName.equals(name)) {
                        if (oldName.equals(name)) {
                            useThisLib = false;
                        } else if (!libName.equals(name + "-master")) {
                            if (oldName.equals(name + "-master")) {
                                useThisLib = false;
                            } else if (!libName.startsWith(name)) {
                                if (oldName.startsWith(name)) {
                                    useThisLib = false;
                                } else if (!libName.endsWith(name)) {
                                    if (oldName.endsWith(name)) {
                                        useThisLib = false;
                                    } else if (!libName.contains(name)) {
                                        if (oldName.contains(name)) {
                                            useThisLib = false;
                                        } else if (!libName_lc.equals(name_lc)) {
                                            if (oldName_lc.equals(name_lc)) {
                                                useThisLib = false;
                                            } else if (!libName_lc.equals(name_lc + "-master")) {
                                                if (oldName_lc.equals(name_lc + "-master")) {
                                                    useThisLib = false;
                                                } else if (!libName_lc.startsWith(name_lc)) {
                                                    if (oldName_lc.startsWith(name_lc)) {
                                                        useThisLib = false;
                                                    } else if (!libName_lc.endsWith(name_lc)) {
                                                        if (oldName_lc.endsWith(name_lc)) {
                                                            useThisLib = false;
                                                        } else if (!libName_lc.contains(name_lc) && oldName_lc.contains(name_lc)) {
                                                            useThisLib = false;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (useThisLib) {
                        list.addFirst(lib);
                        continue;
                    }
                    list.addLast(lib);
                }
            }
            catch (IOException e) {
                BaseNoGui.showWarning(I18n.tr("Error"), I18n.format("Unable to list header files in {0}", lib.getSrcFolder()), e);
            }
        }
    }

    public static void initParameters(String[] args) throws Exception {
        String preferencesFile = null;
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals("--preferences-file")) continue;
            preferencesFile = args[++i];
        }
        PreferencesData.init(BaseNoGui.absoluteFile(preferencesFile));
    }

    public static String sanitizeName(String origName) {
        char[] c = origName.toCharArray();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] >= '0' && c[i] <= '9' || c[i] >= 'a' && c[i] <= 'z' || c[i] >= 'A' && c[i] <= 'Z' || i > 0 && c[i] == '-' || i > 0 && c[i] == '.') {
                buffer.append(c[i]);
                continue;
            }
            buffer.append('_');
        }
        if (buffer.length() > 63) {
            buffer.setLength(63);
        }
        return buffer.toString();
    }

    public static void saveFile(String str, File file) throws IOException {
        boolean result;
        String[] strArray;
        File temp = File.createTempFile(file.getName(), null, file.getParentFile());
        for (String item : strArray = str.split("\n")) {
            item.trim();
        }
        PApplet.saveStrings(temp, strArray);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file.exists() && !(result = file.delete())) {
            throw new IOException(I18n.format(I18n.tr("Could not remove old version of {0}"), file.getAbsolutePath()));
        }
        result = temp.renameTo(file);
        if (!result) {
            throw new IOException(I18n.format(I18n.tr("Could not replace {0}"), file.getAbsolutePath()));
        }
    }

    public static void selectBoard(TargetBoard targetBoard) {
        TargetPlatform targetPlatform = targetBoard.getContainerPlatform();
        TargetPackage targetPackage = targetPlatform.getContainerPackage();
        PreferencesData.set("target_package", targetPackage.getId());
        PreferencesData.set("target_platform", targetPlatform.getId());
        PreferencesData.set("board", targetBoard.getId());
        File platformFolder = targetPlatform.getFolder();
        PreferencesData.set("runtime.platform.path", platformFolder.getAbsolutePath());
        PreferencesData.set("runtime.hardware.path", platformFolder.getParentFile().getAbsolutePath());
    }

    public static void selectSerialPort(String port) {
        PreferencesData.set("serial.port", port);
        BoardPort boardPort = BaseNoGui.getDiscoveryManager().find(port, true);
        if (boardPort != null) {
            PreferencesData.set("serial.port.iserial", (String)boardPort.getPrefs().get("iserial"));
        }
        String portFile = port;
        if (port.startsWith("/dev/")) {
            portFile = portFile.substring(5);
        }
        PreferencesData.set("serial.port.file", portFile);
    }

    public static void showError(String title, String message, int exit_code) {
        BaseNoGui.showError(title, message, null, exit_code);
    }

    public static void showError(String title, String message, Throwable e) {
        notifier.showError(title, message, e, 1);
    }

    public static void showError(String title, String message, Throwable e, int exit_code) {
        notifier.showError(title, message, e, exit_code);
    }

    public static void showMessage(String title, String message) {
        notifier.showMessage(title, message);
    }

    public static void showWarning(String title, String message, Exception e) {
        notifier.showWarning(title, message, e);
    }

    static {
        File windowsStoreConfig;
        currentDirectory = System.getProperty("user.dir");
        String versionNameLong = VERSION_NAME;
        File hourlyBuildTxt = new File(BaseNoGui.getContentFile("lib"), "hourlyBuild.txt");
        if (hourlyBuildTxt.exists() && hourlyBuildTxt.canRead()) {
            versionNameLong = versionNameLong + " Hourly Build";
            try {
                versionNameLong = versionNameLong + " " + FileUtils.readFileToString(hourlyBuildTxt).trim();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((windowsStoreConfig = new File(BaseNoGui.getContentFile("lib"), "windowsStore.txt")).exists()) {
            try {
                PreferencesMap conf = new PreferencesMap(windowsStoreConfig);
                PreferencesData.setBoolean("runtime.is-windows-store-app", true);
                PreferencesData.set("runtime.windows-store-app.id", (String)conf.get("appid"));
                versionNameLong = versionNameLong + " (Windows Store " + (String)conf.get("version") + ")";
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        VERSION_NAME_LONG = versionNameLong;
        notifier = new BasicUserNotifier();
        portableFolder = null;
        boardManagerLink = "";
        propertyChangeSupport = new PropertyChangeSupport(BaseNoGui.class);
    }
}

