/*
 * Decompiled with CFR 0.152.
 */
package com.thizzer.jtouchbar;

import com.thizzer.jtouchbar.JTouchBarJNI;
import com.thizzer.jtouchbar.awt.AWTUtils;
import com.thizzer.jtouchbar.item.TouchBarItem;
import com.thizzer.jtouchbar.javafx.JavaFXUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.stage.Window;

public class JTouchBar {
    private String _customizationIdentifier;
    private String _principalItemIdentifier;
    private List<TouchBarItem> _items;

    public String getCustomizationIdentifier() {
        return this._customizationIdentifier;
    }

    public void setCustomizationIdentifier(String customizationIdentifier) {
        this._customizationIdentifier = customizationIdentifier;
    }

    public String getPrincipalItemIdentifier() {
        return this._principalItemIdentifier;
    }

    public void setPrincipalItemIdentifier(String principalItemIdentifier) {
        this._principalItemIdentifier = principalItemIdentifier;
    }

    public List<TouchBarItem> getItems() {
        if (this._items == null) {
            this._items = new ArrayList<TouchBarItem>();
        }
        return this._items;
    }

    public void setItems(List<TouchBarItem> items) {
        this._items = items;
    }

    public void addItem(TouchBarItem touchBarItem) {
        this.getItems().add(touchBarItem);
    }

    public void show(Component c) {
        long viewPointer = AWTUtils.getViewPointer(c);
        JTouchBarJNI.setTouchBar0(viewPointer, this);
    }

    public void show(final Window window) {
        if (window == null) {
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                long viewPointer = JavaFXUtils.getViewPointer(window);
                JTouchBarJNI.setTouchBar0(viewPointer, JTouchBar.this);
            }
        });
    }

    public void show(long window) {
        JTouchBarJNI.setTouchBar0(window, this);
    }

    public void hide(Component c) {
        if (c == null) {
            return;
        }
        long viewPointer = AWTUtils.getViewPointer(c);
        JTouchBarJNI.setTouchBar0(viewPointer, null);
    }

    public void hide(Window window) {
        long viewPointer = JavaFXUtils.getViewPointer(window);
        JTouchBarJNI.setTouchBar0(viewPointer, null);
    }

    public void hide(long window) {
        JTouchBarJNI.setTouchBar0(window, null);
    }
}

