/// <reference types="platform" />
declare enum OperatingSystem {
    ANDROID = "OperatingSystem.ANDROID",
    IOS = "OperatingSystem.IOS",
    LINUX = "OperatingSystem.LINUX",
    MAC = "OperatingSystem.MAC",
    WINDOWS = "OperatingSystem.WINDOWS"
}
declare class Runtime {
    private static getPlatform;
    static getOSFamily(): OperatingSystem;
    static getBrowserName(): string;
    static getBrowserVersion(): {
        major: number;
        minor: number;
    };
    static getUserAgent(): string;
    static isWebappSupportedBrowser(): boolean;
    static getOS(): {
        architecture: string;
        family: string;
        version: string;
    } | {
        architecture: string | number;
        family: string;
        version: string;
        toString(): string;
    };
    static isChrome(): boolean;
    static isEdge(): boolean;
    static isFirefox(): boolean;
    static isInternetExplorer(): boolean;
    static isOpera(): boolean;
    static isSafari(): boolean;
    static isDesktopOS(): boolean;
    static isElectron(): boolean;
    static isDesktopApp(): boolean;
    static isFranz(): boolean;
    static isMacOS(): boolean;
    static isWindows(): boolean;
    static isLinux(): boolean;
    static isMobileOS(): boolean;
    static isAndroid(): boolean;
    static isIOS(): boolean;
}
export { OperatingSystem, Runtime };
