/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.collect.Lists;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStructuredDocstringFormatter {
    private static final Logger LOG = Logger.getInstance(PyStructuredDocstringFormatter.class);
    private static final Charset DEFAULT_CHARSET = CharsetToolkit.UTF8_CHARSET;

    private PyStructuredDocstringFormatter() {
    }

    @Nullable
    public static List<String> formatDocstring(@NotNull PsiElement element, @NotNull String docstring) {
        Module module2;
        if (element == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(0);
        }
        if (docstring == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(1);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            Module[] modules = ModuleManager.getInstance((Project)element.getProject()).getModules();
            if (modules.length == 0) {
                return Lists.newArrayList();
            }
            module2 = modules[0];
        }
        if (module2 == null) {
            return Lists.newArrayList();
        }
        ArrayList<String> result = new ArrayList<String>();
        String preparedDocstring = PyIndentUtil.removeCommonIndent(docstring, true).trim();
        DocStringFormat format = DocStringUtil.guessDocStringFormat(preparedDocstring, element);
        if (format == DocStringFormat.PLAIN) {
            return null;
        }
        StructuredDocString structuredDocString = DocStringUtil.parseDocStringContent(format, preparedDocstring);
        String output = PyStructuredDocstringFormatter.runExternalTool(module2, format, preparedDocstring);
        if (output != null) {
            result.add(output);
        } else {
            result.add(structuredDocString.getDescription());
        }
        return result;
    }

    @Nullable
    private static String runExternalTool(@NotNull Module module2, @NotNull DocStringFormat format, @NotNull String docstring) {
        String missingInterpreterMessage;
        Sdk sdk;
        if (module2 == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(2);
        }
        if (format == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(3);
        }
        if (docstring == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return "Unittest placehoder";
        }
        if (format == DocStringFormat.EPYTEXT) {
            sdk = PythonSdkType.findPython2Sdk(module2);
            missingInterpreterMessage = PyBundle.message("QDOC.epydoc.python2.sdk.not.found", new Object[0]);
        } else {
            sdk = PythonSdkType.findLocalCPython(module2);
            missingInterpreterMessage = PyBundle.message("QDOC.local.sdk.not.found", new Object[0]);
        }
        if (sdk == null) {
            LOG.warn("Python SDK for docstring formatter " + (Object)((Object)format) + " is not found");
            return "<p color=\"red\">" + missingInterpreterMessage + "</p>";
        }
        String sdkHome = sdk.getHomePath();
        if (sdkHome == null) {
            return null;
        }
        ByteBuffer encoded = DEFAULT_CHARSET.encode(docstring);
        byte[] data = new byte[encoded.limit()];
        encoded.get(data);
        ArrayList arguments = Lists.newArrayList((Object[])new String[]{format.getFormatterCommand()});
        GeneralCommandLine commandLine = PythonHelper.DOCSTRING_FORMATTER.newCommandLine(sdk, (List<String>)arguments);
        commandLine.setCharset(DEFAULT_CHARSET);
        LOG.debug("Command for launching docstring formatter: " + commandLine.getCommandLineString());
        ProcessOutput output = PySdkUtil.getProcessOutput(commandLine, new File(sdkHome).getParent(), null, 5000, data, false);
        if (!output.checkSuccess(LOG)) {
            LOG.info("Malformed docstring:\n" + docstring);
            return null;
        }
        return output.getStdout();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docstring";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/documentation/docstrings/PyStructuredDocstringFormatter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "formatDocstring";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runExternalTool";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

