/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;

enum ScrollSource {
    MOUSE_WHEEL{
        private final RegistryValue ENABLED = Registry.get((String)"idea.true.smooth.scrolling.interpolation.mouse.wheel");
        private final RegistryValue MIN_DELAY = Registry.get((String)"idea.true.smooth.scrolling.interpolation.mouse.wheel.delay.min");
        private final RegistryValue MAX_DELAY = Registry.get((String)"idea.true.smooth.scrolling.interpolation.mouse.wheel.delay.max");

        @Override
        boolean isInterpolationEnabled() {
            return INTERPOLATION_ENABLED.asBoolean() && this.ENABLED.asBoolean();
        }

        @Override
        int getInterpolationDelay(double rotation) {
            if (!this.isInterpolationEnabled()) {
                return 0;
            }
            int min = this.MIN_DELAY.asInteger();
            int max = this.MAX_DELAY.asInteger();
            return Math.max(min, Math.min(max, (int)Math.round((double)max * Math.abs(rotation))));
        }
    }
    ,
    TOUCHPAD{
        private final RegistryValue ENABLED = Registry.get((String)"idea.true.smooth.scrolling.interpolation.precision.touchpad");
        private final RegistryValue DELAY = Registry.get((String)"idea.true.smooth.scrolling.interpolation.precision.touchpad.delay");

        @Override
        boolean isInterpolationEnabled() {
            return INTERPOLATION_ENABLED.asBoolean() && this.ENABLED.asBoolean();
        }

        @Override
        int getInterpolationDelay(double rotation) {
            return !this.isInterpolationEnabled() ? 0 : this.DELAY.asInteger();
        }
    }
    ,
    SCROLLBAR{
        private final RegistryValue ENABLED = Registry.get((String)"idea.true.smooth.scrolling.interpolation.scrollbar");
        private final RegistryValue DELAY = Registry.get((String)"idea.true.smooth.scrolling.interpolation.scrollbar.delay");

        @Override
        boolean isInterpolationEnabled() {
            return INTERPOLATION_ENABLED.asBoolean() && this.ENABLED.asBoolean();
        }

        @Override
        int getInterpolationDelay(double rotation) {
            return !this.isInterpolationEnabled() ? 0 : this.DELAY.asInteger();
        }
    }
    ,
    UNKNOWN{
        private final RegistryValue ENABLED = Registry.get((String)"idea.true.smooth.scrolling.interpolation.other");
        private final RegistryValue DELAY = Registry.get((String)"idea.true.smooth.scrolling.interpolation.other.delay");

        @Override
        boolean isInterpolationEnabled() {
            return INTERPOLATION_ENABLED.asBoolean() && this.ENABLED.asBoolean();
        }

        @Override
        int getInterpolationDelay(double rotation) {
            return !this.isInterpolationEnabled() ? 0 : this.DELAY.asInteger();
        }
    };

    private static final RegistryValue INTERPOLATION_ENABLED;

    abstract boolean isInterpolationEnabled();

    abstract int getInterpolationDelay(double var1);

    static {
        INTERPOLATION_ENABLED = Registry.get((String)"idea.true.smooth.scrolling.interpolation");
    }
}

