/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.Scrollable;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import processing.app.Base;
import processing.app.Platform;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionTab;
import processing.app.contrib.ContributionType;
import processing.app.contrib.DetailPanel;
import processing.app.contrib.ManagerFrame;
import processing.app.ui.Toolkit;

public class ListPanel
extends JPanel
implements Scrollable,
ContributionListing.ChangeListener {
    ContributionTab contributionTab;
    TreeMap<Contribution, DetailPanel> panelByContribution = new TreeMap(ContributionListing.COMPARATOR);
    private DetailPanel selectedPanel;
    protected ContributionRowFilter filter;
    protected JTable table;
    protected TableRowSorter<ContributionTableModel> sorter;
    ContributionTableModel model;
    JScrollPane scrollPane;
    static Icon upToDateIcon;
    static Icon updateAvailableIcon;
    static Icon incompatibleIcon;
    static Icon foundationIcon;
    static Icon downloadingIcon;
    static final Color HEADER_BGCOLOR;
    static final Color SECTION_COLOR;
    static final Color SELECTION_COLOR;
    static final SectionHeaderContribution[] sections;

    static {
        HEADER_BGCOLOR = new Color(-1315861);
        SECTION_COLOR = new Color(-460552);
        SELECTION_COLOR = new Color(-2031619);
        sections = new SectionHeaderContribution[]{new SectionHeaderContribution(ContributionType.LIBRARY), new SectionHeaderContribution(ContributionType.MODE), new SectionHeaderContribution(ContributionType.TOOL), new SectionHeaderContribution(ContributionType.EXAMPLES)};
    }

    public ListPanel() {
        if (upToDateIcon == null) {
            upToDateIcon = Toolkit.getLibIconX("manager/up-to-date");
            updateAvailableIcon = Toolkit.getLibIconX("manager/update-available");
            incompatibleIcon = Toolkit.getLibIconX("manager/incompatible");
            foundationIcon = Toolkit.getLibIconX("icons/foundation", 16);
            downloadingIcon = Toolkit.getLibIconX("manager/downloading");
        }
    }

    public ListPanel(final ContributionTab contributionTab, Contribution.Filter filter, boolean enableSections, ContributionColumn ... columns) {
        this();
        this.contributionTab = contributionTab;
        this.filter = new ContributionRowFilter(filter);
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.model = new ContributionTableModel(columns);
        this.model.enableSections(enableSections);
        this.table = new JTable(this.model){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                Object rowValue = this.getValueAt(row, column);
                if (rowValue instanceof SectionHeaderContribution) {
                    c.setBackground(SECTION_COLOR);
                } else if (this.isRowSelected(row)) {
                    c.setBackground(SELECTION_COLOR);
                } else {
                    c.setBackground(Color.white);
                }
                return c;
            }

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                if (!(this.getValueAt(rowIndex, columnIndex) instanceof SectionHeaderContribution)) {
                    super.changeSelection(rowIndex, columnIndex, toggle, extend);
                }
            }
        };
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Contribution.class, new ContribStatusRenderer());
        this.table.setFont(ManagerFrame.NORMAL_PLAIN);
        this.table.setRowHeight(Toolkit.zoom(28));
        this.table.setRowMargin(Toolkit.zoom(6));
        this.table.getColumnModel().setColumnMargin(0);
        this.table.getColumnModel().getColumn(0).setMaxWidth(ManagerFrame.STATUS_WIDTH);
        this.table.getColumnModel().getColumn(2).setMinWidth(ManagerFrame.AUTHOR_WIDTH);
        this.table.getColumnModel().getColumn(2).setMaxWidth(ManagerFrame.AUTHOR_WIDTH);
        this.table.setShowGrid(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setAutoCreateColumnsFromModel(true);
        this.table.setAutoCreateRowSorter(false);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (ListPanel.this.table.getSelectedRow() != -1) {
                    ListPanel.this.setSelectedPanel(ListPanel.this.panelByContribution.get(ListPanel.this.table.getValueAt(ListPanel.this.table.getSelectedRow(), 0)));
                    if (!contributionTab.filterHasFocus()) {
                        ListPanel.this.table.requestFocusInWindow();
                    }
                }
            }
        });
        this.sorter = new TableRowSorter<ContributionTableModel>(this.model);
        this.table.setRowSorter(this.sorter);
        this.sorter.setRowFilter(this.filter);
        int i = 0;
        while (i < this.model.getColumnCount()) {
            if (this.model.columns[i] == ContributionColumn.NAME) {
                this.sorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(i, SortOrder.ASCENDING)));
            }
            this.sorter.setComparator(i, this.model.columns[i].getComparator());
            ++i;
        }
        this.table.getTableHeader().setDefaultRenderer(new ContribHeaderRenderer());
        GroupLayout layout = new GroupLayout(this);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.scrollPane));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.scrollPane));
        this.setLayout(layout);
        this.table.setVisible(true);
    }

    private static int getContributionStatusRank(Contribution c) {
        int pos = 4;
        if (c.isInstalled()) {
            pos = 1;
            if (ContributionListing.getInstance().hasUpdates(c)) {
                pos = 2;
            }
            if (!c.isCompatible(Base.getRevision())) {
                pos = 3;
            }
        }
        return pos;
    }

    static String getAuthorNameWithoutMarkup(String authorList) {
        StringBuilder name = new StringBuilder();
        if (authorList != null) {
            int parentheses = 0;
            int i = 0;
            while (i < authorList.length()) {
                if (authorList.charAt(i) != '[' && authorList.charAt(i) != ']') {
                    if (authorList.charAt(i) == '(') {
                        ++parentheses;
                    } else if (authorList.charAt(i) == ')') {
                        --parentheses;
                    } else if (parentheses == 0) {
                        name.append(authorList.charAt(i));
                    }
                }
                ++i;
            }
        }
        return name.toString();
    }

    @Override
    public void contributionAdded(Contribution contribution) {
        if (!this.panelByContribution.containsKey(contribution)) {
            DetailPanel newPanel = new DetailPanel(this);
            this.panelByContribution.put(contribution, newPanel);
            newPanel.setContribution(contribution);
            this.add(newPanel);
            this.model.fireTableDataChanged();
            this.updateColors();
        }
    }

    @Override
    public void contributionRemoved(Contribution contribution) {
        DetailPanel panel = this.panelByContribution.get(contribution);
        if (panel != null) {
            this.remove(panel);
            this.panelByContribution.remove(contribution);
        }
        this.model.fireTableDataChanged();
        this.updateColors();
        this.updateUI();
    }

    @Override
    public void contributionChanged(Contribution oldContrib, Contribution newContrib) {
        DetailPanel panel = this.panelByContribution.get(oldContrib);
        if (panel == null) {
            this.contributionAdded(newContrib);
        } else {
            this.panelByContribution.remove(oldContrib);
            panel.setContribution(newContrib);
            this.panelByContribution.put(newContrib, panel);
            this.model.fireTableDataChanged();
        }
    }

    public void filterLibraries(String category, List<String> filters) {
        this.filter.setCategoryFilter(category);
        this.filter.setStringFilters(filters);
        this.model.fireTableDataChanged();
    }

    protected void setSelectedPanel(DetailPanel contributionPanel) {
        this.contributionTab.updateStatusPanel(contributionPanel);
        if (this.selectedPanel == contributionPanel) {
            this.selectedPanel.setSelected(true);
        } else {
            DetailPanel lastSelected = this.selectedPanel;
            this.selectedPanel = contributionPanel;
            if (lastSelected != null) {
                lastSelected.setSelected(false);
            }
            contributionPanel.setSelected(true);
            this.updateColors();
            this.requestFocusInWindow();
        }
    }

    protected DetailPanel getSelectedPanel() {
        return this.selectedPanel;
    }

    protected void updateColors() {
        int count = 0;
        for (Map.Entry<Contribution, DetailPanel> entry : this.panelByContribution.entrySet()) {
            DetailPanel panel = entry.getValue();
            Border border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            if (panel.isVisible()) {
                boolean oddRow = count % 2 == 1;
                Color bgColor = null;
                Color fgColor = UIManager.getColor("List.foreground");
                if (panel.isSelected()) {
                    bgColor = UIManager.getColor("List.selectionBackground");
                    fgColor = UIManager.getColor("List.selectionForeground");
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                } else if (Platform.isMacOS()) {
                    border = oddRow ? UIManager.getBorder("List.oddRowBackgroundPainter") : UIManager.getBorder("List.evenRowBackgroundPainter");
                } else {
                    bgColor = oddRow ? new Color(219, 224, 229) : new Color(241, 241, 241);
                }
                panel.setForeground(fgColor);
                if (bgColor != null) {
                    panel.setBackground(bgColor);
                }
                ++count;
            }
            panel.setBorder(border);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int blockAmount = visibleRect.height;
            visibleRect.y = direction > 0 ? (visibleRect.y += blockAmount) : (visibleRect.y -= blockAmount);
            return blockAmount += this.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
        return 0;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation != 1) {
            return 0;
        }
        int lastHeight = 0;
        int height = 0;
        int bottomOfScrollArea = visibleRect.y + visibleRect.height;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.isVisible() && c instanceof DetailPanel) {
                Dimension d = c.getPreferredSize();
                int nextHeight = height + d.height;
                if (direction > 0) {
                    if (nextHeight > bottomOfScrollArea) {
                        return nextHeight - bottomOfScrollArea;
                    }
                } else if (nextHeight > visibleRect.y) {
                    if (visibleRect.y != height) {
                        return visibleRect.y - height;
                    }
                    return visibleRect.y - lastHeight;
                }
                lastHeight = height;
                height = nextHeight;
            }
            ++n2;
        }
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getRowCount() {
        return this.sorter.getViewRowCount();
    }

    static /* synthetic */ int access$0(Contribution contribution) {
        return ListPanel.getContributionStatusRank(contribution);
    }

    class ContribHeaderRenderer
    extends DefaultTableCellRenderer {
        public ContribHeaderRenderer() {
            this.setHorizontalTextPosition(2);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JTableHeader tableHeader = table.getTableHeader();
            if (tableHeader != null) {
                this.setForeground(tableHeader.getForeground());
            }
            this.setFont(ManagerFrame.SMALL_PLAIN);
            this.setIcon(this.getSortIcon(table, column));
            this.setBackground(HEADER_BGCOLOR);
            this.setBorder(null);
            return this;
        }

        protected Icon getSortIcon(JTable table, int column) {
            RowSorter.SortKey sortKey = this.getSortKey(table, column);
            if (sortKey != null && table.convertColumnIndexToView(sortKey.getColumn()) == column) {
                switch (sortKey.getSortOrder()) {
                    case ASCENDING: {
                        return UIManager.getIcon("Table.ascendingSortIcon");
                    }
                    case DESCENDING: {
                        return UIManager.getIcon("Table.descendingSortIcon");
                    }
                }
            }
            return null;
        }

        protected RowSorter.SortKey getSortKey(JTable table, int column) {
            return Optional.ofNullable(table.getRowSorter()).map(RowSorter::getSortKeys).map(columns -> columns.isEmpty() ? null : (RowSorter.SortKey)columns.get(0)).orElse(null);
        }
    }

    private class ContribStatusRenderer
    extends DefaultTableCellRenderer {
        private ContribStatusRenderer() {
        }

        @Override
        public void setVerticalAlignment(int alignment) {
            super.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Contribution contribution = (Contribution)value;
            JLabel label = new JLabel();
            ContributionColumn col = ListPanel.this.model.columns[column];
            if (value == null) {
                return label;
            }
            label.setOpaque(true);
            if (value instanceof SectionHeaderContribution && col != ContributionColumn.NAME) {
                return label;
            }
            switch (col) {
                case STATUS: 
                case STATUS_NO_HEADER: {
                    this.configureStatusColumnLabel(label, contribution);
                    break;
                }
                case NAME: {
                    this.configureNameColumnLabel(table, label, contribution);
                    break;
                }
                case AUTHOR: {
                    this.configureAuthorsColumnLabel(label, contribution);
                    break;
                }
                case INSTALLED_VERSION: {
                    label.setText(contribution.getBenignVersion());
                    break;
                }
                case AVAILABLE_VERSION: {
                    label.setText(ContributionListing.getInstance().getLatestPrettyVersion(contribution));
                }
            }
            if (!contribution.isCompatible(Base.getRevision())) {
                label.setForeground(Color.LIGHT_GRAY);
            }
            return label;
        }

        private void configureStatusColumnLabel(JLabel label, Contribution contribution) {
            Icon icon = null;
            label.setFont(ManagerFrame.NORMAL_PLAIN);
            if (ListPanel.this.panelByContribution.get((Object)contribution).updateInProgress || ListPanel.this.panelByContribution.get((Object)contribution).installInProgress) {
                icon = downloadingIcon;
            } else if (contribution.isInstalled()) {
                icon = !contribution.isCompatible(Base.getRevision()) ? incompatibleIcon : (ContributionListing.getInstance().hasUpdates(contribution) ? updateAvailableIcon : (ListPanel.this.panelByContribution.get((Object)contribution).installInProgress || ListPanel.this.panelByContribution.get((Object)contribution).updateInProgress ? downloadingIcon : upToDateIcon));
            }
            label.setIcon(icon);
            label.setHorizontalAlignment(0);
        }

        private void configureNameColumnLabel(JTable table, JLabel label, Contribution contribution) {
            Font boldFont = ManagerFrame.NORMAL_BOLD;
            FontMetrics fontMetrics = table.getFontMetrics(boldFont);
            int colSize = table.getColumnModel().getColumn(1).getWidth();
            int currentWidth = fontMetrics.stringWidth(String.valueOf(contribution.getName()) + " | ...");
            String sentence = contribution.getSentence();
            StringBuilder text = new StringBuilder("<html><body><font face=\"").append(boldFont.getName()).append("\">").append(contribution.getName());
            if (sentence == null) {
                text.append("</font>");
            } else {
                int i = 0;
                i = 0;
                while (i < sentence.length()) {
                    if ((currentWidth += fontMetrics.charWidth(sentence.charAt(i))) >= colSize) break;
                    ++i;
                }
                text.append(" | </font>").append(sentence, 0, i);
                if (i != sentence.length()) {
                    text.append("...");
                }
            }
            text.append("</body></html>");
            label.setText(text.toString());
            label.setFont(ManagerFrame.NORMAL_PLAIN);
        }

        private void configureAuthorsColumnLabel(JLabel label, Contribution contribution) {
            if (contribution.isSpecial()) {
                label.setIcon(foundationIcon);
            }
            String authorList = contribution.getAuthorList();
            String name = ListPanel.getAuthorNameWithoutMarkup(authorList);
            label.setText(name);
            label.setHorizontalAlignment(2);
            label.setForeground(Color.BLACK);
            label.setFont(ManagerFrame.NORMAL_BOLD);
        }
    }

    protected static enum ContributionColumn {
        STATUS(" Status"),
        NAME("Name"),
        AUTHOR("Author"),
        INSTALLED_VERSION("Installed"),
        AVAILABLE_VERSION("Available"),
        STATUS_NO_HEADER("");

        final String name;

        private ContributionColumn(String name) {
            this.name = name;
        }

        Comparator<Contribution> getComparator() {
            Comparator<Contribution> comparator = Comparator.comparing(Contribution::getType).thenComparingInt(contribution -> contribution instanceof SectionHeaderContribution ? 0 : 1);
            switch (this) {
                case STATUS: 
                case STATUS_NO_HEADER: {
                    return comparator.thenComparingInt(ListPanel::access$0);
                }
                case AUTHOR: {
                    return comparator.thenComparing(contribution -> ListPanel.getAuthorNameWithoutMarkup(contribution.getAuthorList()));
                }
            }
            return comparator.thenComparing(Contribution::getName);
        }
    }

    protected class ContributionRowFilter
    extends RowFilter<ContributionTableModel, Integer> {
        Contribution.Filter contributionFilter;
        Optional<String> categoryFilter = Optional.empty();
        List<String> stringFilters = Collections.emptyList();

        ContributionRowFilter(Contribution.Filter contributionFilter) {
            this.contributionFilter = contributionFilter;
        }

        public void setCategoryFilter(String categoryFilter) {
            this.categoryFilter = Optional.ofNullable(categoryFilter);
        }

        public void setStringFilters(List<String> filters) {
            this.stringFilters = filters;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends ContributionTableModel, ? extends Integer> entry) {
            Contribution contribution = (Contribution)entry.getValue(0);
            if (contribution instanceof SectionHeaderContribution) {
                return this.includeSection((SectionHeaderContribution)contribution);
            }
            return this.includeContribution(contribution);
        }

        private boolean includeContribution(Contribution contribution) {
            return this.contributionFilter.matches(contribution) && this.categoryFilter.map(contribution::hasCategory).orElse(true) != false && this.stringFilters.stream().allMatch(pattern -> ContributionListing.getInstance().matches(contribution, (String)pattern));
        }

        private boolean includeSection(SectionHeaderContribution section) {
            return ContributionListing.getInstance().allContributions.stream().filter(contribution -> contribution.getType() == section.getType()).anyMatch(this::includeContribution);
        }
    }

    protected class ContributionTableModel
    extends AbstractTableModel {
        ContributionColumn[] columns = new ContributionColumn[]{ContributionColumn.STATUS, ContributionColumn.NAME, ContributionColumn.AUTHOR};
        boolean sectionsEnabled;

        ContributionTableModel(ContributionColumn ... columns) {
            if (columns.length > 0) {
                this.columns = columns;
            }
        }

        @Override
        public int getRowCount() {
            return ContributionListing.getInstance().allContributions.size() + (this.sectionsEnabled ? 4 : 0);
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int column) {
            if (column < 0 || column > this.columns.length) {
                return "";
            }
            return this.columns[column].name;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Contribution.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= ContributionListing.getInstance().allContributions.size()) {
                return sections[rowIndex - ContributionListing.getInstance().allContributions.size()];
            }
            return ContributionListing.getInstance().allContributions.stream().skip(rowIndex).findFirst().orElse(null);
        }

        public void setColumns(ContributionColumn[] columns) {
            this.columns = columns;
        }

        public void enableSections(boolean enable) {
            this.sectionsEnabled = enable;
        }
    }

    protected static class SectionHeaderContribution
    extends Contribution {
        ContributionType type;

        SectionHeaderContribution(ContributionType type) {
            this.type = type;
            this.name = this.getTypeName();
        }

        @Override
        public ContributionType getType() {
            return this.type;
        }

        @Override
        public boolean isInstalled() {
            return false;
        }
    }
}

