# Digest
<span class="source-link">[[Source]](src/crypto/digest.md#L7)</span>

Produces a hash from the chunks of input. Feed the input with append() and
produce a final hash from the concatenation of the input with final().


```pony
class ref Digest
```

## Constructors

### md5
<span class="source-link">[[Source]](src/crypto/digest.md#L16)</span>


Use the MD5 algorithm to calculate the hash.


```pony
new ref md5()
: Digest ref^
```

#### Returns

* [Digest](crypto-Digest.md) ref^

---

### ripemd160
<span class="source-link">[[Source]](src/crypto/digest.md#L28)</span>


Use the RIPEMD160 algorithm to calculate the hash.


```pony
new ref ripemd160()
: Digest ref^
```

#### Returns

* [Digest](crypto-Digest.md) ref^

---

### sha1
<span class="source-link">[[Source]](src/crypto/digest.md#L40)</span>


Use the SHA1 algorithm to calculate the hash.


```pony
new ref sha1()
: Digest ref^
```

#### Returns

* [Digest](crypto-Digest.md) ref^

---

### sha224
<span class="source-link">[[Source]](src/crypto/digest.md#L52)</span>


Use the SHA256 algorithm to calculate the hash.


```pony
new ref sha224()
: Digest ref^
```

#### Returns

* [Digest](crypto-Digest.md) ref^

---

### sha256
<span class="source-link">[[Source]](src/crypto/digest.md#L64)</span>


Use the SHA256 algorithm to calculate the hash.


```pony
new ref sha256()
: Digest ref^
```

#### Returns

* [Digest](crypto-Digest.md) ref^

---

### sha384
<span class="source-link">[[Source]](src/crypto/digest.md#L76)</span>


Use the SHA384 algorithm to calculate the hash.


```pony
new ref sha384()
: Digest ref^
```

#### Returns

* [Digest](crypto-Digest.md) ref^

---

### sha512
<span class="source-link">[[Source]](src/crypto/digest.md#L88)</span>


Use the SHA512 algorithm to calculate the hash.


```pony
new ref sha512()
: Digest ref^
```

#### Returns

* [Digest](crypto-Digest.md) ref^

---

## Public Functions

### append
<span class="source-link">[[Source]](src/crypto/digest.md#L100)</span>


Update the Digest object with input. Throw an error if final() has been
called.


```pony
fun ref append(
  input: (String val | Array[U8 val] val))
: None val ?
```
#### Parameters

*   input: ([String](builtin-String.md) val | [Array](builtin-Array.md)\[[U8](builtin-U8.md) val\] val)

#### Returns

* [None](builtin-None.md) val ?

---

### final
<span class="source-link">[[Source]](src/crypto/digest.md#L108)</span>


Return the digest of the strings passed to the append() method.


```pony
fun ref final()
: Array[U8 val] val
```

#### Returns

* [Array](builtin-Array.md)\[[U8](builtin-U8.md) val\] val

---

### digest_size
<span class="source-link">[[Source]](src/crypto/digest.md#L131)</span>


Return the size of the message digest in bytes.


```pony
fun box digest_size()
: USize val
```

#### Returns

* [USize](builtin-USize.md) val

---

