/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.annotation;

import java.util.Calendar;
import java.util.Optional;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationPopup;
import org.sejda.sambox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.sejda.sambox.pdmodel.interactive.annotation.PDExternalDataDictionary;

public class PDAnnotationMarkup
extends PDAnnotation {
    public static final String SUB_TYPE_FREETEXT = "FreeText";
    public static final String SUB_TYPE_POLYGON = "Polygon";
    public static final String SUB_TYPE_POLYLINE = "PolyLine";
    public static final String SUB_TYPE_CARET = "Caret";
    public static final String SUB_TYPE_INK = "Ink";
    public static final String SUB_TYPE_SOUND = "Sound";
    public static final String RT_REPLY = "R";
    public static final String RT_GROUP = "Group";

    public PDAnnotationMarkup() {
    }

    public PDAnnotationMarkup(COSDictionary dict) {
        super(dict);
    }

    public String getTitlePopup() {
        return this.getCOSObject().getString(COSName.T);
    }

    public void setTitlePopup(String t) {
        this.getCOSObject().setString(COSName.T, t);
    }

    public PDAnnotationPopup getPopup() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.POPUP, COSDictionary.class)).map(PDAnnotationPopup::new).orElse(null);
    }

    public void setPopup(PDAnnotationPopup popup) {
        this.getCOSObject().setItem(COSName.POPUP, (COSObjectable)popup);
    }

    public float getConstantOpacity() {
        return this.getCOSObject().getFloat(COSName.CA, 1.0f);
    }

    public void setConstantOpacity(float ca) {
        this.getCOSObject().setFloat(COSName.CA, ca);
    }

    public String getRichContents() {
        COSBase base = this.getCOSObject().getDictionaryObject(COSName.RC);
        if (base instanceof COSString) {
            return ((COSString)base).getString();
        }
        if (base instanceof COSStream) {
            return ((COSStream)base).asTextString();
        }
        return null;
    }

    public void setRichContents(String rc) {
        this.getCOSObject().setItem(COSName.RC, (COSBase)COSString.parseLiteral(rc));
    }

    public Calendar getCreationDate() {
        return this.getCOSObject().getDate(COSName.CREATION_DATE);
    }

    public void setCreationDate(Calendar creationDate) {
        this.getCOSObject().setDate(COSName.CREATION_DATE, creationDate);
    }

    public PDAnnotation getInReplyTo() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject("IRT", COSDictionary.class)).map(PDAnnotation::createAnnotation).orElse(null);
    }

    public void setInReplyTo(PDAnnotation irt) {
        this.getCOSObject().setItem("IRT", (COSObjectable)irt);
    }

    public String getSubject() {
        return this.getCOSObject().getString(COSName.SUBJ);
    }

    public void setSubject(String subj) {
        this.getCOSObject().setString(COSName.SUBJ, subj);
    }

    public String getReplyType() {
        return this.getCOSObject().getNameAsString("RT", RT_REPLY);
    }

    public void setReplyType(String rt) {
        this.getCOSObject().setName("RT", rt);
    }

    public String getIntent() {
        return this.getCOSObject().getNameAsString(COSName.IT);
    }

    public void setIntent(String it) {
        this.getCOSObject().setName(COSName.IT, it);
    }

    public PDExternalDataDictionary getExternalData() {
        COSBase exData = this.getCOSObject().getDictionaryObject("ExData");
        if (exData instanceof COSDictionary) {
            return new PDExternalDataDictionary((COSDictionary)exData);
        }
        return null;
    }

    public void setExternalData(PDExternalDataDictionary externalData) {
        this.getCOSObject().setItem("ExData", (COSObjectable)externalData);
    }

    public void setBorderStyle(PDBorderStyleDictionary bs) {
        this.getCOSObject().setItem(COSName.BS, (COSObjectable)bs);
    }

    public PDBorderStyleDictionary getBorderStyle() {
        COSDictionary bs = this.getCOSObject().getDictionaryObject(COSName.BS, COSDictionary.class);
        if (bs != null) {
            return new PDBorderStyleDictionary(bs);
        }
        return null;
    }
}

