/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.font;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.cff.CFFCIDFont;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.type1.Type1Font;
import org.apache.fontbox.util.autodetect.FontFileFinder;
import org.sejda.sambox.pdmodel.font.CIDSystemInfo;
import org.sejda.sambox.pdmodel.font.FontCache;
import org.sejda.sambox.pdmodel.font.FontFormat;
import org.sejda.sambox.pdmodel.font.FontInfo;
import org.sejda.sambox.pdmodel.font.FontProvider;
import org.sejda.sambox.pdmodel.font.PDPanoseClassification;
import org.sejda.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FileSystemFontProvider
extends FontProvider {
    private static final String FONT_CACHE_SEPARATOR = "|";
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemFontProvider.class);
    private final List<FSFontInfo> fontInfoList = new ArrayList<FSFontInfo>();
    private final FontCache cache;
    private boolean initialized = false;

    FileSystemFontProvider(FontCache cache) {
        this.cache = cache;
    }

    private synchronized void initializeIfRequired() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    private void initialize() {
        try {
            LOG.trace("Will search the local system for fonts");
            ArrayList<File> files = new ArrayList<File>();
            FontFileFinder fontFileFinder = new FontFileFinder();
            List fonts = fontFileFinder.find();
            for (URI font : fonts) {
                files.add(new File(font));
            }
            LOG.trace("Found " + files.size() + " fonts on the local system");
            List<FSFontInfo> cachedInfos = this.loadDiskCache(files);
            if (cachedInfos != null && cachedInfos.size() > 0) {
                this.fontInfoList.addAll(cachedInfos);
            } else {
                LOG.warn("Building on-disk font cache, this may take a while");
                this.scanFonts(files);
                this.saveDiskCache();
                LOG.warn("Finished building on-disk font cache, found " + this.fontInfoList.size() + " fonts");
            }
        }
        catch (AccessControlException e) {
            LOG.error("Error accessing the file system", (Throwable)e);
        }
    }

    private void scanFonts(List<File> files) {
        for (File file : files) {
            if (file.getPath().toLowerCase().endsWith(".ttf") || file.getPath().toLowerCase().endsWith(".otf")) {
                this.addTrueTypeFont(file);
                continue;
            }
            if (file.getPath().toLowerCase().endsWith(".ttc") || file.getPath().toLowerCase().endsWith(".otc")) {
                this.addTrueTypeCollection(file);
                continue;
            }
            if (!file.getPath().toLowerCase().endsWith(".pfb")) continue;
            this.addType1Font(file);
        }
    }

    private File getDiskCacheFile() {
        String path = System.getProperty("org.sambox.fontcache");
        if (path == null && (path = System.getProperty("user.home")) == null) {
            path = System.getProperty("java.io.tmpdir");
        }
        return new File(path, ".sambox.cache");
    }

    private void saveDiskCache() {
        try {
            File file = this.getDiskCacheFile();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                for (FSFontInfo fontInfo : this.fontInfoList) {
                    writer.write(fontInfo.postScriptName.trim().replace(FONT_CACHE_SEPARATOR, "\\|"));
                    writer.write(FONT_CACHE_SEPARATOR);
                    writer.write(fontInfo.format.toString());
                    writer.write(FONT_CACHE_SEPARATOR);
                    if (fontInfo.cidSystemInfo != null) {
                        writer.write(fontInfo.cidSystemInfo.getRegistry() + '-' + fontInfo.cidSystemInfo.getOrdering() + '-' + fontInfo.cidSystemInfo.getSupplement());
                    }
                    writer.write(FONT_CACHE_SEPARATOR);
                    if (fontInfo.usWeightClass > -1) {
                        writer.write(Integer.toHexString(fontInfo.usWeightClass));
                    }
                    writer.write(FONT_CACHE_SEPARATOR);
                    if (fontInfo.sFamilyClass > -1) {
                        writer.write(Integer.toHexString(fontInfo.sFamilyClass));
                    }
                    writer.write(FONT_CACHE_SEPARATOR);
                    writer.write(Integer.toHexString(fontInfo.ulCodePageRange1));
                    writer.write(FONT_CACHE_SEPARATOR);
                    writer.write(Integer.toHexString(fontInfo.ulCodePageRange2));
                    writer.write(FONT_CACHE_SEPARATOR);
                    if (fontInfo.macStyle > -1) {
                        writer.write(Integer.toHexString(fontInfo.macStyle));
                    }
                    writer.write(FONT_CACHE_SEPARATOR);
                    if (fontInfo.panose != null) {
                        byte[] bytes = fontInfo.panose.getBytes();
                        for (int i = 0; i < 10; ++i) {
                            String str = Integer.toHexString(bytes[i]);
                            if (str.length() == 1) {
                                writer.write(48);
                            }
                            writer.write(str);
                        }
                    }
                    writer.write(FONT_CACHE_SEPARATOR);
                    writer.write(fontInfo.file.getAbsolutePath());
                    writer.newLine();
                }
            }
        }
        catch (IOException | SecurityException e) {
            LOG.error("Could not write to font cache", (Throwable)e);
        }
    }

    private List<FSFontInfo> loadDiskCache(List<File> files) {
        File file2;
        HashSet<String> pending = new HashSet<String>();
        for (File file2 : files) {
            pending.add(file2.getAbsolutePath());
        }
        ArrayList<FSFontInfo> results = new ArrayList<FSFontInfo>();
        file2 = this.getDiskCacheFile();
        boolean fileExists = false;
        try {
            fileExists = file2.exists();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (fileExists) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file2));){
                String line;
                while ((line = reader.readLine()) != null) {
                    File fontFile;
                    String[] parts = line.split("(?<!\\\\)\\|", 10);
                    if (parts.length < 10) {
                        LOG.error("Incorrect line '" + line + "' in font disk cache is skipped");
                        continue;
                    }
                    CIDSystemInfo cidSystemInfo = null;
                    int usWeightClass = -1;
                    int sFamilyClass = -1;
                    int macStyle = -1;
                    byte[] panose = null;
                    String postScriptName = parts[0].replace("\\|", FONT_CACHE_SEPARATOR);
                    FontFormat format = FontFormat.valueOf(parts[1]);
                    if (parts[2].length() > 0) {
                        String[] ros = parts[2].split("-");
                        cidSystemInfo = new CIDSystemInfo(ros[0], ros[1], Integer.parseInt(ros[2]));
                    }
                    if (parts[3].length() > 0) {
                        usWeightClass = (int)Long.parseLong(parts[3], 16);
                    }
                    if (parts[4].length() > 0) {
                        sFamilyClass = (int)Long.parseLong(parts[4], 16);
                    }
                    int ulCodePageRange1 = (int)Long.parseLong(parts[5], 16);
                    int ulCodePageRange2 = (int)Long.parseLong(parts[6], 16);
                    if (parts[7].length() > 0) {
                        macStyle = (int)Long.parseLong(parts[7], 16);
                    }
                    if (parts[8].length() > 0) {
                        panose = new byte[10];
                        for (int i = 0; i < 10; ++i) {
                            String str = parts[8].substring(i * 2, i * 2 + 2);
                            int b = Integer.parseInt(str, 16);
                            panose[i] = (byte)(b & 0xFF);
                        }
                    }
                    if ((fontFile = new File(parts[9])).exists()) {
                        FSFontInfo info = new FSFontInfo(fontFile, format, postScriptName, cidSystemInfo, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this);
                        results.add(info);
                    } else {
                        LOG.debug("Font file {} not found, skipped", (Object)fontFile.getAbsolutePath());
                    }
                    pending.remove(fontFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                LOG.error("Error loading font cache, will be re-built", (Throwable)e);
                return null;
            }
        }
        if (pending.size() > 0) {
            LOG.warn("New fonts found, font cache will be re-built");
            return null;
        }
        return results;
    }

    private void addTrueTypeCollection(final File ttcFile) {
        try (TrueTypeCollection ttc = new TrueTypeCollection(ttcFile);){
            ttc.processAllFonts(new TrueTypeCollection.TrueTypeFontProcessor(){

                public void process(TrueTypeFont ttf) throws IOException {
                    FileSystemFontProvider.this.addTrueTypeFontImpl(ttf, ttcFile);
                }
            });
        }
        catch (NullPointerException e) {
            LOG.error("Could not load font file: " + ttcFile, (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Could not load font file: " + ttcFile, (Throwable)e);
        }
    }

    private void addTrueTypeFont(File ttfFile) {
        try {
            if (ttfFile.getPath().endsWith(".otf")) {
                OTFParser parser = new OTFParser(false, true);
                OpenTypeFont otf = parser.parse(ttfFile);
                this.addTrueTypeFontImpl((TrueTypeFont)otf, ttfFile);
            } else {
                TTFParser parser = new TTFParser(false, true);
                TrueTypeFont ttf = parser.parse(ttfFile);
                this.addTrueTypeFontImpl(ttf, ttfFile);
            }
        }
        catch (NullPointerException e) {
            LOG.error("Could not load font file: " + ttfFile, (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Could not load font file: " + ttfFile, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrueTypeFontImpl(TrueTypeFont ttf, File file) throws IOException {
        try {
            if (ttf.getName() != null) {
                NamingTable name;
                String format;
                if (ttf.getHeader() == null) {
                    this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, ttf.getName()));
                    return;
                }
                int macStyle = ttf.getHeader().getMacStyle();
                int sFamilyClass = -1;
                int usWeightClass = -1;
                int ulCodePageRange1 = 0;
                int ulCodePageRange2 = 0;
                byte[] panose = null;
                if (ttf.getOS2Windows() != null) {
                    sFamilyClass = ttf.getOS2Windows().getFamilyClass();
                    usWeightClass = ttf.getOS2Windows().getWeightClass();
                    ulCodePageRange1 = (int)ttf.getOS2Windows().getCodePageRange1();
                    ulCodePageRange2 = (int)ttf.getOS2Windows().getCodePageRange2();
                    panose = ttf.getOS2Windows().getPanose();
                }
                if (ttf instanceof OpenTypeFont && ((OpenTypeFont)ttf).isPostScript()) {
                    format = "OTF";
                    CFFFont cff = ((OpenTypeFont)ttf).getCFF().getFont();
                    CIDSystemInfo ros = null;
                    if (cff instanceof CFFCIDFont) {
                        CFFCIDFont cidFont = (CFFCIDFont)cff;
                        String registry = cidFont.getRegistry();
                        String ordering = cidFont.getOrdering();
                        int supplement = cidFont.getSupplement();
                        ros = new CIDSystemInfo(registry, ordering, supplement);
                    }
                    this.fontInfoList.add(new FSFontInfo(file, FontFormat.OTF, ttf.getName(), ros, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this));
                } else {
                    CIDSystemInfo ros = null;
                    if (ttf.getTableMap().containsKey("gcid")) {
                        byte[] bytes = ttf.getTableBytes((TTFTable)ttf.getTableMap().get("gcid"));
                        String reg = new String(bytes, 10, 64, StandardCharsets.US_ASCII);
                        String registryName = reg.substring(0, reg.indexOf(0));
                        String ord = new String(bytes, 76, 64, StandardCharsets.US_ASCII);
                        String orderName = ord.substring(0, ord.indexOf(0));
                        int supplementVersion = bytes[140] << 8 & bytes[141];
                        ros = new CIDSystemInfo(registryName, orderName, supplementVersion);
                    }
                    format = "TTF";
                    this.fontInfoList.add(new FSFontInfo(file, FontFormat.TTF, ttf.getName(), ros, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this));
                }
                if (LOG.isTraceEnabled() && (name = ttf.getNaming()) != null) {
                    LOG.trace(format + ": '" + name.getPostScriptName() + "' / '" + name.getFontFamily() + "' / '" + name.getFontSubFamily() + "'");
                }
            } else {
                this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, "*skipnoname*"));
                LOG.warn("Missing 'name' entry for PostScript name in font " + file);
            }
        }
        catch (IOException e) {
            this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, "*skipexception*"));
            LOG.error("Could not load font file: " + file, (Throwable)e);
        }
        finally {
            IOUtils.close((Closeable)ttf);
        }
    }

    private void addType1Font(File pfbFile) {
        try (FileInputStream input = new FileInputStream(pfbFile);){
            Type1Font type1 = Type1Font.createWithPFB((InputStream)input);
            this.fontInfoList.add(new FSFontInfo(pfbFile, FontFormat.PFB, type1.getName(), null, -1, -1, 0, 0, -1, null, this));
            if (LOG.isTraceEnabled()) {
                LOG.trace("PFB: '" + type1.getName() + "' / '" + type1.getFamilyName() + "' / '" + type1.getWeight() + "'");
            }
        }
        catch (IOException e) {
            LOG.error("Could not load font file: " + pfbFile, (Throwable)e);
        }
    }

    private TrueTypeFont getTrueTypeFont(String postScriptName, File file) {
        try {
            return this.readTrueTypeFont(postScriptName, file);
        }
        catch (IOException | NullPointerException e) {
            LOG.error("Could not load font file: " + file, (Throwable)e);
            return null;
        }
    }

    private TrueTypeFont readTrueTypeFont(String postScriptName, File file) throws IOException {
        if (file.getName().toLowerCase().endsWith(".ttc")) {
            TrueTypeCollection ttc = new TrueTypeCollection(file);
            TrueTypeFont ttf = ttc.getFontByName(postScriptName);
            if (ttf == null) {
                ttc.close();
                throw new IOException("Font " + postScriptName + " not found in " + file);
            }
            return ttf;
        }
        return new TTFParser(false, true).parse(file);
    }

    private OpenTypeFont getOTFFont(File file) {
        try {
            return new OTFParser(false, true).parse(file);
        }
        catch (IOException e) {
            LOG.error("Could not load font file: " + file, (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Type1Font getType1Font(File file) {
        try (FileInputStream input = new FileInputStream(file);){
            Type1Font type1Font = Type1Font.createWithPFB((InputStream)input);
            return type1Font;
        }
        catch (IOException e) {
            LOG.error("Could not load font file: " + file, (Throwable)e);
            return null;
        }
    }

    @Override
    public String toDebugString() {
        this.initializeIfRequired();
        StringBuilder sb = new StringBuilder();
        for (FSFontInfo info : this.fontInfoList) {
            sb.append((Object)info.getFormat());
            sb.append(": ");
            sb.append(info.getPostScriptName());
            sb.append(": ");
            sb.append(info.file.getPath());
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public List<? extends FontInfo> getFontInfo() {
        this.initializeIfRequired();
        return this.fontInfoList;
    }

    private static final class FSIgnored
    extends FSFontInfo {
        private FSIgnored(File file, FontFormat format, String postScriptName) {
            super(file, format, postScriptName, null, 0, 0, 0, 0, 0, null, null);
        }
    }

    private static class FSFontInfo
    extends FontInfo {
        private final String postScriptName;
        private final FontFormat format;
        private final CIDSystemInfo cidSystemInfo;
        private final int usWeightClass;
        private final int sFamilyClass;
        private final int ulCodePageRange1;
        private final int ulCodePageRange2;
        private final int macStyle;
        private final PDPanoseClassification panose;
        private final File file;
        private transient FileSystemFontProvider parent;

        private FSFontInfo(File file, FontFormat format, String postScriptName, CIDSystemInfo cidSystemInfo, int usWeightClass, int sFamilyClass, int ulCodePageRange1, int ulCodePageRange2, int macStyle, byte[] panose, FileSystemFontProvider parent) {
            this.file = file;
            this.format = format;
            this.postScriptName = postScriptName;
            this.cidSystemInfo = cidSystemInfo;
            this.usWeightClass = usWeightClass;
            this.sFamilyClass = sFamilyClass;
            this.ulCodePageRange1 = ulCodePageRange1;
            this.ulCodePageRange2 = ulCodePageRange2;
            this.macStyle = macStyle;
            this.panose = panose != null ? new PDPanoseClassification(panose) : null;
            this.parent = parent;
        }

        @Override
        public String getPostScriptName() {
            return this.postScriptName;
        }

        @Override
        public FontFormat getFormat() {
            return this.format;
        }

        @Override
        public CIDSystemInfo getCIDSystemInfo() {
            return this.cidSystemInfo;
        }

        @Override
        public FontBoxFont getFont() {
            Type1Font font;
            FontBoxFont cached = this.parent.cache.getFont(this);
            if (cached != null) {
                return cached;
            }
            LOG.debug("Loading {} from {}", (Object)this.postScriptName, (Object)this.file);
            switch (this.format) {
                case PFB: {
                    font = this.parent.getType1Font(this.file);
                    break;
                }
                case TTF: {
                    font = this.parent.getTrueTypeFont(this.postScriptName, this.file);
                    break;
                }
                case OTF: {
                    font = this.parent.getOTFFont(this.file);
                    break;
                }
                default: {
                    throw new RuntimeException("can't happen");
                }
            }
            if (font != null) {
                this.parent.cache.addFont(this, (FontBoxFont)font);
            }
            return font;
        }

        @Override
        public int getFamilyClass() {
            return this.sFamilyClass;
        }

        @Override
        public int getWeightClass() {
            return this.usWeightClass;
        }

        @Override
        public int getCodePageRange1() {
            return this.ulCodePageRange1;
        }

        @Override
        public int getCodePageRange2() {
            return this.ulCodePageRange2;
        }

        @Override
        public int getMacStyle() {
            return this.macStyle;
        }

        @Override
        public PDPanoseClassification getPanose() {
            return this.panose;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.file;
        }
    }
}

