/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.dbscript;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.j2ee.persistence.api.PersistenceEnvironment;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.editor.JPAEditorUtil;
import org.netbeans.modules.j2ee.persistence.jpqleditor.Utils;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.dbscript.DBScriptPanel;
import org.netbeans.modules.j2ee.persistence.wizard.dbscript.GenerateScriptExecutor;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public final class DBScriptWizard
implements WizardDescriptor.ProgressInstantiatingIterator {
    private WizardDescriptor.Panel[] panels;
    private int index = 0;
    private WizardDescriptor.Panel ejbPanel;
    private WizardDescriptor wiz;
    private static final String EXTENSION = "sql";
    private static final Logger LOGGER = Logger.getLogger(DBScriptWizard.class.getName());

    public static DBScriptWizard create() {
        return new DBScriptWizard();
    }

    public String name() {
        return NbBundle.getMessage(DBScriptWizard.class, (String)"LBL_CreateDBScriptWizardTitle");
    }

    public void uninitialize(WizardDescriptor wiz) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        this.ejbPanel = new DBScriptPanel.WizardPanel();
        this.panels = new WizardDescriptor.Panel[]{this.ejbPanel};
        Wizards.mergeSteps((WizardDescriptor)this.wiz, (WizardDescriptor.Panel[])this.panels, (String[])new String[]{this.name()});
    }

    public Set instantiate() throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set instantiate(ProgressHandle handle) throws IOException {
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        FileObject tFolder = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        try {
            handle.start(100);
            handle.progress(NbBundle.getMessage(DBScriptWizard.class, (String)"MSG_CreateFile"), 5);
            FileObject sqlFile = tFolder.createData(Templates.getTargetName((WizardDescriptor)this.wiz), EXTENSION);
            PersistenceEnvironment pe = (PersistenceEnvironment)project.getLookup().lookup(PersistenceEnvironment.class);
            if (sqlFile != null) {
                DBScriptWizard.run(project, sqlFile, pe, handle, false);
            }
            Set<FileObject> set = Collections.singleton(sqlFile);
            return set;
        }
        finally {
            handle.finish();
        }
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public boolean hasPrevious() {
        return false;
    }

    public boolean hasNext() {
        return false;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> run(final Project project, final FileObject sFile, final PersistenceEnvironment pe, final ProgressHandle handle, final boolean validateOnly) {
        ArrayList<URL> localResourcesURLList = new ArrayList<URL>();
        final HashMap<String, String> props = new HashMap<String, String>();
        final ArrayList<String> initialProblems = new ArrayList<String>();
        PersistenceUnit[] pus = null;
        if (handle != null) {
            handle.progress(NbBundle.getMessage(DBScriptWizard.class, (String)"MSG_CollectConfig"), 10);
        }
        try {
            pus = Util.getPersistenceUnits(project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (pus == null || pus.length == 0) {
            initialProblems.add(NbBundle.getMessage(DBScriptWizard.class, (String)"ERR_NoPU"));
            return initialProblems;
        }
        final PersistenceUnit pu = pus[0];
        final DatabaseConnection dbconn = JPAEditorUtil.findDatabaseConnection(pu, pe.getProject());
        if (dbconn != null && dbconn.getJDBCConnection() == null) {
            Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<DatabaseConnection>(){

                public DatabaseConnection run() {
                    ConnectionManager.getDefault().showConnectionDialog(dbconn);
                    return dbconn;
                }
            });
        }
        boolean containerManaged = Util.isSupportedJavaEEVersion(pe.getProject());
        Provider provider = ProviderUtil.getProvider(pu.getProvider(), pe.getProject());
        if (containerManaged && provider != null) {
            Utils.substitutePersistenceProperties(pe, pu, dbconn, props);
        }
        final ClassLoader defClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            initialProblems.addAll(Utils.collectClassPathURLs(pe, pu, dbconn, localResourcesURLList));
            ClassLoader customClassLoader = pe.getProjectClassLoader(localResourcesURLList.toArray(new URL[0]));
            Thread.currentThread().setContextClassLoader(customClassLoader);
            Thread t = new Thread(){

                @Override
                public void run() {
                    if (initialProblems.isEmpty()) {
                        new GenerateScriptExecutor().execute(project, sFile, pe, pu, props, initialProblems, handle, validateOnly);
                    }
                    if (!initialProblems.isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        for (String txt : initialProblems) {
                            sb.append(txt).append("\n");
                        }
                        LOGGER.info(sb.toString());
                    }
                    Thread.currentThread().setContextClassLoader(defClassLoader);
                }
            };
            t.setContextClassLoader(customClassLoader);
            t.start();
            t.join(30000L);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(defClassLoader);
        }
        return initialProblems;
    }
}

