/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LevelOfDetailsWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.api.visual.widget.general.IconNodeWidget;
import org.netbeans.modules.java.graph.Bundle;
import org.netbeans.modules.java.graph.DependencyGraphScene;
import org.netbeans.modules.java.graph.EdgeWidget;
import org.netbeans.modules.java.graph.GraphNode;
import org.netbeans.modules.java.graph.GraphNodeImplementation;
import org.openide.util.ImageUtilities;
import org.openide.util.Parameters;

class NodeWidget<I extends GraphNodeImplementation>
extends Widget
implements ActionListener {
    static final Color ROOT = new Color(178, 228, 255);
    static final Color DIRECTS = new Color(178, 228, 255);
    static final Color DIRECTS_CONFLICT = new Color(235, 88, 194);
    static final Color DISABLE_HIGHTLIGHT = new Color(255, 255, 194);
    static final Color HIGHTLIGHT = new Color(255, 255, 129);
    static final Color DISABLE_CONFLICT = new Color(219, 155, 153);
    static final Color CONFLICT = new Color(219, 11, 5);
    static final Color MANAGED = new Color(30, 255, 150);
    static final Color WARNING = new Color(255, 150, 20);
    static final Color DISABLE_WARNING = EdgeWidget.deriveColor(WARNING, 0.7f);
    private static final int LEFT_TOP = 1;
    private static final int LEFT_BOTTOM = 2;
    private static final int RIGHT_TOP = 3;
    private static final int RIGHT_BOTTOM = 4;
    private static final String LOCK_ICON = "org/netbeans/modules/java/graph/resources/lock.png";
    private static final String LOCK_BROKEN_ICON = "org/netbeans/modules/java/graph/resources/lock-broken.png";
    private static final String BULB_ICON = "org/netbeans/modules/java/graph/resources/bulb.gif";
    private static final String BULB_HIGHLIGHT_ICON = "org/netbeans/modules/java/graph/resources/bulb-highlight.gif";
    private GraphNode<I> node;
    private boolean readable = false;
    private boolean enlargedFromHover = false;
    private Timer hoverTimer;
    private Color hoverBorderC;
    private IconNodeWidget nodeW;
    private LabelWidget versionW;
    private Widget contentW;
    private ImageWidget lockW;
    private ImageWidget fixHintW;
    private int paintState = 2;
    private Font origFont;
    private Color origForeground;
    private String tooltipText;
    private final WidgetAction fixConflictAction;
    private final WidgetAction sceneHoverActionAction;
    public double locX;
    public double locY;
    public double dispX;
    public double dispY;
    private boolean fixed;

    NodeWidget(@NonNull DependencyGraphScene scene, GraphNode<I> node, final Action fixConflictAction, WidgetAction sceneHoverActionAction) {
        super((Scene)scene);
        Parameters.notNull((CharSequence)"node", node);
        if (fixConflictAction != null) {
            Parameters.notNull((CharSequence)"sceneHoverActionAction", (Object)sceneHoverActionAction);
        }
        this.node = node;
        this.fixConflictAction = fixConflictAction != null ? ActionFactory.createSelectAction((SelectProvider)new SelectProvider(){

            public boolean isAimingAllowed(Widget widget, Point localLocation, boolean invertSelection) {
                return false;
            }

            public boolean isSelectionAllowed(Widget widget, Point localLocation, boolean invertSelection) {
                return true;
            }

            public void select(Widget widget, Point localLocation, boolean invertSelection) {
                fixConflictAction.actionPerformed(null);
            }
        }) : null;
        this.sceneHoverActionAction = sceneHoverActionAction;
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.updateTooltip();
        this.initContent(scene, (GraphNodeImplementation)node.getImpl(), scene.getIcon(node));
        this.hoverTimer = new Timer(500, this);
        this.hoverTimer.setRepeats(false);
        this.hoverBorderC = UIManager.getColor("TextPane.selectionBackground");
        if (this.hoverBorderC == null) {
            this.hoverBorderC = Color.GRAY;
        }
    }

    private void updateTooltip() {
        DependencyGraphScene scene = this.getDependencyGraphScene();
        this.tooltipText = Bundle.TIP_Text(this.node.getTooltipText(), scene.supportsVersions() ? this.getConflictTooltip(this.node) : "");
        this.setToolTipText(this.tooltipText);
    }

    public String getConflictTooltip(GraphNode<I> node) {
        DependencyGraphScene scene = this.getDependencyGraphScene();
        StringBuilder tooltip = new StringBuilder();
        int conflictCount = 0;
        GraphNodeImplementation firstConflict = null;
        int conflictType = node.getConflictType(scene::isConflict, scene::compareVersions);
        if (conflictType != 0) {
            for (GraphNodeImplementation nd : node.getDuplicatesOrConflicts()) {
                if (!scene.isConflict(nd)) continue;
                ++conflictCount;
                if (firstConflict != null) continue;
                firstConflict = nd;
            }
        }
        if (conflictCount == 1) {
            Object parent = firstConflict.getParent();
            String version = scene.getVersion(firstConflict);
            String requester = parent != null ? parent.getName() : "???";
            tooltip.append(conflictType == 2 ? Bundle.TIP_SingleConflict(version, requester) : Bundle.TIP_SingleWarning(version, requester));
        } else if (conflictCount > 1) {
            tooltip.append(conflictType == 2 ? Bundle.TIP_MultipleConflict() : Bundle.TIP_MultipleWarning());
            for (GraphNodeImplementation nd : node.getDuplicatesOrConflicts()) {
                if (!scene.isConflict(nd)) continue;
                tooltip.append("<tr><td>");
                tooltip.append(scene.getVersion(nd));
                tooltip.append("</td>");
                tooltip.append("<td>");
                Object parent = nd.getParent();
                if (parent != null) {
                    tooltip.append(parent.getName());
                }
                tooltip.append("</td></tr>");
            }
            tooltip.append("</tbody></table>");
        }
        return tooltip.toString();
    }

    private DependencyGraphScene getDependencyGraphScene() {
        return (DependencyGraphScene)this.getScene();
    }

    public void highlightText(String searchTerm) {
        if (searchTerm != null && this.node.getName().contains(searchTerm)) {
            this.nodeW.setBackground((Paint)HIGHTLIGHT);
            this.nodeW.setOpaque(true);
            this.setPaintState(2);
            this.setReadable(true);
        } else {
            this.nodeW.setBackground((Paint)Color.WHITE);
            this.nodeW.setOpaque(false);
            this.setPaintState(1);
            this.setReadable(false);
        }
    }

    public void setPaintState(int state) {
        if (this.paintState == state) {
            return;
        }
        this.paintState = state;
        this.updatePaintContent();
    }

    public int getPaintState() {
        return this.paintState;
    }

    void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    boolean isFixed() {
        return this.fixed;
    }

    void updatePaintContent() {
        if (this.origForeground == null) {
            this.origForeground = this.getForeground();
        }
        boolean isDisabled = this.paintState == 0;
        Color foreC = this.origForeground;
        if (this.paintState == 1 || isDisabled) {
            foreC = UIManager.getColor("textInactiveText");
            if (foreC == null) {
                foreC = Color.LIGHT_GRAY;
            }
            if (isDisabled) {
                foreC = new Color((int)((float)foreC.getAlpha() / 1.3f), foreC.getRed(), foreC.getGreen(), foreC.getBlue());
            }
        }
        this.contentW.setBorder(BorderFactory.createLineBorder((int)10, (Color)foreC));
        this.nodeW.setForeground(foreC);
        if (this.versionW != null) {
            this.versionW.setForeground(foreC);
        }
        if (this.lockW != null) {
            this.lockW.setPaintAsDisabled(this.paintState == 1);
            this.lockW.setVisible(!isDisabled);
        }
        this.setToolTipText(this.paintState != 0 ? this.tooltipText : null);
        this.contentW.repaint();
        this.setVisible(((DependencyGraphScene)this.getScene()).isVisible(this.node));
    }

    private void initContent(DependencyGraphScene scene, GraphNodeImplementation impl, Icon icon) {
        this.contentW = new LevelOfDetailsWidget((Scene)scene, 0.05, 0.1, Double.MAX_VALUE, Double.MAX_VALUE);
        this.contentW.setBorder(BorderFactory.createLineBorder((int)10));
        this.contentW.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)1));
        this.nodeW = new IconNodeWidget((Scene)scene, IconNodeWidget.TextOrientation.RIGHT_CENTER);
        this.nodeW.setLabel(this.node.getImpl().getQualifiedName() + "  ");
        if (null != icon) {
            this.nodeW.setImage(ImageUtilities.icon2Image((Icon)icon));
        }
        this.nodeW.getLabelWidget().setUseGlyphVector(true);
        if (this.node.isRoot()) {
            Font defF = scene.getDefaultFont();
            this.nodeW.getLabelWidget().setFont(defF.deriveFont(1, (float)defF.getSize() + 3.0f));
        }
        this.contentW.addChild((Widget)this.nodeW);
        if (this.getDependencyGraphScene().supportsVersions()) {
            LevelOfDetailsWidget versionDetW = new LevelOfDetailsWidget((Scene)scene, 0.5, 0.7, Double.MAX_VALUE, Double.MAX_VALUE);
            versionDetW.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)2));
            this.contentW.addChild((Widget)versionDetW);
            this.versionW = new LabelWidget((Scene)scene);
            this.versionW.setLabel(scene.getVersion(this.node.getImpl()));
            this.versionW.setUseGlyphVector(true);
            int mngState = this.node.getManagedState();
            if (mngState != 0) {
                this.lockW = new ImageWidget((Scene)scene, mngState == 1 ? ImageUtilities.loadImage((String)LOCK_ICON) : ImageUtilities.loadImage((String)LOCK_BROKEN_ICON));
            }
            versionDetW.addChild((Widget)this.versionW);
            if (this.lockW != null) {
                versionDetW.addChild((Widget)this.lockW);
            }
        }
        if (this.fixConflictAction != null) {
            Widget rootW = new Widget((Scene)scene);
            rootW.setLayout(LayoutFactory.createOverlayLayout());
            this.fixHintW = new ImageWidget((Scene)scene, ImageUtilities.loadImage((String)BULB_ICON));
            this.fixHintW.setVisible(false);
            this.fixHintW.setToolTipText(Bundle.ACT_FixVersionConflict());
            this.fixHintW.getActions().addAction(this.sceneHoverActionAction);
            this.fixHintW.getActions().addAction(this.fixConflictAction);
            Widget panelW = new Widget((Scene)scene);
            panelW.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)0));
            panelW.setBorder(BorderFactory.createEmptyBorder((int)0, (int)3));
            panelW.addChild((Widget)this.fixHintW);
            rootW.addChild(panelW);
            rootW.addChild(this.contentW);
            this.addChild(rootW);
        } else {
            this.addChild(this.contentW);
        }
    }

    public void modelChanged() {
        DependencyGraphScene scene = this.getDependencyGraphScene();
        if (scene.supportsVersions()) {
            this.versionW.setLabel(scene.getVersion(this.node.getImpl()));
            if (this.fixConflictAction == null && this.fixHintW != null) {
                this.fixHintW.setVisible(false);
                this.fixHintW = null;
            }
        }
        this.updateTooltip();
        this.repaint();
    }

    protected void paintBackground() {
        super.paintBackground();
        if (this.paintState == 0) {
            return;
        }
        DependencyGraphScene scene = this.getDependencyGraphScene();
        Graphics2D g = scene.getGraphics();
        Rectangle bounds = this.getClientArea();
        if (this.node.isRoot()) {
            NodeWidget.paintBottom(g, bounds, ROOT, Color.WHITE, bounds.height / 2);
        } else {
            Color scopeC = scene.getColor(this.node);
            if (scopeC != null) {
                NodeWidget.paintCorner(4, g, bounds, scopeC, Color.WHITE, bounds.width / 2, bounds.height / 2);
            }
            int conflictType = scene.supportsVersions() ? this.node.getConflictType(scene::isConflict, scene::compareVersions) : 0;
            Color leftTopC = null;
            if (conflictType != 0) {
                leftTopC = conflictType == 2 ? (this.paintState == 1 ? DISABLE_CONFLICT : CONFLICT) : (this.paintState == 1 ? DISABLE_WARNING : WARNING);
            } else {
                int state = this.node.getManagedState();
                if (2 == state) {
                    leftTopC = WARNING;
                }
            }
            if (leftTopC != null) {
                NodeWidget.paintCorner(1, g, bounds, leftTopC, Color.WHITE, bounds.width, bounds.height / 2);
            }
            if (this.node.getPrimaryLevel() == 1) {
                NodeWidget.paintBottom(g, bounds, DIRECTS, Color.WHITE, bounds.height / 6);
            }
        }
        if (this.getState().isHovered() || this.getState().isSelected()) {
            NodeWidget.paintHover(g, bounds, this.hoverBorderC, this.getState().isSelected());
        }
    }

    private static void paintCorner(int corner, Graphics2D g, Rectangle bounds, Color c1, Color c2, int x, int y) {
        double h = y * y + x * x;
        int gradX = (int)((double)(y * y * x) / h);
        int gradY = (int)((double)(y * x * x) / h);
        Point startPoint = new Point();
        Point direction = new Point();
        switch (corner) {
            case 1: {
                startPoint.x = bounds.x;
                startPoint.y = bounds.y;
                direction.x = 1;
                direction.y = 1;
                break;
            }
            case 2: {
                startPoint.x = bounds.x;
                startPoint.y = bounds.y + bounds.height;
                direction.x = 1;
                direction.y = -1;
                break;
            }
            case 3: {
                startPoint.x = bounds.x + bounds.width;
                startPoint.y = bounds.y;
                direction.x = -1;
                direction.y = 1;
                break;
            }
            case 4: {
                startPoint.x = bounds.x + bounds.width;
                startPoint.y = bounds.y + bounds.height;
                direction.x = -1;
                direction.y = -1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Corner id not valid");
            }
        }
        g.setPaint(new GradientPaint(startPoint.x, startPoint.y, c1, startPoint.x + direction.x * gradX, startPoint.y + direction.y * gradY, c2));
        g.fillRect(Math.min(startPoint.x, startPoint.x + direction.x * x), Math.min(startPoint.y, startPoint.y + direction.y * y), x, y);
    }

    private static void paintBottom(Graphics2D g, Rectangle bounds, Color c1, Color c2, int thickness) {
        g.setPaint(new GradientPaint(bounds.x, bounds.y + bounds.height, c1, bounds.x, bounds.y + bounds.height - thickness, c2));
        g.fillRect(bounds.x, bounds.y + bounds.height - thickness, bounds.width, thickness);
    }

    private static void paintHover(Graphics2D g, Rectangle bounds, Color c, boolean selected) {
        g.setColor(c);
        g.drawRect(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
        if (!selected) {
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 150));
        }
        g.drawRect(bounds.x + 2, bounds.y + 2, bounds.width - 4, bounds.height - 4);
        if (selected) {
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 150));
        } else {
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 75));
        }
        g.drawRect(bounds.x + 3, bounds.y + 3, bounds.width - 6, bounds.height - 6);
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        super.notifyStateChanged(previousState, state);
        boolean repaintNeeded = false;
        boolean updateNeeded = false;
        if (this.paintState != 0) {
            if (!previousState.isHovered() && state.isHovered()) {
                this.hoverTimer.restart();
                repaintNeeded = true;
            }
            if (previousState.isHovered() && !state.isHovered()) {
                this.hoverTimer.stop();
                repaintNeeded = true;
                updateNeeded = this.enlargedFromHover;
                this.enlargedFromHover = false;
            }
        }
        if (previousState.isSelected() != state.isSelected()) {
            updateNeeded = true;
        }
        if (updateNeeded) {
            this.updateContent();
        } else if (repaintNeeded) {
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.enlargedFromHover = true;
        this.updateContent();
    }

    public void setReadable(boolean readable) {
        if (this.readable == readable) {
            return;
        }
        this.readable = readable;
        this.updateContent();
    }

    public boolean isReadable() {
        return this.readable;
    }

    public GraphNode getNode() {
        return this.node;
    }

    public void updateReadableZoom() {
        if (this.isReadable()) {
            this.updateContent();
        }
    }

    private void updateContent() {
        Font origF;
        boolean makeReadable = this.getState().isSelected() || this.readable;
        Font newF = origF = this.getOrigFont();
        if (makeReadable) {
            this.bringToFront();
            newF = NodeWidget.getReadable(this.getScene(), origF);
        }
        this.nodeW.getLabelWidget().setFont(newF);
        if (this.versionW != null) {
            this.versionW.setFont(newF);
        }
        if (this.fixHintW != null) {
            this.fixHintW.setVisible(makeReadable);
        }
    }

    private Font getOrigFont() {
        if (this.origFont == null) {
            this.origFont = this.nodeW.getFont();
            if (this.origFont == null) {
                this.origFont = this.getScene().getDefaultFont();
            }
        }
        return this.origFont;
    }

    public static Font getReadable(Scene scene, Font original) {
        float fSizeRatio = (float)scene.getDefaultFont().getSize() / (float)original.getSize();
        float ratio = (float)Math.max(1.0, (double)fSizeRatio / Math.max((double)1.0E-4f, scene.getZoomFactor()));
        if (ratio != 1.0f) {
            return original.deriveFont((float)original.getSize() * ratio);
        }
        return original;
    }

    public void bulbHovered() {
        if (this.fixHintW != null) {
            this.fixHintW.setImage(ImageUtilities.loadImage((String)BULB_HIGHLIGHT_ICON));
        }
    }

    public void bulbUnhovered() {
        if (this.fixHintW != null) {
            this.fixHintW.setImage(ImageUtilities.loadImage((String)BULB_ICON));
        }
    }
}

