/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.AppearanceController;
import org.netbeans.lib.profiler.ui.ResultsPanel;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.modules.profiler.api.GoToSource;

public abstract class CPUResultsPanel
extends ResultsPanel
implements CommonConstants {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String GO_TO_SOURCE_ITEM_NAME = messages.getString("CPUResultsPanel_GoToSourceItemName");
    private static final String BACKTRACES_ITEM_NAME = messages.getString("CPUResultsPanel_BackTracesItemName");
    private static final String SUBTREE_ITEM_NAME = messages.getString("CPUResultsPanel_SubtreeItemName");
    private static final String ROOT_METHODS_ITEM_NAME = messages.getString("CPUResultsPanel_RootMethodsItemName");
    protected CPUResUserActionsHandler actionsHandler;
    protected JMenuItem popupAddToRoots;
    protected JMenuItem popupFind;
    protected JMenuItem popupShowReverse;
    protected JMenuItem popupShowSource;
    protected JMenuItem popupShowSubtree;
    protected JPopupMenu callGraphPopupMenu;
    protected JPopupMenu cornerPopup;
    protected TreePath popupPath;
    protected String[] columnNames;
    protected TableCellRenderer[] columnRenderers;
    protected String[] columnToolTips;
    protected int[] columnWidths;
    protected boolean[] columnsVisibility;
    protected int columnCount = 0;
    protected int currentView;
    protected int methodId;
    private Boolean sampling;

    public CPUResultsPanel(CPUResUserActionsHandler actionsHandler, Boolean sampling) {
        this.actionsHandler = actionsHandler;
        this.sampling = sampling;
        this.callGraphPopupMenu = this.createPopupMenu();
        if (this.popupFind != null) {
            this.popupFind.setVisible(false);
        }
    }

    public abstract int getCurrentThreadId();

    public int getCurrentView() {
        return this.currentView;
    }

    public JMenuItem getPopupFindItem() {
        return this.popupFind;
    }

    public boolean getSortingOrder() {
        return false;
    }

    public Boolean isSampling() {
        return this.sampling;
    }

    public void changeView(int view) {
        if (this.currentView == view) {
            return;
        }
        this.currentView = view;
        if (this.popupShowSource != null) {
            this.popupShowSource.setEnabled(this.isShowSourceAvailable());
        }
        if (this.popupAddToRoots != null) {
            this.popupAddToRoots.setEnabled(this.isAddToRootsAvailable());
        }
        this.actionsHandler.viewChanged(view);
    }

    public abstract void reset();

    public int getSortingColumn() {
        return -1;
    }

    protected boolean isAddToRootsAvailable() {
        return this.currentView == 0;
    }

    protected abstract String[] getMethodClassNameAndSig(int var1, int var2);

    protected abstract String getSelectedMethodName();

    protected boolean isShowSourceAvailable() {
        return this.currentView != 2;
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        if (GoToSource.isAvailable()) {
            this.popupShowSource = new JMenuItem();
        }
        if (AppearanceController.getDefault().isAddToRootsVisible()) {
            this.popupAddToRoots = new JMenuItem();
        }
        this.popupFind = new JMenuItem();
        Font boldfont = popup.getFont().deriveFont(1);
        ActionListener menuListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPUResultsPanel.this.menuActionPerformed(evt);
            }
        };
        boolean separator = true;
        if (this.popupShowSource != null) {
            this.popupShowSource.setFont(boldfont);
            this.popupShowSource.setText(GO_TO_SOURCE_ITEM_NAME);
            popup.add(this.popupShowSource);
            separator = false;
        }
        if (this.supportsSubtreeCallGraph()) {
            if (!separator) {
                popup.addSeparator();
                separator = true;
            }
            this.popupShowSubtree = new JMenuItem();
            this.popupShowSubtree.setText(SUBTREE_ITEM_NAME);
            popup.add(this.popupShowSubtree);
            this.popupShowSubtree.addActionListener(menuListener);
        }
        if (this.supportsReverseCallGraph()) {
            if (!separator) {
                popup.addSeparator();
                separator = true;
            }
            this.popupShowReverse = new JMenuItem();
            this.popupShowReverse.setText(BACKTRACES_ITEM_NAME);
            popup.add(this.popupShowReverse);
            this.popupShowReverse.addActionListener(menuListener);
        }
        popup.add(this.popupFind);
        if (this.popupAddToRoots != null) {
            popup.addSeparator();
            this.popupAddToRoots.setText(ROOT_METHODS_ITEM_NAME);
            popup.add(this.popupAddToRoots);
            this.popupAddToRoots.addActionListener(menuListener);
        }
        if (this.popupShowSource != null) {
            this.popupShowSource.addActionListener(menuListener);
        }
        this.popupFind.addActionListener(menuListener);
        return popup;
    }

    protected void performDefaultAction() {
        if (this.popupPath != null) {
            this.showSourceForMethod(this.popupPath);
        } else {
            this.showSourceForMethod(this.methodId);
        }
    }

    protected void showSourceForMethod(int methodId) {
        if (this.currentView != 2) {
            boolean methodLevelView = this.currentView == 0;
            String[] classMethodAndSig = this.getMethodClassNameAndSig(methodId, this.currentView);
            this.actionsHandler.showSourceForMethod(classMethodAndSig[0], methodLevelView ? classMethodAndSig[1] : null, methodLevelView ? classMethodAndSig[2] : null);
        }
    }

    protected void showSourceForMethod(TreePath popupPath) {
        PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)popupPath.getLastPathComponent();
        if (node.getMethodId() == 0 || node.isFiltered()) {
            return;
        }
        if (this.currentView != 2) {
            boolean methodLevelView = this.currentView == 0;
            String[] classMethodAndSig = this.getMethodClassNameAndSig(node.getMethodId(), this.currentView);
            this.actionsHandler.showSourceForMethod(classMethodAndSig[0], methodLevelView ? classMethodAndSig[1] : null, methodLevelView ? classMethodAndSig[2] : null);
        }
    }

    protected abstract boolean supportsReverseCallGraph();

    protected abstract boolean supportsSubtreeCallGraph();

    protected void showReverseCallGraph(int threadId, int methodId, int currentView, int sortingColumn, boolean sortingOrder) {
    }

    protected void showSubtreeCallGraph(CCTNode node, int currentView, int sortingColumn, boolean sortingOrder) {
    }

    public void setColumnsVisibility(boolean[] columnsVisibility) {
    }

    public boolean[] getColumnsVisibility() {
        return null;
    }

    void menuActionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.popupShowSource && this.popupShowSource != null) {
            this.performDefaultAction();
        } else if (src == this.popupShowReverse) {
            int threadId = 0;
            if (this.popupPath != null) {
                PrestimeCPUCCTNode selectedNode = (PrestimeCPUCCTNode)this.popupPath.getLastPathComponent();
                if (selectedNode.getParent() == null) {
                    return;
                }
                if (selectedNode.isSelfTimeNode()) {
                    selectedNode = (PrestimeCPUCCTNode)selectedNode.getParent();
                }
                if (selectedNode == null) {
                    return;
                }
                if (selectedNode.getMethodId() == 0) {
                    if (selectedNode.getNChildren() > 0) {
                        this.methodId = ((PrestimeCPUCCTNode)selectedNode.getChild(0)).getMethodId();
                    }
                } else {
                    this.methodId = selectedNode.getMethodId();
                }
                threadId = selectedNode.getThreadId();
            } else {
                threadId = this.getCurrentThreadId();
            }
            this.showReverseCallGraph(threadId, this.methodId, this.currentView, this.getSortingColumn(), this.getSortingOrder());
        } else if (src == this.popupShowSubtree) {
            if (this.popupPath != null) {
                if (this.popupPath.getParentPath() == null) {
                    return;
                }
                PrestimeCPUCCTNode selectedNode = (PrestimeCPUCCTNode)this.popupPath.getLastPathComponent();
                if (selectedNode.isSelfTimeNode()) {
                    selectedNode = (PrestimeCPUCCTNode)selectedNode.getParent();
                }
                if (selectedNode == null) {
                    return;
                }
                this.showSubtreeCallGraph((CCTNode)selectedNode, this.currentView, this.getSortingColumn(), this.getSortingOrder());
            }
        } else if (src == this.popupAddToRoots) {
            if (this.popupPath != null) {
                PrestimeCPUCCTNode selectedNode = (PrestimeCPUCCTNode)this.popupPath.getLastPathComponent();
                if (selectedNode.getMethodId() == 0) {
                    if (selectedNode.getParent() instanceof PrestimeCPUCCTNode) {
                        this.methodId = ((PrestimeCPUCCTNode)selectedNode.getParent()).getMethodId();
                    }
                } else {
                    this.methodId = selectedNode.getMethodId();
                }
            }
            String[] methodClassNameAndSig = this.getMethodClassNameAndSig(this.methodId, this.currentView);
            this.actionsHandler.addMethodToRoots(methodClassNameAndSig[0], methodClassNameAndSig[1], methodClassNameAndSig[2]);
        } else if (src == this.popupFind) {
            this.actionsHandler.find(this, this.getSelectedMethodName());
        }
    }
}

