/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.html.editor.HtmlExtensions;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class HtmlSemanticAnalyzer
extends SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        this.cancelled = false;
        HashMap<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        HtmlParserResult htmlResult = (HtmlParserResult)result;
        String sourceMimetype = Utils.getWebPageMimeType(htmlResult.getSyntaxAnalyzerResult());
        for (HtmlExtension htmlExtension : HtmlExtensions.getRegisteredExtensions(sourceMimetype)) {
            if (this.cancelled) {
                return;
            }
            highlights.putAll(htmlExtension.getHighlights(htmlResult, event));
        }
        this.semanticHighlights = highlights;
    }

    public int getPriority() {
        return 500;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return null;
    }
}

