/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.modules.editor.bookmarks.BookmarksPersistence;
import org.openide.modules.ModuleInstall;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

class EditorBookmarksModule
extends ModuleInstall {
    private static final String DOCUMENT_TRACKER_PROP = "EditorBookmarksModule.DOCUMENT_TRACKER_PROP";
    private BookmarksInitializer bookmarksInitializer;

    EditorBookmarksModule() {
    }

    public void restored() {
        if (this.bookmarksInitializer == null) {
            this.bookmarksInitializer = new BookmarksInitializer();
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                for (JTextComponent c : EditorRegistry.componentList()) {
                    BookmarkList.get(c.getDocument());
                }
            }
        });
    }

    public boolean closing() {
        this.finish();
        return super.closing();
    }

    public void uninstalled() {
        this.finish();
    }

    private void finish() {
        BookmarksPersistence.get().endProjectsListening();
        if (this.bookmarksInitializer != null) {
            this.bookmarksInitializer.destroy();
        }
    }

    private class BookmarksInitializer
    implements PropertyChangeListener,
    Runnable {
        private final PropertyChangeListener documentListener;
        private final RequestProcessor.Task myTask;

        BookmarksInitializer() {
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
            this.documentListener = WeakListeners.propertyChange((PropertyChangeListener)this, null);
            this.myTask = BookmarksPersistence.get().createTask(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Document newDoc;
            if (evt.getSource() == EditorRegistry.class) {
                if (evt.getPropertyName() == null || "focusGained".equals(evt.getPropertyName())) {
                    JTextComponent jtc = (JTextComponent)evt.getNewValue();
                    PropertyChangeListener l = (PropertyChangeListener)jtc.getClientProperty(EditorBookmarksModule.DOCUMENT_TRACKER_PROP);
                    if (l == null) {
                        jtc.putClientProperty(EditorBookmarksModule.DOCUMENT_TRACKER_PROP, this.documentListener);
                        jtc.addPropertyChangeListener(this.documentListener);
                    }
                    this.myTask.schedule(100);
                }
                return;
            }
            if (evt.getSource() instanceof JTextComponent && (evt.getPropertyName() == null || "document".equals(evt.getPropertyName())) && (newDoc = (Document)evt.getNewValue()) != null) {
                this.myTask.schedule(100);
            }
        }

        void destroy() {
            EditorRegistry.removePropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void run() {
            Document doc;
            JTextComponent jtc = EditorRegistry.focusedComponent();
            if (jtc != null && (doc = jtc.getDocument()) != null) {
                BookmarkList.get(jtc.getDocument());
            }
        }
    }
}

