# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_algorithm import ImageAlgorithm


class PResampleFilter(ImageAlgorithm):
    """
    PResampleFilter - probe dataset in parallel using a ImageData
    
    Superclass: ImageAlgorithm
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPResampleFilter, obj, update, **traits)
    
    use_input_bounds = tvtk_base.true_bool_trait(desc=\
        """
        Set/Get if the filter should use Input bounds to sub-sample the
        data. By default it is set to 1.
        """
    )

    def _use_input_bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseInputBounds,
                        self.use_input_bounds_)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        Set and get the controller.
        """
    )

    custom_sampling_bounds = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="float", value=(0.0, 1.0, 0.0, 1.0, 0.0, 1.0), cols=3, desc=\
        """
        
        """
    )

    def _custom_sampling_bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCustomSamplingBounds,
                        self.custom_sampling_bounds)

    sampling_dimension = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int", value=(10, 10, 10), cols=3, desc=\
        """
        
        """
    )

    def _sampling_dimension_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSamplingDimension,
                        self.sampling_dimension)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('use_input_bounds', 'GetUseInputBounds'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('custom_sampling_bounds',
    'GetCustomSamplingBounds'), ('sampling_dimension',
    'GetSamplingDimension'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'use_input_bounds', 'custom_sampling_bounds',
    'progress_text', 'sampling_dimension'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PResampleFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PResampleFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['use_input_bounds'], [], ['custom_sampling_bounds',
            'sampling_dimension']),
            title='Edit PResampleFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PResampleFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

