/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.SMAPBuilder;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public abstract class AbstractClassBuilder
implements ClassBuilder {
    protected static final MethodVisitor EMPTY_METHOD_VISITOR = new MethodVisitor(458752){};
    protected static final FieldVisitor EMPTY_FIELD_VISITOR = new FieldVisitor(458752){};
    private String thisName;
    private final JvmSerializationBindings serializationBindings = new JvmSerializationBindings();
    private final List<FileMapping> fileMappings = new ArrayList<FileMapping>();
    private String sourceName;
    private String debugInfo;

    @Override
    @NotNull
    public FieldVisitor newField(@NotNull JvmDeclarationOrigin origin, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
        FieldVisitor visitor2 = this.getVisitor().visitField(access, name, desc, signature, value);
        if (visitor2 == null) {
            return EMPTY_FIELD_VISITOR;
        }
        return visitor2;
    }

    @Override
    @NotNull
    public MethodVisitor newMethod(@NotNull JvmDeclarationOrigin origin, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        MethodVisitor visitor2 = this.getVisitor().visitMethod(access, name, desc, signature, exceptions);
        if (visitor2 == null) {
            return EMPTY_METHOD_VISITOR;
        }
        return visitor2;
    }

    @Override
    @NotNull
    public JvmSerializationBindings getSerializationBindings() {
        return this.serializationBindings;
    }

    @Override
    @NotNull
    public AnnotationVisitor newAnnotation(@NotNull String desc, boolean visible) {
        return this.getVisitor().visitAnnotation(desc, visible);
    }

    @Override
    public void done() {
        if (!this.fileMappings.isEmpty()) {
            FileMapping origin = this.fileMappings.get(0);
            assert (this.sourceName == null || origin.getName().equals(this.sourceName)) : "Error " + origin.getName() + " != " + this.sourceName;
            this.getVisitor().visitSource(origin.getName(), new SMAPBuilder(origin.getName(), origin.getPath(), this.fileMappings).build());
        } else {
            this.getVisitor().visitSource(this.sourceName, this.debugInfo);
        }
        this.getVisitor().visitEnd();
    }

    @Override
    public void defineClass(@Nullable PsiElement origin, int version, int access, @NotNull String name, @Nullable String signature, @NotNull String superName, @NotNull String[] interfaces) {
        this.thisName = name;
        this.getVisitor().visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitSource(@NotNull String name, @Nullable String debug) {
        this.sourceName = name;
        this.debugInfo = debug;
    }

    @Override
    public void visitOuterClass(@NotNull String owner, @Nullable String name, @Nullable String desc) {
        this.getVisitor().visitOuterClass(owner, name, desc);
    }

    @Override
    public void visitInnerClass(@NotNull String name, @Nullable String outerName, @Nullable String innerName, int access) {
        this.getVisitor().visitInnerClass(name, outerName, innerName, access);
    }

    @Override
    @NotNull
    public String getThisName() {
        assert (this.thisName != null) : "This name isn't set";
        return this.thisName;
    }

    @Override
    public void addSMAP(FileMapping mapping2) {
        this.fileMappings.add(mapping2);
    }

    public static class Concrete
    extends AbstractClassBuilder {
        private final ClassVisitor v;

        public Concrete(@NotNull ClassVisitor v2) {
            this.v = v2;
        }

        @Override
        @NotNull
        public ClassVisitor getVisitor() {
            return this.v;
        }
    }
}

