/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import jadx.gui.utils.NLS;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class TextStandardActions {
    private final JTextComponent textComponent;
    private final JPopupMenu popup = new JPopupMenu();
    private final UndoManager undoManager;
    private Action undoAction;
    private Action redoAction;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action deleteAction;
    private Action selectAllAction;

    public TextStandardActions(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.undoManager = new UndoManager();
        this.initActions();
        this.addPopupItems();
        this.addKeyActions();
        this.registerListeners();
    }

    private void initActions() {
        this.undoAction = new AbstractAction(NLS.str("popup.undo")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (TextStandardActions.this.undoManager.canUndo()) {
                    TextStandardActions.this.undoManager.undo();
                }
            }
        };
        this.redoAction = new AbstractAction(NLS.str("popup.redo")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (TextStandardActions.this.undoManager.canRedo()) {
                    TextStandardActions.this.undoManager.redo();
                }
            }
        };
        this.cutAction = new AbstractAction(NLS.str("popup.cut")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextStandardActions.this.textComponent.cut();
            }
        };
        this.copyAction = new AbstractAction(NLS.str("popup.copy")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextStandardActions.this.textComponent.copy();
            }
        };
        this.pasteAction = new AbstractAction(NLS.str("popup.paste")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextStandardActions.this.textComponent.paste();
            }
        };
        this.deleteAction = new AbstractAction(NLS.str("popup.delete")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextStandardActions.this.textComponent.replaceSelection("");
            }
        };
        this.selectAllAction = new AbstractAction(NLS.str("popup.select_all")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextStandardActions.this.textComponent.selectAll();
            }
        };
    }

    void addPopupItems() {
        this.popup.add(this.undoAction);
        this.popup.add(this.redoAction);
        this.popup.addSeparator();
        this.popup.add(this.cutAction);
        this.popup.add(this.copyAction);
        this.popup.add(this.pasteAction);
        this.popup.add(this.deleteAction);
        this.popup.addSeparator();
        this.popup.add(this.selectAllAction);
    }

    private void addKeyActions() {
        KeyStroke undoKey = KeyStroke.getKeyStroke(90, 128);
        this.textComponent.getInputMap().put(undoKey, this.undoAction);
        KeyStroke redoKey = KeyStroke.getKeyStroke(82, 128);
        this.textComponent.getInputMap().put(redoKey, this.redoAction);
    }

    private void registerListeners() {
        this.textComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3 && e.getSource() == TextStandardActions.this.textComponent) {
                    TextStandardActions.this.process(e);
                }
            }
        });
        this.textComponent.getDocument().addUndoableEditListener(event -> this.undoManager.addEdit(event.getEdit()));
    }

    private void process(MouseEvent e) {
        this.textComponent.requestFocus();
        boolean enabled = this.textComponent.isEnabled();
        boolean editable = this.textComponent.isEditable();
        boolean nonempty = this.textComponent.getText() != null && !this.textComponent.getText().equals("");
        boolean marked = this.textComponent.getSelectedText() != null;
        boolean pasteAvailable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).isDataFlavorSupported(DataFlavor.stringFlavor);
        this.undoAction.setEnabled(enabled && editable && this.undoManager.canUndo());
        this.redoAction.setEnabled(enabled && editable && this.undoManager.canRedo());
        this.cutAction.setEnabled(enabled && editable && marked);
        this.copyAction.setEnabled(enabled && marked);
        this.pasteAction.setEnabled(enabled && editable && pasteAvailable);
        this.deleteAction.setEnabled(enabled && editable && marked);
        this.selectAllAction.setEnabled(enabled && nonempty);
        int nx = e.getX();
        if (nx > 500) {
            nx -= this.popup.getSize().width;
        }
        this.popup.show(e.getComponent(), nx, e.getY() - this.popup.getSize().height);
    }
}

