---
comments: false
---

# From 2.9 to 3.0
*Make sure you view this [upgrade guide from the `master` branch](https://gitlab.com/gitlab-org/gitlab-ce/tree/master/doc/update/2.9-to-3.0.md) for the most up to date instructions.*

## 1. Stop server & resque

    sudo service gitlab stop

## 2. Follow instructions

```bash

# Get latest code
sudo -u gitlab -H git fetch origin
sudo -u gitlab -H git checkout v3.0.3

# The Modernizr gem was yanked from RubyGems. It is required for GitLab >= 2.8.0
# Edit `Gemfile` and change `gem "modernizr", "2.5.3"` to
# `gem "modernizr-rails", "2.7.1"``
sudo -u gitlab -H vim Gemfile

# Install gems
sudo -u gitlab -H bundle install --without development test postgres

# Migrate db
sudo -u gitlab -H bundle exec rake db:migrate RAILS_ENV=production

# Make some changes to gitolite v3 config
# For more information visit https://github.com/gitlabhq/gitlabhq/pull/1719

# Gitolite version 3
sudo -u git -H sed -i "s/\(GIT_CONFIG_KEYS\s*=>*\s*\).\{2\}/\\1'\.\*'/g" /home/git/.gitolite.rc

# If you still use gitolite v2
sudo -u git -H sed -i 's/\(GL_GITCONFIG_KEYS\s*=>*\s*\).\{2\}/\\1"\.\*"/g' /home/git/.gitolite.rc

# Check APP Status
sudo -u gitlab -H bundle exec rake gitlab:app:status RAILS_ENV=production
```

## 3. Start all

    sudo service gitlab start
