/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpoints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpoints.DefaultCBreakpointUIContribution;
import org.eclipse.cdt.debug.ui.breakpoints.ICBreakpointsUIContribution;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;

public class CBreakpointUIContributionFactory {
    private static final String EXTENSION_POINT_NAME = "breakpointContribution";
    private static CBreakpointUIContributionFactory instance;
    protected ArrayList<ICBreakpointsUIContribution> contributions = new ArrayList();
    public static final String[] DEBUG_MODEL_IDS_DEFAULT;

    static {
        DEBUG_MODEL_IDS_DEFAULT = new String[0];
    }

    private CBreakpointUIContributionFactory() {
        this.loadSubtypeContributions();
    }

    public ICBreakpointsUIContribution[] getBreakpointUIContributions(IBreakpoint breakpoint) throws CoreException {
        String debugModelId = null;
        IMarker bmarker = breakpoint.getMarker();
        Map attributes = Collections.emptyMap();
        String markerType = CDIDebugModel.calculateMarkerType((IBreakpoint)breakpoint);
        if (bmarker != null) {
            Map _attributes;
            attributes = _attributes = bmarker.getAttributes();
            markerType = bmarker.getType();
        }
        return this.getBreakpointUIContributions(debugModelId, markerType, (Map<String, Object>)attributes);
    }

    public ICBreakpointsUIContribution[] getBreakpointUIContributions(String[] debugModelIDs, IBreakpoint breakpoint, Map<String, Object> attributes) throws CoreException {
        IMarker bmarker = breakpoint.getMarker();
        String markerType = CDIDebugModel.calculateMarkerType((IBreakpoint)breakpoint);
        if (bmarker != null) {
            markerType = bmarker.getType();
        }
        return this.getBreakpointUIContributions(debugModelIDs, markerType, attributes);
    }

    public ICBreakpointsUIContribution[] getBreakpointUIContributions(String debugModelId, String markerType, Map<String, Object> attributes) {
        String[] stringArray;
        if (debugModelId != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = debugModelId;
        } else {
            stringArray = null;
        }
        return this.getBreakpointUIContributions(stringArray, markerType, attributes);
    }

    public ICBreakpointsUIContribution[] getBreakpointUIContributions(String[] debugModelIds, String markerType, Map<String, Object> attributes) {
        List<String> debugModelIdsList = null;
        if (debugModelIds != null) {
            debugModelIdsList = Arrays.asList(debugModelIds);
        }
        ArrayList<ICBreakpointsUIContribution> list = new ArrayList<ICBreakpointsUIContribution>();
        for (ICBreakpointsUIContribution con : this.contributions) {
            try {
                String contributedMarkerType;
                if (con.getDebugModelId() != null && debugModelIdsList != null && !debugModelIdsList.contains(con.getDebugModelId()) || !this.isMarkerSubtypeOf(markerType, contributedMarkerType = con.getMarkerType()) || attributes != null && !con.isApplicable(attributes)) continue;
                list.add(con);
            }
            catch (Exception e) {
                CDebugUIPlugin.log(e);
            }
        }
        return list.toArray(new ICBreakpointsUIContribution[list.size()]);
    }

    public boolean isMarkerSubtypeOf(String currentType, String type) throws CoreException {
        return this.getWorkspace().getMarkerManager().isSubtype(currentType, type);
    }

    private Workspace getWorkspace() {
        return (Workspace)CDebugUIPlugin.getWorkspace();
    }

    private void loadSubtypeContributions() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(CDebugUIPlugin.getUniqueIdentifier(), EXTENSION_POINT_NAME);
        if (ep == null) {
            return;
        }
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement configurationElement = elements[i];
            if (configurationElement.getName().equals("breakpointLabels") || configurationElement.getName().equals("breakpointEditors")) {
                String mainElement = configurationElement.getName();
                String modelId = configurationElement.getAttribute("debugModelId");
                String markerType = CBreakpointUIContributionFactory.getRequired(configurationElement, "markerType");
                if (markerType != null) {
                    IConfigurationElement[] children;
                    IConfigurationElement[] iConfigurationElementArray = children = configurationElement.getChildren("attribute");
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement att = iConfigurationElementArray[n2];
                        DefaultCBreakpointUIContribution adapter = new DefaultCBreakpointUIContribution(att);
                        adapter.setMainElement(mainElement);
                        adapter.setMarkerType(markerType);
                        adapter.setDebugModelId(modelId);
                        if (!this.processAttribute(att, adapter)) {
                            // empty if block
                        }
                        ++n2;
                    }
                }
            }
            ++i;
        }
    }

    private boolean processAttribute(IConfigurationElement attrElement, DefaultCBreakpointUIContribution adapter) {
        IConfigurationElement[] children;
        String attrId = CBreakpointUIContributionFactory.getRequired(attrElement, "name");
        String attrLabel = CBreakpointUIContributionFactory.getRequired(attrElement, "label");
        String fieldEditorClass = attrElement.getAttribute("fieldEditor");
        String fieldEditorFactoryClass = attrElement.getAttribute("fieldEditorFactory");
        String type = attrElement.getAttribute("type");
        String svisible = attrElement.getAttribute("visible");
        if (attrId == null) {
            return false;
        }
        if (attrLabel == null) {
            return false;
        }
        if (type == null) {
            type = "string";
        }
        boolean visible = true;
        if (svisible != null && svisible.equalsIgnoreCase("false")) {
            visible = false;
        }
        adapter.setId(attrId);
        adapter.setLabel(attrLabel);
        adapter.setControlClass(fieldEditorClass);
        adapter.setFieldEditorFactory(fieldEditorFactoryClass);
        adapter.setType(type);
        adapter.setVisible(visible);
        this.addContribution(adapter);
        IConfigurationElement[] iConfigurationElementArray = children = attrElement.getChildren("value");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement value = iConfigurationElementArray[n2];
            this.processValue(value, adapter);
            ++n2;
        }
        return true;
    }

    private void processValue(IConfigurationElement valueElement, DefaultCBreakpointUIContribution adapter) {
        IConfigurationElement[] children;
        String valueId = CBreakpointUIContributionFactory.getRequired(valueElement, "value");
        String valueLabel = CBreakpointUIContributionFactory.getRequired(valueElement, "label");
        if (valueId == null) {
            return;
        }
        if (valueLabel == null) {
            return;
        }
        adapter.addValue(valueId, valueLabel);
        IConfigurationElement[] iConfigurationElementArray = children = valueElement.getChildren("attribute");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement att = iConfigurationElementArray[n2];
            DefaultCBreakpointUIContribution adapter2 = new DefaultCBreakpointUIContribution(att);
            adapter2.setMainElement(adapter.getMainElement());
            adapter2.setMarkerType(adapter.getMarkerType());
            adapter2.setDebugModelId(adapter.getDebugModelId());
            adapter2.addContionsAll(adapter.getConditions());
            adapter2.addContionEquals(adapter.getId(), valueId);
            if (!this.processAttribute(att, adapter2)) {
                // empty if block
            }
            ++n2;
        }
    }

    public void addContribution(ICBreakpointsUIContribution contribution) {
        this.contributions.add(contribution);
    }

    public static CBreakpointUIContributionFactory getInstance() {
        if (instance == null) {
            instance = new CBreakpointUIContributionFactory();
        }
        return instance;
    }

    private static String getRequired(IConfigurationElement configurationElement, String name) {
        String elementValue = configurationElement.getAttribute(name);
        if (elementValue == null) {
            CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 120, "Extension " + configurationElement.getDeclaringExtension().getUniqueIdentifier() + " missing required attribute: " + name, null));
        }
        return elementValue;
    }
}

