/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.refactoring.CreateFileChange;
import org.eclipse.lsp4j.Color;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPEclipseUtils {
    private static final int MAX_BROWSER_NAME_LENGTH = 30;

    private LSPEclipseUtils() {
    }

    public static ITextEditor getActiveTextEditor() {
        MultiPageEditorPart multiPageEditorPart;
        Object page;
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof ITextEditor) {
            return (ITextEditor)editorPart;
        }
        if (editorPart instanceof MultiPageEditorPart && (page = (multiPageEditorPart = (MultiPageEditorPart)editorPart).getSelectedPage()) instanceof ITextEditor) {
            return (ITextEditor)page;
        }
        return null;
    }

    public static Position toPosition(int offset, IDocument document) throws BadLocationException {
        Position res = new Position();
        res.setLine(document.getLineOfOffset(offset));
        res.setCharacter(offset - document.getLineInformationOfOffset(offset).getOffset());
        return res;
    }

    public static int toOffset(Position position, IDocument document) throws BadLocationException {
        return document.getLineInformation(position.getLine()).getOffset() + position.getCharacter();
    }

    public static CompletionParams toCompletionParams(URI fileUri, int offset, IDocument document) throws BadLocationException {
        Position start = LSPEclipseUtils.toPosition(offset, document);
        CompletionParams param = new CompletionParams();
        param.setPosition(start);
        param.setUri(fileUri.toString());
        TextDocumentIdentifier id = new TextDocumentIdentifier();
        id.setUri(fileUri.toString());
        param.setTextDocument(id);
        return param;
    }

    public static TextDocumentPositionParams toTextDocumentPosistionParams(URI fileUri, int offset, IDocument document) throws BadLocationException {
        Position start = LSPEclipseUtils.toPosition(offset, document);
        TextDocumentPositionParams param = new TextDocumentPositionParams();
        param.setPosition(start);
        param.setUri(fileUri.toString());
        TextDocumentIdentifier id = new TextDocumentIdentifier();
        id.setUri(fileUri.toString());
        param.setTextDocument(id);
        return param;
    }

    public static int toEclipseMarkerSeverity(DiagnosticSeverity lspSeverity) {
        if (lspSeverity == null) {
            return 2;
        }
        switch (lspSeverity) {
            case Error: {
                return 2;
            }
            case Warning: {
                return 1;
            }
        }
        return 0;
    }

    public static IFile getFileHandle(@Nullable String uri) {
        if (uri == null || uri.isEmpty() || !uri.startsWith("file:")) {
            return null;
        }
        String convertedUri = uri.replace("file:///", "file:/");
        convertedUri = convertedUri.replace("file://", "file:/");
        IPath path = Path.fromOSString((String)new File(URI.create(convertedUri)).getAbsolutePath());
        IProject project = null;
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject aProject = iProjectArray[n2];
            IPath location = aProject.getLocation();
            if (location != null && location.isPrefixOf(path) && (project == null || project.getLocation().segmentCount() < location.segmentCount())) {
                project = aProject;
            }
            ++n2;
        }
        if (project == null) {
            return null;
        }
        IPath projectRelativePath = path.removeFirstSegments(project.getLocation().segmentCount());
        if (projectRelativePath.isEmpty()) {
            return null;
        }
        return project.getFile(projectRelativePath);
    }

    public static @Nullable IResource findResourceFor(@Nullable String uri) {
        if (uri == null || uri.isEmpty() || !uri.startsWith("file:")) {
            return null;
        }
        String convertedUri = uri.replace("file:///", "file:/");
        convertedUri = convertedUri.replace("file://", "file:/");
        IPath path = Path.fromOSString((String)new File(URI.create(convertedUri)).getAbsolutePath());
        IProject project = null;
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject aProject = iProjectArray[n2];
            IPath location = aProject.getLocation();
            if (location != null && location.isPrefixOf(path) && (project == null || project.getLocation().segmentCount() < location.segmentCount())) {
                project = aProject;
            }
            ++n2;
        }
        if (project == null) {
            return null;
        }
        IPath projectRelativePath = path.removeFirstSegments(project.getLocation().segmentCount());
        if (projectRelativePath.isEmpty()) {
            return project;
        }
        return project.findMember(projectRelativePath);
    }

    public static void applyEdit(org.eclipse.lsp4j.TextEdit textEdit, IDocument document) throws BadLocationException {
        document.replace(LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document), LSPEclipseUtils.toOffset(textEdit.getRange().getEnd(), document) - LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document), textEdit.getNewText());
    }

    public static void applyEdits(IDocument document, List<? extends org.eclipse.lsp4j.TextEdit> edits) {
        if (document == null || edits == null || edits.isEmpty()) {
            return;
        }
        IDocumentUndoManager manager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
        if (manager != null) {
            manager.beginCompoundChange();
        }
        MultiTextEdit edit = new MultiTextEdit();
        for (org.eclipse.lsp4j.TextEdit textEdit : edits) {
            if (textEdit == null) continue;
            try {
                int offset = LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document);
                int length = LSPEclipseUtils.toOffset(textEdit.getRange().getEnd(), document) - offset;
                edit.addChild((TextEdit)new ReplaceEdit(offset, length, textEdit.getNewText()));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        try {
            RewriteSessionEditProcessor rewriteSessionEditProcessor = new RewriteSessionEditProcessor(document, (TextEdit)edit, 0);
            rewriteSessionEditProcessor.performEdits();
        }
        catch (BadLocationException | MalformedTreeException throwable) {
            LanguageServerPlugin.logError(throwable);
        }
        if (manager != null) {
            manager.endCompoundChange();
        }
    }

    public static @Nullable IDocument getDocument(@Nullable IResource resource) {
        if (resource == null) {
            return null;
        }
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IDocument document = null;
        ITextFileBuffer buffer = bufferManager.getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE);
        if (buffer != null) {
            document = buffer.getDocument();
        } else if (resource.getType() == 1) {
            try {
                bufferManager.connect(resource.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                LanguageServerPlugin.logError(e);
                return document;
            }
            buffer = bufferManager.getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE);
            if (buffer != null) {
                document = buffer.getDocument();
            }
        }
        return document;
    }

    public static void openInEditor(Location location, IWorkbenchPage page) {
        LSPEclipseUtils.open(location.getUri(), page, location.getRange());
    }

    public static void open(String uri, IWorkbenchPage page, Range optionalRange) {
        if (uri.startsWith("file:")) {
            LSPEclipseUtils.openFileLocationInEditor(uri, page, optionalRange);
        } else if (uri.startsWith("http://org.eclipse.ui.intro")) {
            LSPEclipseUtils.openIntroURL(uri);
        } else if (uri.startsWith("http")) {
            LSPEclipseUtils.openHttpLocationInBrowser(uri, page);
        }
    }

    protected static void openIntroURL(String uri) {
        IIntroURL introUrl = IntroURLFactory.createIntroURL((String)uri);
        if (introUrl != null) {
            try {
                if (!introUrl.execute()) {
                    LanguageServerPlugin.logWarning("Failed to execute IntroURL: " + uri, null);
                }
            }
            catch (Throwable t) {
                LanguageServerPlugin.logWarning("Error executing IntroURL: " + uri, t);
            }
        }
    }

    protected static void openHttpLocationInBrowser(final String uri, final IWorkbenchPage page) {
        page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    URL url = new URL(uri);
                    IWorkbenchBrowserSupport browserSupport = page.getWorkbenchWindow().getWorkbench().getBrowserSupport();
                    String browserName = uri;
                    if (browserName.length() > 30) {
                        browserName = String.valueOf(uri.substring(0, 29)) + '\u2026';
                    }
                    browserSupport.createBrowser(38, "lsp4e-symbols", browserName, uri).openURL(url);
                }
                catch (Exception e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        });
    }

    protected static void openFileLocationInEditor(String uri, IWorkbenchPage page, Range optionalRange) {
        IEditorPart part = null;
        IDocument targetDocument = null;
        IResource targetResource = LSPEclipseUtils.findResourceFor(uri);
        try {
            if (targetResource != null && targetResource.getType() == 1) {
                part = IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)targetResource));
                targetDocument = FileBuffers.getTextFileBufferManager().getTextFileBuffer(targetResource.getFullPath(), LocationKind.IFILE).getDocument();
            } else {
                URI fileUri = URI.create(uri).normalize();
                IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileUri);
                IFileInfo fetchInfo = fileStore.fetchInfo();
                if (!fetchInfo.isDirectory() && fetchInfo.exists()) {
                    part = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    ITextFileBuffer fileStoreTextFileBuffer = FileBuffers.getTextFileBufferManager().getFileStoreTextFileBuffer(fileStore);
                    targetDocument = fileStoreTextFileBuffer.getDocument();
                }
            }
        }
        catch (PartInitException e) {
            LanguageServerPlugin.logError(e);
        }
        try {
            if (part instanceof AbstractTextEditor && optionalRange != null) {
                AbstractTextEditor editor = (AbstractTextEditor)part;
                int offset = LSPEclipseUtils.toOffset(optionalRange.getStart(), targetDocument);
                int endOffset = LSPEclipseUtils.toOffset(optionalRange.getEnd(), targetDocument);
                editor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset, endOffset > offset ? endOffset - offset : 0));
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    public static IDocument getDocument(ITextEditor editor) {
        try {
            Method getSourceViewerMethod = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            getSourceViewerMethod.setAccessible(true);
            ITextViewer viewer = (ITextViewer)getSourceViewerMethod.invoke((Object)editor, new Object[0]);
            return viewer.getDocument();
        }
        catch (Exception ex) {
            LanguageServerPlugin.logError(ex);
            return null;
        }
    }

    public static IDocument getDocument(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return LSPEclipseUtils.getDocument((IResource)fileEditorInput.getFile());
        }
        if (editorInput instanceof IPathEditorInput) {
            IPathEditorInput pathEditorInput = (IPathEditorInput)editorInput;
            return LSPEclipseUtils.getDocument((IResource)ResourcesPlugin.getWorkspace().getRoot().getFile(pathEditorInput.getPath()));
        }
        if (editorInput instanceof IURIEditorInput) {
            IURIEditorInput uriEditorInput = (IURIEditorInput)editorInput;
            return LSPEclipseUtils.getDocument(LSPEclipseUtils.findResourceFor(uriEditorInput.getURI().toString()));
        }
        return null;
    }

    public static void applyWorkspaceEdit(WorkspaceEdit wsEdit) {
        CompositeChange change = LSPEclipseUtils.toCompositeChange(wsEdit);
        PerformChangeOperation changeOperation = new PerformChangeOperation((Change)change);
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)changeOperation, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    public static CompositeChange toCompositeChange(WorkspaceEdit wsEdit) {
        CompositeChange change = new CompositeChange("LSP Workspace Edit");
        List documentChanges = wsEdit.getDocumentChanges();
        if (documentChanges != null) {
            documentChanges.stream().forEach(action -> {
                if (action.isLeft()) {
                    TextDocumentEdit edit = (TextDocumentEdit)action.getLeft();
                    VersionedTextDocumentIdentifier id = edit.getTextDocument();
                    String uri = id.getUri();
                    List textEdits = edit.getEdits();
                    LSPEclipseUtils.fillTextEdits(uri, textEdits, change);
                    return;
                }
                if (!action.isRight()) return;
                ResourceOperation resourceOperation = (ResourceOperation)action.getRight();
                if (resourceOperation instanceof CreateFile) {
                    CreateFile createOperation = (CreateFile)resourceOperation;
                    IFile targetFile = LSPEclipseUtils.getFileHandle(createOperation.getUri());
                    if (targetFile == null) {
                        return;
                    }
                    if (targetFile.exists()) {
                        if (!createOperation.getOptions().getOverwrite().booleanValue() && createOperation.getOptions().getIgnoreIfExists().booleanValue()) return;
                        IDocument document = LSPEclipseUtils.getDocument(LSPEclipseUtils.findResourceFor(createOperation.getUri()));
                        if (document == null) return;
                        try {
                            org.eclipse.lsp4j.TextEdit edit = new org.eclipse.lsp4j.TextEdit(new Range(new Position(0, 0), LSPEclipseUtils.toPosition(document.getLength() - 1, document)), "");
                            LSPEclipseUtils.fillTextEdits(createOperation.getUri(), Collections.singletonList(edit), change);
                            return;
                        }
                        catch (BadLocationException e) {
                            LanguageServerPlugin.logError(e);
                        }
                        return;
                    } else {
                        CreateFileChange operation = new CreateFileChange(targetFile.getFullPath(), "", null);
                        change.add((Change)operation);
                    }
                    return;
                }
                if (resourceOperation instanceof DeleteFile) {
                    IResource resource = LSPEclipseUtils.findResourceFor(((DeleteFile)resourceOperation).getUri());
                    if (resource != null) {
                        DeleteResourceChange deleteChange = new DeleteResourceChange(resource.getFullPath(), true);
                        change.add((Change)deleteChange);
                        return;
                    } else {
                        LanguageServerPlugin.logWarning("Changes outside of visible projects are not supported at the moment.", null);
                    }
                    return;
                }
                if (!(resourceOperation instanceof RenameFile)) return;
                URI oldURI = URI.create(((RenameFile)resourceOperation).getOldUri());
                URI newURI = URI.create(((RenameFile)resourceOperation).getNewUri());
                IFile oldFile = LSPEclipseUtils.getFileHandle(oldURI.toString());
                IFile newFile = LSPEclipseUtils.getFileHandle(newURI.toString());
                if (oldFile != null) {
                    if (newFile == null) {
                        LanguageServerPlugin.logWarning("target file " + newURI.toString() + " cannot be created in workspace.", null);
                        return;
                    }
                    DeleteResourceChange removeNewFile = null;
                    if (newFile.exists()) {
                        if (((RenameFile)resourceOperation).getOptions().getOverwrite().booleanValue()) {
                            removeNewFile = new DeleteResourceChange(newFile.getFullPath(), true);
                        } else if (((RenameFile)resourceOperation).getOptions().getIgnoreIfExists().booleanValue()) {
                            return;
                        }
                    }
                    try {
                        Throwable throwable = null;
                        Object var9_23 = null;
                        try {
                            ByteArrayOutputStream stream = new ByteArrayOutputStream((int)oldFile.getLocation().toFile().length());
                            try {
                                try (InputStream inputStream = oldFile.getContents();){
                                    FileUtil.transferStreams((InputStream)inputStream, (OutputStream)stream, (String)newFile.getLocation().toString(), null);
                                    CreateFileChange createFileChange = new CreateFileChange(newFile.getFullPath(), new String(stream.toByteArray()), oldFile.getCharset());
                                    DeleteResourceChange removeOldFile = new DeleteResourceChange(oldFile.getFullPath(), true);
                                    if (removeNewFile != null) {
                                        change.add((Change)removeNewFile);
                                    }
                                    change.add((Change)createFileChange);
                                    change.add((Change)removeOldFile);
                                }
                                if (stream == null) return;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (stream == null) throw throwable;
                                stream.close();
                                throw throwable;
                            }
                            stream.close();
                            return;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            } else {
                                if (throwable == throwable3) throw throwable;
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception ex) {
                        LanguageServerPlugin.logError(ex);
                    }
                    return;
                }
                LanguageServerPlugin.logWarning("Source file " + oldURI.toString() + " is missing.", null);
            });
        } else {
            Map changes = wsEdit.getChanges();
            if (changes != null) {
                for (Map.Entry edit : changes.entrySet()) {
                    String uri = (String)edit.getKey();
                    List textEdits = (List)edit.getValue();
                    LSPEclipseUtils.fillTextEdits(uri, textEdits, change);
                }
            }
        }
        return change;
    }

    private static void fillTextEdits(String uri, List<org.eclipse.lsp4j.TextEdit> textEdits, CompositeChange change) {
        IFile file = LSPEclipseUtils.getFileHandle(uri);
        if (!file.exists()) {
            throw new IllegalArgumentException("Expected existing file.");
        }
        IDocument document = null;
        IFileBuffer buffer = FileBuffers.getTextFileBufferManager().getFileBuffer(file.getFullPath(), LocationKind.IFILE);
        document = LSPEclipseUtils.getDocument((IResource)file);
        Collections.sort(textEdits, Comparator.comparing(edit -> edit.getRange().getStart(), Comparator.comparingInt(Position::getLine).thenComparingInt(Position::getCharacter).reversed()));
        for (org.eclipse.lsp4j.TextEdit textEdit : textEdits) {
            try {
                int offset = LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document);
                int length = LSPEclipseUtils.toOffset(textEdit.getRange().getEnd(), document) - offset;
                Object textChange = null;
                textChange = buffer != null ? new DocumentChange("Change in document " + uri, document) : new TextFileChange("Change in file " + file.getName(), file);
                textChange.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                textChange.setEdit((TextEdit)new ReplaceEdit(offset, length, textEdit.getNewText()));
                change.add((Change)textChange);
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    public static URI toUri(IPath absolutePath) {
        return LSPEclipseUtils.toUri(absolutePath.toFile());
    }

    public static URI toUri(IResource resource) {
        return LSPEclipseUtils.toUri(resource.getLocation());
    }

    public static URI toUri(File file) {
        try {
            return new URI("file", "", file.getAbsoluteFile().toURI().getPath(), null);
        }
        catch (URISyntaxException e) {
            LanguageServerPlugin.logError(e);
            return file.getAbsoluteFile().toURI();
        }
    }

    public static WorkspaceEdit createWorkspaceEdit(List<Object> commandArguments, IResource initialResource) {
        WorkspaceEdit res = new WorkspaceEdit();
        HashMap<String, List> changes = new HashMap<String, List>();
        res.setChanges(changes);
        Pair currentEntry = new Pair(initialResource, new ArrayList());
        commandArguments.stream().flatMap(item -> {
            if (item instanceof List) {
                return ((List)item).stream();
            }
            return Collections.singleton(item).stream();
        }).forEach(arg -> {
            if (arg instanceof String) {
                changes.put(((IResource)pair.key).getLocationURI().toString(), (List)pair.value);
                IResource resource = LSPEclipseUtils.findResourceFor((String)arg);
                if (resource != null) {
                    pair.key = resource;
                    pair.value = new ArrayList();
                }
            } else if (arg instanceof WorkspaceEdit) {
                changes.putAll(((WorkspaceEdit)arg).getChanges());
            } else if (arg instanceof org.eclipse.lsp4j.TextEdit) {
                ((List)pair.value).add((org.eclipse.lsp4j.TextEdit)arg);
            } else if (arg instanceof Map) {
                Gson gson = new Gson();
                org.eclipse.lsp4j.TextEdit edit = (org.eclipse.lsp4j.TextEdit)gson.fromJson(gson.toJson(arg), org.eclipse.lsp4j.TextEdit.class);
                if (edit != null) {
                    ((List)pair.value).add(edit);
                }
            } else if (arg instanceof JsonPrimitive) {
                JsonPrimitive json = (JsonPrimitive)arg;
                if (json.isString()) {
                    changes.put(((IResource)pair.key).getLocationURI().toString(), (List)pair.value);
                    IResource resource = LSPEclipseUtils.findResourceFor(json.getAsString());
                    if (resource != null) {
                        pair.key = resource;
                        pair.value = new ArrayList();
                    }
                }
            } else if (arg instanceof JsonArray) {
                Gson gson = new Gson();
                JsonArray array = (JsonArray)arg;
                array.forEach(elt -> {
                    org.eclipse.lsp4j.TextEdit edit = (org.eclipse.lsp4j.TextEdit)gson.fromJson(gson.toJson(elt), org.eclipse.lsp4j.TextEdit.class);
                    if (edit != null) {
                        ((List)pair.value).add(edit);
                    }
                });
            } else if (arg instanceof JsonObject) {
                Gson gson = new Gson();
                WorkspaceEdit wEdit = (WorkspaceEdit)gson.fromJson((JsonElement)((JsonObject)arg), WorkspaceEdit.class);
                Map entries = wEdit.getChanges();
                if (wEdit != null && !entries.isEmpty()) {
                    changes.putAll(entries);
                } else {
                    org.eclipse.lsp4j.TextEdit edit = (org.eclipse.lsp4j.TextEdit)gson.fromJson((JsonElement)((JsonObject)arg), org.eclipse.lsp4j.TextEdit.class);
                    if (edit != null && edit.getRange() != null) {
                        ((List)pair.value).add(edit);
                    }
                }
            }
        });
        if (!((List)currentEntry.value).isEmpty()) {
            changes.put(((IResource)currentEntry.key).getLocationURI().toString(), (List)currentEntry.value);
        }
        return res;
    }

    public static @Nullable IFile getFile(IDocument document) {
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(document);
        if (buffer == null) {
            return null;
        }
        IPath location = buffer.getLocation();
        return ResourcesPlugin.getWorkspace().getRoot().getFile(location);
    }

    @NonNull
    public static WorkspaceFolder toWorkspaceFolder(@NonNull IProject project) {
        WorkspaceFolder folder = new WorkspaceFolder();
        folder.setUri(project.getLocationURI().toString());
        folder.setName(project.getName());
        return folder;
    }

    @NonNull
    public static List<IContentType> getFileContentTypes(@NonNull IFile file) {
        ArrayList<IContentType> contentTypes = new ArrayList<IContentType>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream contents = file.getContents();){
                contentTypes.addAll(Arrays.asList(Platform.getContentTypeManager().findContentTypesFor(contents, file.getName())));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            LanguageServerPlugin.logError(e);
        }
        return contentTypes;
    }

    @Deprecated
    public static String getDocString(Either<String, MarkupContent> documentation) {
        if (documentation != null) {
            if (documentation.isLeft()) {
                return (String)documentation.getLeft();
            }
            return ((MarkupContent)documentation.getRight()).getValue();
        }
        return null;
    }

    public static Color toColor(RGB rgb) {
        return new Color((double)rgb.red / 255.0, (double)rgb.green / 255.0, (double)rgb.blue / 255.0, 1.0);
    }

    public static RGBA toRGBA(Color color) {
        return new RGBA((int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), (int)color.getAlpha());
    }

    private static final class Pair<K, V> {
        K key;
        V value;

        Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

