/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml;

import java.util.List;
import org.eclipse.jst.pagedesigner.converter.ConverterUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.SelectItemModel;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.SelectTagConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TableBasedSelectTagConverter
extends SelectTagConverter {
    private String _inputType;

    public TableBasedSelectTagConverter(Element host, String inputType) {
        super(host);
        this._inputType = inputType;
    }

    protected Element doConvertRefresh() {
        Element itemContainer;
        Element hostEle = this.getHostElement();
        Element tableEle = this.createElement("table");
        ConverterUtil.copyAttribute((Element)hostEle, (String)"styleClass", (Element)tableEle, (String)"class");
        ConverterUtil.copyAttribute((Element)hostEle, (String)"style", (Element)tableEle, (String)"style");
        ConverterUtil.copyAttribute((Element)hostEle, (String)"border", (Element)tableEle, (String)"border");
        boolean horizontal = true;
        if ("pageDirection".equalsIgnoreCase(hostEle.getAttribute("layout"))) {
            horizontal = false;
        }
        if (horizontal) {
            itemContainer = this.createElement("tr");
            tableEle.appendChild(itemContainer);
        } else {
            itemContainer = tableEle;
        }
        List selectitems = this.getSelectItems(hostEle);
        if (this.isDesignerMode() && selectitems.isEmpty()) {
            SelectItemModel item = this.getDefault(hostEle);
            selectitems.add(item);
        }
        boolean isDisabled = Boolean.TRUE.toString().equalsIgnoreCase(hostEle.getAttribute("disabled"));
        boolean isReadonly = Boolean.TRUE.toString().equalsIgnoreCase(hostEle.getAttribute("readonly"));
        int i = 0;
        int size = selectitems.size();
        while (i < size) {
            SelectItemModel item = (SelectItemModel)selectitems.get(i);
            Element labelEle = this.createElement("label");
            Element inputEle = this.createElement("input");
            inputEle.setAttribute("type", this.getInputType());
            if (isDisabled || item.isDisabled()) {
                inputEle.setAttribute("disabled", "disabled");
            }
            if (isReadonly) {
                inputEle.setAttribute("readonly", "readonly");
            }
            if (item.getId() != null) {
                labelEle.setAttribute("id", item.getId());
            }
            if (item.getValue() != null) {
                inputEle.setAttribute("value", item.getValue());
            }
            Text label = this.createText(item.getDisplayString());
            labelEle.appendChild(inputEle);
            labelEle.appendChild(label);
            if (horizontal) {
                Element td = this.createElement("td");
                td.appendChild(labelEle);
                itemContainer.appendChild(td);
            } else {
                Element tr = this.createElement("tr");
                Element td = this.createElement("td");
                tr.appendChild(td);
                td.appendChild(labelEle);
                itemContainer.appendChild(tr);
            }
            ++i;
        }
        return tableEle;
    }

    protected String getInputType() {
        return this._inputType;
    }

    public boolean needBorderDecorator() {
        return true;
    }
}

