/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Optional;
import java.util.List;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.InitializationContext;
import org.eclipse.buildship.core.ProjectContext;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.extension.InternalProjectConfigurator;
import org.eclipse.buildship.core.internal.extension.ProjectConfiguratorContribution;
import org.eclipse.buildship.core.internal.marker.GradleErrorMarker;
import org.eclipse.buildship.core.internal.workspace.GradleBuild;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

final class ProjectConfigurators {
    private final GradleBuild gradleBuild;
    private final List<InternalProjectConfigurator> contributions;

    private ProjectConfigurators(GradleBuild gradleBuild, List<InternalProjectConfigurator> contributions) {
        this.gradleBuild = gradleBuild;
        this.contributions = contributions;
    }

    void initConfigurators(IProgressMonitor monitor) {
        InitializationContext context = ProjectConfigurators.newInitializationContext(this.gradleBuild);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(this.contributions.size());
        for (InternalProjectConfigurator contribution : this.contributions) {
            try {
                contribution.init(context, (IProgressMonitor)progress.newChild(1));
            }
            catch (Exception e) {
                this.logFailureAndAddErrorMarker(contribution, e, "initialize");
            }
        }
    }

    void configureConfigurators(IProject project, IProgressMonitor monitor) {
        ProjectContext context = ProjectConfigurators.newProjectContext(project);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(this.contributions.size());
        for (InternalProjectConfigurator contribution : this.contributions) {
            try {
                contribution.configure(context, (IProgressMonitor)progress.newChild(1));
            }
            catch (Exception e) {
                this.logFailureAndAddErrorMarker(contribution, e, "configure project '" + project.getName() + "'");
            }
        }
    }

    void unconfigureConfigurators(IProject project, IProgressMonitor monitor) {
        ProjectContext context = ProjectConfigurators.newProjectContext(project);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(this.contributions.size());
        for (InternalProjectConfigurator contribution : this.contributions) {
            try {
                contribution.unconfigure(context, (IProgressMonitor)progress.newChild(1));
            }
            catch (Exception e) {
                this.logFailureAndAddErrorMarker(contribution, e, "unconfigure project '" + project.getName() + "'");
            }
        }
    }

    static ProjectConfigurators create(GradleBuild gradleBuild, List<ProjectConfiguratorContribution> configurators) {
        return new ProjectConfigurators(gradleBuild, InternalProjectConfigurator.from(configurators));
    }

    private static InitializationContext newInitializationContext(GradleBuild internalGradleBuild) {
        BuildConfiguration buildConfiguration = internalGradleBuild.getBuildConfig().toApiBuildConfiguration();
        final org.eclipse.buildship.core.GradleBuild gradleBuild = GradleCore.getWorkspace().createBuild(buildConfiguration);
        return new InitializationContext(){

            @Override
            public org.eclipse.buildship.core.GradleBuild getGradleBuild() {
                return gradleBuild;
            }
        };
    }

    private static ProjectContext newProjectContext(final IProject project) {
        return new ProjectContext(){

            @Override
            public IProject getProject() {
                return project;
            }
        };
    }

    private void logFailureAndAddErrorMarker(InternalProjectConfigurator contribution, Exception exception, String operationName) {
        String message = String.format("Project configurator '%s' failed to %s", contribution.getFullyQualifiedId(), operationName);
        Status status = new Status(2, contribution.getContributorPluginId(), message, (Throwable)exception);
        CorePlugin.getInstance().getLog().log((IStatus)status);
        try {
            IResource targetLocation = this.markerLocation();
            GradleErrorMarker.create(targetLocation, this.gradleBuild, message, exception, 0);
        }
        catch (CoreException e) {
            CorePlugin.getInstance().getLog().log(e.getStatus());
        }
    }

    private IResource markerLocation() {
        Optional<IProject> projectOrNull = CorePlugin.workspaceOperations().findProjectByLocation(this.gradleBuild.getBuildConfig().getRootProjectDirectory());
        return projectOrNull.isPresent() ? (IResource)projectOrNull.get() : ResourcesPlugin.getWorkspace().getRoot();
    }
}

