/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.progress;

import java.util.concurrent.atomic.AtomicLong;
import org.gradle.internal.impldep.javax.annotation.Nullable;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.progress.ProgressListener;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.time.Clock;
import org.gradle.util.GUtil;

public class DefaultProgressLoggerFactory
implements ProgressLoggerFactory {
    private final ProgressListener progressListener;
    private final Clock clock;
    private final AtomicLong nextId = new AtomicLong(1L);
    private final ThreadLocal<ProgressLoggerImpl> current = new ThreadLocal();
    private final CurrentBuildOperationRef currentBuildOperationRef = CurrentBuildOperationRef.instance();

    public DefaultProgressLoggerFactory(ProgressListener progressListener, Clock clock) {
        this.progressListener = progressListener;
        this.clock = clock;
    }

    public ProgressLogger newOperation(Class loggerCategory) {
        return this.newOperation(loggerCategory.getName());
    }

    public ProgressLogger newOperation(Class loggerCategory, @Nullable BuildOperationDescriptor buildOperationDescriptor) {
        return this.init(loggerCategory.getName(), null, true, buildOperationDescriptor.getId(), buildOperationDescriptor.getParentId(), buildOperationDescriptor.getOperationType());
    }

    public ProgressLogger newOperation(String loggerCategory) {
        return this.init(loggerCategory, null);
    }

    public ProgressLogger newOperation(Class loggerClass, ProgressLogger parent) {
        return this.init(loggerClass.toString(), parent);
    }

    private ProgressLogger init(String loggerCategory, @Nullable ProgressLogger parentOperation) {
        return this.init(loggerCategory, parentOperation, false, this.currentBuildOperationRef.getId(), this.currentBuildOperationRef.getParentId(), null);
    }

    private ProgressLogger init(String loggerCategory, @Nullable ProgressLogger parentOperation, boolean buildOperationStart, @Nullable OperationIdentifier buildOperationId, @Nullable OperationIdentifier parentBuildOperationId, @Nullable BuildOperationCategory buildOperationCategory) {
        if (parentOperation != null && !(parentOperation instanceof ProgressLoggerImpl)) {
            throw new IllegalArgumentException("Unexpected parent logger.");
        }
        return new ProgressLoggerImpl((ProgressLoggerImpl)parentOperation, new OperationIdentifier(this.nextId.getAndIncrement()), loggerCategory, this.progressListener, this.clock, buildOperationStart, buildOperationId, parentBuildOperationId, buildOperationCategory);
    }

    private class ProgressLoggerImpl
    implements ProgressLogger {
        private final OperationIdentifier progressOperationId;
        private final String category;
        private final ProgressListener listener;
        private final Clock clock;
        private final boolean buildOperationStart;
        @Nullable
        private final OperationIdentifier buildOperationId;
        @Nullable
        private final OperationIdentifier parentBuildOperationId;
        private final BuildOperationCategory buildOperationCategory;
        private ProgressLoggerImpl parent;
        private String description;
        private String shortDescription;
        private String loggingHeader;
        private State state = State.idle;

        ProgressLoggerImpl(ProgressLoggerImpl parent, OperationIdentifier progressOperationId, String category, ProgressListener listener, Clock clock, @Nullable boolean buildOperationStart, @Nullable OperationIdentifier buildOperationId, @Nullable OperationIdentifier parentBuildOperationId, BuildOperationCategory buildOperationCategory) {
            this.parent = parent;
            this.progressOperationId = progressOperationId;
            this.category = category;
            this.listener = listener;
            this.clock = clock;
            this.buildOperationStart = buildOperationStart;
            this.buildOperationId = buildOperationId;
            this.parentBuildOperationId = parentBuildOperationId;
            this.buildOperationCategory = buildOperationCategory;
        }

        public String toString() {
            return this.category + " - " + this.description;
        }

        public String getDescription() {
            return this.description;
        }

        public ProgressLogger setDescription(String description) {
            this.assertCanConfigure();
            this.description = description;
            return this;
        }

        public String getShortDescription() {
            return this.shortDescription;
        }

        public ProgressLogger setShortDescription(String shortDescription) {
            this.assertCanConfigure();
            this.shortDescription = shortDescription;
            return this;
        }

        public String getLoggingHeader() {
            return this.loggingHeader;
        }

        public ProgressLogger setLoggingHeader(String loggingHeader) {
            this.assertCanConfigure();
            this.loggingHeader = loggingHeader;
            return this;
        }

        public ProgressLogger start(String description, String shortDescription) {
            this.start(description, shortDescription, 0);
            return this;
        }

        public ProgressLogger start(String description, String shortDescription, int totalProgress) {
            this.setDescription(description);
            this.setShortDescription(shortDescription);
            this.started(null, totalProgress);
            return this;
        }

        public void started() {
            this.started(null);
        }

        public void started(String status) {
            this.started(status, 0);
        }

        public void started(String status, int totalProgress) {
            if (!GUtil.isTrue(this.description)) {
                throw new IllegalStateException("A description must be specified before this operation is started.");
            }
            this.assertNotStarted();
            this.state = State.started;
            if (this.parent == null) {
                this.parent = (ProgressLoggerImpl)DefaultProgressLoggerFactory.this.current.get();
            } else {
                this.parent.assertRunning();
            }
            DefaultProgressLoggerFactory.this.current.set(this);
            this.listener.started(new ProgressStartEvent(this.progressOperationId, this.parent == null ? null : this.parent.progressOperationId, this.clock.getCurrentTime(), this.category, this.description, this.shortDescription, this.loggingHeader, this.ensureNotNull(status), totalProgress, this.buildOperationStart, this.buildOperationId, this.parentBuildOperationId, this.buildOperationCategory));
        }

        public void progress(String status) {
            this.progress(status, false);
        }

        public void progress(String status, boolean failing) {
            this.assertRunning();
            this.listener.progress(new ProgressEvent(this.progressOperationId, this.ensureNotNull(status), failing));
        }

        public void completed() {
            this.completed(null, false);
        }

        public void completed(String status, boolean failed) {
            this.assertRunning();
            this.state = State.completed;
            DefaultProgressLoggerFactory.this.current.set(this.parent);
            this.listener.completed(new ProgressCompleteEvent(this.progressOperationId, this.clock.getCurrentTime(), this.ensureNotNull(status), failed));
        }

        private String ensureNotNull(String status) {
            return status == null ? "" : status;
        }

        private void assertNotStarted() {
            if (this.state == State.started) {
                throw new IllegalStateException(String.format("This operation (%s) has already been started.", this));
            }
            if (this.state == State.completed) {
                throw new IllegalStateException(String.format("This operation (%s) has already completed.", this));
            }
        }

        private void assertRunning() {
            if (this.state == State.idle) {
                throw new IllegalStateException(String.format("This operation (%s) has not been started.", this));
            }
            if (this.state == State.completed) {
                throw new IllegalStateException(String.format("This operation (%s) has already been completed.", this));
            }
        }

        private void assertCanConfigure() {
            if (this.state != State.idle) {
                throw new IllegalStateException(String.format("Cannot configure this operation (%s) once it has started.", this));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        idle,
        started,
        completed;

    }
}

