/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.chain;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.index.chain.MonotoneChainOverlapAction;
import com.vividsolutions.jts.index.chain.MonotoneChainSelectAction;

public class MonotoneChain {
    private Coordinate[] pts;
    private int start;
    private int end;
    private Envelope env = null;
    private Object context = null;
    private int id;

    public MonotoneChain(Coordinate[] pts, int start, int end, Object context) {
        this.pts = pts;
        this.start = start;
        this.end = end;
        this.context = context;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public Object getContext() {
        return this.context;
    }

    public Envelope getEnvelope() {
        if (this.env == null) {
            Coordinate p0 = this.pts[this.start];
            Coordinate p1 = this.pts[this.end];
            this.env = new Envelope(p0, p1);
        }
        return this.env;
    }

    public int getStartIndex() {
        return this.start;
    }

    public int getEndIndex() {
        return this.end;
    }

    public void getLineSegment(int index, LineSegment ls) {
        ls.p0 = this.pts[index];
        ls.p1 = this.pts[index + 1];
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coord = new Coordinate[this.end - this.start + 1];
        int index = 0;
        for (int i = this.start; i <= this.end; ++i) {
            coord[index++] = this.pts[i];
        }
        return coord;
    }

    public void select(Envelope searchEnv, MonotoneChainSelectAction mcs) {
        this.computeSelect(searchEnv, this.start, this.end, mcs);
    }

    private void computeSelect(Envelope searchEnv, int start0, int end0, MonotoneChainSelectAction mcs) {
        Coordinate p0 = this.pts[start0];
        Coordinate p1 = this.pts[end0];
        mcs.tempEnv1.init(p0, p1);
        if (end0 - start0 == 1) {
            mcs.select(this, start0);
            return;
        }
        if (!searchEnv.intersects(mcs.tempEnv1)) {
            return;
        }
        int mid = (start0 + end0) / 2;
        if (start0 < mid) {
            this.computeSelect(searchEnv, start0, mid, mcs);
        }
        if (mid < end0) {
            this.computeSelect(searchEnv, mid, end0, mcs);
        }
    }

    public void computeOverlaps(MonotoneChain mc, MonotoneChainOverlapAction mco) {
        this.computeOverlaps(this.start, this.end, mc, mc.start, mc.end, mco);
    }

    private void computeOverlaps(int start0, int end0, MonotoneChain mc, int start1, int end1, MonotoneChainOverlapAction mco) {
        Coordinate p00 = this.pts[start0];
        Coordinate p01 = this.pts[end0];
        Coordinate p10 = mc.pts[start1];
        Coordinate p11 = mc.pts[end1];
        if (end0 - start0 == 1 && end1 - start1 == 1) {
            mco.overlap(this, start0, mc, start1);
            return;
        }
        mco.tempEnv1.init(p00, p01);
        mco.tempEnv2.init(p10, p11);
        if (!mco.tempEnv1.intersects(mco.tempEnv2)) {
            return;
        }
        int mid0 = (start0 + end0) / 2;
        int mid1 = (start1 + end1) / 2;
        if (start0 < mid0) {
            if (start1 < mid1) {
                this.computeOverlaps(start0, mid0, mc, start1, mid1, mco);
            }
            if (mid1 < end1) {
                this.computeOverlaps(start0, mid0, mc, mid1, end1, mco);
            }
        }
        if (mid0 < end0) {
            if (start1 < mid1) {
                this.computeOverlaps(mid0, end0, mc, start1, mid1, mco);
            }
            if (mid1 < end1) {
                this.computeOverlaps(mid0, end0, mc, mid1, end1, mco);
            }
        }
    }
}

