/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.vertica.model.VerticaProjection;
import org.jkiss.dbeaver.ext.vertica.model.VerticaProjectionColumn;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class VerticaProjectionColumnManager
extends SQLTableColumnManager<VerticaProjectionColumn, VerticaProjection> {
    public boolean canCreateObject(VerticaProjection parent) {
        return false;
    }

    public boolean canDeleteObject(VerticaProjectionColumn object) {
        return false;
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(VerticaProjectionColumn column, Map<String, Object> options) {
        return new SQLTableColumnManager.ColumnModifier[0];
    }

    protected VerticaProjectionColumn createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, VerticaProjection parent, Object copyFrom) throws DBException {
        return null;
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        VerticaProjectionColumn column = (VerticaProjectionColumn)command.getObject();
        String prefix = "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " ALTER COLUMN " + DBUtils.getQuotedIdentifier((DBSObject)column) + " ";
        String typeClause = column.getFullTypeName();
        if (command.getProperty((Object)"typeName") != null || command.getProperty((Object)"maxLength") != null || command.getProperty((Object)"precision") != null || command.getProperty((Object)"scale") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column type", String.valueOf(prefix) + "SET DATA TYPE " + typeClause));
        }
        if (command.getProperty((Object)"required") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column nullability", String.valueOf(prefix) + (column.isRequired() ? "SET" : "DROP") + " NOT NULL"));
        }
        if (command.getProperty((Object)"defaultValue") != null) {
            if (CommonUtils.isEmpty((String)column.getDefaultValue())) {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Drop column default", String.valueOf(prefix) + "DROP DEFAULT"));
            } else {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column default", String.valueOf(prefix) + "SET DEFAULT " + column.getDefaultValue()));
            }
        }
        if (command.getProperty((Object)"description") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column comment", "COMMENT ON COLUMN " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + "." + DBUtils.getQuotedIdentifier((DBSObject)column) + " IS " + SQLUtils.quoteString((DBSObject)column, (String)CommonUtils.notEmpty((String)column.getDescription()))));
        }
    }

    public DBSObjectCache<VerticaProjection, VerticaProjectionColumn> getObjectsCache(VerticaProjectionColumn object) {
        return null;
    }
}

