/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.content;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.editors.content.ContentEditor;
import org.jkiss.dbeaver.ui.editors.content.ContentEditorInput;

public class ContentEditorContributor
extends MultiPageEditorActionBarContributor {
    private final BasicTextEditorActionContributor textContributor;
    private ContentEditor activeEditor;
    private final IAction saveAction = new FileExportAction();
    private final IAction loadAction = new FileImportAction();
    private final IAction infoAction = new InfoAction();
    private Combo encodingCombo;

    public ContentEditorContributor() {
        this.textContributor = new BasicTextEditorActionContributor();
    }

    ContentEditor getEditor() {
        return this.activeEditor;
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        this.textContributor.init(bars, page);
    }

    public void init(IActionBars bars) {
        super.init(bars);
        this.textContributor.init(bars);
    }

    public void dispose() {
        this.textContributor.dispose();
        super.dispose();
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditor = (ContentEditor)part;
        if (this.activeEditor != null) {
            if (this.encodingCombo != null && !this.encodingCombo.isDisposed()) {
                String curCharset = this.activeEditor.getEditorInput().getEncoding();
                int charsetCount = this.encodingCombo.getItemCount();
                int i = 0;
                while (i < charsetCount) {
                    if (this.encodingCombo.getItem(i).equals(curCharset)) {
                        this.encodingCombo.select(i);
                        break;
                    }
                    ++i;
                }
            }
            this.loadAction.setEnabled(!this.activeEditor.getEditorInput().isReadOnly());
        }
    }

    public void setActivePage(IEditorPart activeEditor) {
        this.textContributor.setActiveEditor(activeEditor);
    }

    public void contributeToMenu(IMenuManager manager) {
        super.contributeToMenu(manager);
        this.textContributor.contributeToMenu(manager);
        MenuManager menu = new MenuManager("L&OB Editor");
        manager.prependToGroup("additions", (IContributionItem)menu);
        menu.add(this.saveAction);
        menu.add(this.loadAction);
        menu.add((IContributionItem)new Separator());
        menu.add(this.infoAction);
        menu.add((IContributionItem)new Separator());
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
        this.textContributor.contributeToStatusLine(statusLineManager);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        super.contributeToToolBar(manager);
        this.textContributor.contributeToToolBar(manager);
        manager.add(this.saveAction);
        manager.add(this.loadAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.infoAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new ControlContribution("Encoding"){

            protected Control createControl(Composite parent) {
                String curCharset = null;
                if (ContentEditorContributor.this.getEditor() != null) {
                    curCharset = ContentEditorContributor.this.getEditor().getEditorInput().getEncoding();
                }
                ContentEditorContributor.this.encodingCombo = UIUtils.createEncodingCombo((Composite)parent, curCharset);
                ContentEditorContributor.this.encodingCombo.setToolTipText("Content Encoding");
                ContentEditorContributor.this.encodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ContentEditor contentEditor = ContentEditorContributor.this.getEditor();
                        if (contentEditor != null) {
                            ContentEditorInput contentEditorInput = contentEditor.getEditorInput();
                            Combo combo = (Combo)e.widget;
                            String charset = combo.getItem(combo.getSelectionIndex());
                            contentEditorInput.setEncoding(charset);
                        }
                    }
                });
                return ContentEditorContributor.this.encodingCombo;
            }

            public void dispose() {
                ContentEditorContributor.this.encodingCombo = null;
                super.dispose();
            }
        });
    }

    private class FileExportAction
    extends SimpleAction {
        FileExportAction() {
            super("org.eclipse.ui.file.export", "Export", "Save to File", UIIcon.SAVE_AS);
        }

        @Override
        public void run() {
            ContentEditorContributor.this.getEditor().doSaveAs();
        }
    }

    private class FileImportAction
    extends SimpleAction {
        FileImportAction() {
            super("org.eclipse.ui.file.import", "Import", "Load from File", UIIcon.LOAD);
        }

        @Override
        public void run() {
            final ContentEditor editor = ContentEditorContributor.this.getEditor();
            if (editor == null) {
                return;
            }
            Shell shell = editor.getSite().getShell();
            final File loadFile = DialogUtils.openFile((Shell)shell);
            if (loadFile == null) {
                return;
            }
            try {
                editor.getSite().getWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            editor.getEditorInput().loadFromExternalFile(loadFile, monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
                IValueController valueController = editor.getValueController();
                if (valueController != null) {
                    valueController.updateValue(editor.getValue(), true);
                }
                editor.setDirty(true);
                editor.fireContentChanged();
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Can't load content", "Can't load content from file '" + loadFile.getAbsolutePath() + "'", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private class InfoAction
    extends SimpleAction {
        InfoAction() {
            super("org.jkiss.dbeaver.lob.actions.info", "Info", "Show column information", DBIcon.TREE_INFO);
        }

        @Override
        public void run() {
            ContentEditorContributor.this.getEditor().toggleInfoBar();
        }
    }

    public abstract class SimpleAction
    extends Action {
        SimpleAction(String id, String text, String toolTip, DBIcon icon) {
            super(text, DBeaverIcons.getImageDescriptor((DBPImage)icon));
            this.setId(id);
            this.setToolTipText(toolTip);
        }

        public abstract void run();
    }
}

