/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.help;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.help.AbstractHelpUI;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class GitHubWikiHelpUI
extends AbstractHelpUI {
    private static final Log log = Log.getLog(GitHubWikiHelpUI.class);
    public static final String GITHUB_HELP_ROOT = "https://github.com/dbeaver/dbeaver/wiki/";

    public void displayHelp() {
        this.showHelpPage(GITHUB_HELP_ROOT);
    }

    public void displayContext(IContext context, int x, int y) {
        try {
            IHelpResource[] relatedTopics = context.getRelatedTopics();
            if (relatedTopics == null || relatedTopics.length == 0) {
                return;
            }
            IHelpResource relatedTopic = relatedTopics[0];
            String topicRef = relatedTopic.getHref();
            while (topicRef.startsWith("/")) {
                topicRef = topicRef.substring(1);
            }
            int divPos = topicRef.indexOf(47);
            if (divPos != -1) {
                topicRef = topicRef.substring(divPos + 1);
            }
            this.showHelpPage(GITHUB_HELP_ROOT + topicRef);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void showHelpPage(String fileURL) {
        try {
            this.showHelpPage(new URL(fileURL));
        }
        catch (MalformedURLException e) {
            log.error((Object)"Bad help page URL", (Throwable)e);
        }
    }

    private void showHelpPage(URL fileURL) {
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            support.getExternalBrowser().openURL(fileURL);
        }
        catch (PartInitException e) {
            DBWorkbench.getPlatformUI().showError("Help system", "Can't open help in external browser", (Throwable)e);
        }
    }

    public void displayHelpResource(String href) {
        this.showHelpPage(href);
    }

    public boolean isContextHelpDisplayed() {
        return false;
    }
}

