/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.import_config.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportData;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ConfigImportWizardPage
extends WizardPage {
    private Table connectionTable;
    private ImportData importData;

    protected ConfigImportWizardPage(String pageName) {
        super(pageName);
    }

    public ImportData getImportData() {
        return this.importData;
    }

    public void createControl(Composite parent) {
        Composite placeholder = new Composite(parent, 0);
        placeholder.setLayout((Layout)new GridLayout(1, true));
        UIUtils.createControlLabel((Composite)placeholder, (String)"Connections");
        this.connectionTable = new Table(placeholder, 2082);
        this.connectionTable.setHeaderVisible(true);
        this.connectionTable.setLinesVisible(true);
        this.connectionTable.setLayoutData((Object)new GridData(1808));
        UIUtils.createTableColumn((Table)this.connectionTable, (int)16384, (String)"Name");
        UIUtils.createTableColumn((Table)this.connectionTable, (int)16384, (String)"Driver");
        UIUtils.createTableColumn((Table)this.connectionTable, (int)16384, (String)"URL/Host");
        UIUtils.packColumns((Table)this.connectionTable);
        this.connectionTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                ImportConnectionInfo connectionInfo = (ImportConnectionInfo)item.getData();
                connectionInfo.setChecked(item.getChecked());
                ConfigImportWizardPage.this.getContainer().updateButtons();
            }
        });
        this.setControl((Control)placeholder);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.connectionTable.removeAll();
            this.importData = new ImportData();
            boolean loaded = false;
            try {
                this.loadConnections(this.importData);
                loaded = true;
            }
            catch (DBException e) {
                this.setMessage(e.getMessage(), 3);
            }
            this.getContainer().updateButtons();
            if (loaded) {
                if (CommonUtils.isEmpty(this.importData.getConnections())) {
                    this.setMessage("Connection list is empty", 2);
                } else {
                    for (ImportConnectionInfo connectionInfo : this.importData.getConnections()) {
                        TableItem item = new TableItem(this.connectionTable, 0);
                        item.setImage(0, DBeaverIcons.getImage((DBPImage)DBIcon.TREE_DATABASE));
                        item.setText(0, connectionInfo.getAlias());
                        item.setText(1, connectionInfo.getDriverInfo().getName());
                        String url = connectionInfo.getUrl();
                        if (CommonUtils.isEmpty((String)url)) {
                            url = connectionInfo.getHost();
                        }
                        item.setText(2, url);
                        item.setData((Object)connectionInfo);
                    }
                }
            }
            UIUtils.packColumns((Table)this.connectionTable);
        }
        super.setVisible(visible);
    }

    protected abstract void loadConnections(ImportData var1) throws DBException;

    public boolean isPageComplete() {
        TableItem[] tableItemArray = this.connectionTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

