/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ContainerEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.jkiss.dbeaver.ext.erd.command.NoteCreateCommand;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDNote;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.utils.CommonUtils;

public class DiagramContainerEditPolicy
extends ContainerEditPolicy {
    protected Command getAddCommand(GroupRequest request) {
        EditPart host = this.getTargetEditPart((Request)request);
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        DiagramPart diagramPart = (DiagramPart)this.getHost();
        Point location = request.getLocation();
        diagramPart.getFigure().translateToRelative((Translatable)location);
        Object newObject = request.getNewObject();
        if (newObject instanceof ERDNote) {
            return new NoteCreateCommand(diagramPart, (ERDNote)newObject, location);
        }
        List<ERDEntity> entities = null;
        if (newObject instanceof ERDEntity) {
            entities = Collections.singletonList((ERDEntity)newObject);
        } else if (newObject instanceof Collection) {
            entities = new ArrayList<ERDEntity>((Collection)newObject);
        }
        if (CommonUtils.isEmpty(entities)) {
            return null;
        }
        Command entityAddCommand = diagramPart.createEntityAddCommand(entities, location);
        if (!entityAddCommand.canExecute()) {
            return null;
        }
        return entityAddCommand;
    }

    public EditPart getTargetEditPart(Request request) {
        if ("create child".equals(request.getType())) {
            return this.getHost();
        }
        if ("add children".equals(request.getType())) {
            return this.getHost();
        }
        if ("move".equals(request.getType())) {
            return this.getHost();
        }
        return super.getTargetEditPart(request);
    }
}

