/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.dbeaver.ui.controls.StyledTextUtils;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;

public class SQLEditorOutputViewer
extends Composite {
    private final StyledText text;
    private PrintWriter writer;
    private boolean hasNewOutput;

    public SQLEditorOutputViewer(IWorkbenchPartSite site, Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.text = new StyledText((Composite)this, 778);
        this.text.setMargins(5, 5, 5, 5);
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)site, (Control)this.text);
        Writer out = new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                SQLEditorOutputViewer.this.text.append(String.valueOf(cbuf, off, len));
                if (len > 0) {
                    SQLEditorOutputViewer.this.hasNewOutput = true;
                }
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
        this.writer = new PrintWriter(out, true);
        this.createContextMenu(site);
        this.refreshStyles();
    }

    void refreshStyles() {
        ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        Font outputFont = currentTheme.getFontRegistry().get("org.jkiss.dbeaver.sql.editor.font.output");
        if (outputFont != null) {
            this.text.setFont(outputFont);
        }
        this.text.setForeground(currentTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.editor.color.text.foreground"));
        this.text.setBackground(currentTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.editor.color.text.background"));
    }

    void print(String out) {
        this.text.append(out);
    }

    void println(String out) {
        this.print(String.valueOf(out) + "\n");
    }

    void scrollToEnd() {
        this.text.setTopIndex(this.text.getLineCount() - 1);
    }

    public PrintWriter getOutputWriter() {
        return this.writer;
    }

    public boolean isHasNewOutput() {
        return this.hasNewOutput;
    }

    void resetNewOutput() {
        this.hasNewOutput = false;
    }

    private void createContextMenu(IWorkbenchPartSite site) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(manager -> {
            StyledTextUtils.fillDefaultStyledTextContextMenu((IMenuManager)manager, (StyledText)this.text);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action("Clear"){

                public void run() {
                    SQLEditorOutputViewer.this.clearOutput();
                }
            });
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.text.setMenu(menuMgr.createContextMenu((Control)this.text));
    }

    void clearOutput() {
        this.text.setText("");
    }
}

