/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.views;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorAbstractUI;
import org.jkiss.utils.CommonUtils;

public class MySQLSSLConfigurator
extends SSLConfiguratorAbstractUI {
    private Button requireSSQL;
    private Button veryServerCert;
    private Button allowPublicKeyRetrieval;
    private TextWithOpen clientCertText;
    private TextWithOpen clientKeyText;
    private TextWithOpen clientCAText;
    private Text cipherSuitesText;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        Group certGroup = UIUtils.createControlGroup((Composite)composite, (String)"Certificates", (int)2, (int)768, (int)-1);
        UIUtils.createControlLabel((Composite)certGroup, (String)"CA certificate");
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.clientCAText = new TextWithOpenFile((Composite)certGroup, "CA Certificate", new String[]{"*.*", "*.crt", "*.cert", "*.pem", "*"});
        this.clientCAText.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)certGroup, (String)"SSL certificate");
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.clientCertText = new TextWithOpenFile((Composite)certGroup, "SSL Certificate", new String[]{"*.*", "*.cert", "*.pem", "*"});
        this.clientCertText.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)certGroup, (String)"SSL certificate key");
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.clientKeyText = new TextWithOpenFile((Composite)certGroup, "SSL Certificate", new String[]{"*.*", "*.cert", "*.pem", "*"});
        this.clientKeyText.setLayoutData((Object)new GridData(768));
        this.cipherSuitesText = UIUtils.createLabelText((Composite)certGroup, (String)"Cipher suites (optional)", (String)"");
        this.cipherSuitesText.setToolTipText("Overrides the cipher suites enabled for use on the underlying SSL sockets.\nThis may be required when using external JSSE providers or to specify cipher suites compatible with both MySQL server and used JVM.");
        Group advGroup = UIUtils.createControlGroup((Composite)composite, (String)"Advanced", (int)2, (int)768, (int)-1);
        this.requireSSQL = UIUtils.createLabelCheckbox((Composite)advGroup, (String)"Require SSL", (String)"Require server support of SSL connection.", (boolean)false);
        this.veryServerCert = UIUtils.createLabelCheckbox((Composite)advGroup, (String)"Verify server certificate", (String)"Should the driver verify the server's certificate?\nWhen using this feature, the explicit certificate parameters should be specified, rather than system properties.", (boolean)true);
        this.allowPublicKeyRetrieval = UIUtils.createLabelCheckbox((Composite)advGroup, (String)"Allow public key retrieval", (String)"Allows special handshake roundtrip to get server RSA public key directly from server.", (boolean)false);
    }

    public void loadSettings(DBWHandlerConfiguration configuration) {
        this.requireSSQL.setSelection(CommonUtils.getBoolean((String)((String)configuration.getProperties().get("ssl.require")), (boolean)false));
        this.veryServerCert.setSelection(CommonUtils.getBoolean((String)((String)configuration.getProperties().get("ssl.verify.server")), (boolean)true));
        this.allowPublicKeyRetrieval.setSelection(CommonUtils.getBoolean((String)((String)configuration.getProperties().get("ssl.public.key.retrieve")), (boolean)false));
        this.clientCertText.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("ssl.client.cert"))));
        this.clientKeyText.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("ssl.client.key"))));
        this.clientCAText.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("ssl.ca.cert"))));
        this.cipherSuitesText.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("ssl.cipher.suites"))));
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        configuration.getProperties().put("ssl.require", String.valueOf(this.requireSSQL.getSelection()));
        configuration.getProperties().put("ssl.verify.server", String.valueOf(this.veryServerCert.getSelection()));
        configuration.getProperties().put("ssl.public.key.retrieve", String.valueOf(this.allowPublicKeyRetrieval.getSelection()));
        configuration.getProperties().put("ssl.client.cert", this.clientCertText.getText());
        configuration.getProperties().put("ssl.client.key", this.clientKeyText.getText());
        configuration.getProperties().put("ssl.ca.cert", this.clientCAText.getText());
        configuration.getProperties().put("ssl.cipher.suites", this.cipherSuitesText.getText());
    }
}

