/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ISaveablePart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAAuthInfo;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.ConnectJob;
import org.jkiss.dbeaver.runtime.jobs.DisconnectJob;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.entity.handlers.SaveChangesHandler;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;

public class DataSourceHandler {
    private static final Log log = Log.getLog(DataSourceHandler.class);
    public static final int END_TRANSACTION_WAIT_TIME = 3000;

    public static void connectToDataSource(@Nullable DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSourceContainer, final @Nullable DBRProgressListener onFinish) {
        if (dataSourceContainer instanceof DataSourceDescriptor && !dataSourceContainer.isConnected()) {
            final DataSourceDescriptor dataSourceDescriptor = (DataSourceDescriptor)dataSourceContainer;
            if (!ArrayUtils.isEmpty((Object[])Job.getJobManager().find((Object)dataSourceDescriptor))) {
                return;
            }
            final ConnectJob connectJob = new ConnectJob((DBPDataSourceContainer)dataSourceDescriptor);
            JobChangeAdapter jobChangeAdapter = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    IStatus result = connectJob.getConnectStatus();
                    if (result.isOK()) {
                        dataSourceDescriptor.isSavePassword();
                    }
                    if (onFinish != null) {
                        onFinish.onTaskFinished(result);
                    } else if (!result.isOK()) {
                        UIUtils.asyncExec(() -> {
                            DBPPlatformUI.UserResponse userResponse = DBWorkbench.getPlatformUI().showError(connectJob.getName(), null, result);
                        });
                    }
                }
            };
            if (monitor != null) {
                connectJob.runSync(monitor);
                jobChangeAdapter.done(new IJobChangeEvent(){

                    public long getDelay() {
                        return 0L;
                    }

                    public Job getJob() {
                        return connectJob;
                    }

                    public IStatus getResult() {
                        return connectJob.getConnectStatus();
                    }

                    public IStatus getJobGroupResult() {
                        return null;
                    }
                });
            } else {
                connectJob.addJobChangeListener((IJobChangeListener)jobChangeAdapter);
                UIUtils.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        connectJob.schedule();
                    }
                });
            }
        }
    }

    public static void updateDataSourceObject(DataSourceDescriptor dataSourceDescriptor) {
        dataSourceDescriptor.getRegistry().notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)dataSourceDescriptor, false));
    }

    public static boolean askForPassword(@NotNull DataSourceDescriptor dataSourceContainer, @Nullable DBWHandlerConfiguration networkHandler, boolean passwordOnly) {
        String password;
        String user;
        final String prompt = networkHandler != null ? NLS.bind((String)CoreMessages.dialog_connection_auth_title_for_handler, (Object)networkHandler.getTitle()) : "'" + dataSourceContainer.getName() + CoreMessages.dialog_connection_auth_title;
        DBAAuthInfo authInfo = (DBAAuthInfo)new UITask<DBAAuthInfo>(user = networkHandler != null ? networkHandler.getUserName() : dataSourceContainer.getConnectionConfiguration().getUserName(), password = networkHandler != null ? networkHandler.getPassword() : dataSourceContainer.getConnectionConfiguration().getUserPassword(), passwordOnly, dataSourceContainer){
            private final /* synthetic */ String val$user;
            private final /* synthetic */ String val$password;
            private final /* synthetic */ boolean val$passwordOnly;
            private final /* synthetic */ DataSourceDescriptor val$dataSourceContainer;
            {
                this.val$user = string2;
                this.val$password = string3;
                this.val$passwordOnly = bl;
                this.val$dataSourceContainer = dataSourceDescriptor;
            }

            protected DBAAuthInfo runTask() {
                return DBWorkbench.getPlatformUI().promptUserCredentials(prompt, this.val$user, this.val$password, this.val$passwordOnly, !this.val$dataSourceContainer.isTemporary());
            }
        }.execute();
        if (authInfo == null) {
            return false;
        }
        if (networkHandler != null) {
            if (!passwordOnly) {
                networkHandler.setUserName(authInfo.getUserName());
            }
            networkHandler.setPassword(authInfo.getUserPassword());
            networkHandler.setSavePassword(authInfo.isSavePassword());
        } else {
            if (!passwordOnly) {
                dataSourceContainer.getConnectionConfiguration().setUserName(authInfo.getUserName());
            }
            dataSourceContainer.getConnectionConfiguration().setUserPassword(authInfo.getUserPassword());
            dataSourceContainer.setSavePassword(authInfo.isSavePassword());
        }
        if (authInfo.isSavePassword()) {
            dataSourceContainer.getRegistry().updateDataSource((DBPDataSourceContainer)dataSourceContainer);
        }
        return true;
    }

    public static void disconnectDataSource(DBPDataSourceContainer dataSourceContainer, final @Nullable Runnable onFinish) {
        for (DBPDataSourceTask user : dataSourceContainer.getTasks()) {
            if (!(user instanceof ISaveablePart) || SaveChangesHandler.validateAndSave((DBRProgressMonitor)new VoidProgressMonitor(), (ISaveablePart)((ISaveablePart)user))) continue;
            return;
        }
        if (!DataSourceHandler.checkAndCloseActiveTransaction(dataSourceContainer)) {
            return;
        }
        if (dataSourceContainer instanceof DataSourceDescriptor && dataSourceContainer.isConnected()) {
            DataSourceDescriptor dataSourceDescriptor = (DataSourceDescriptor)dataSourceContainer;
            if (!ArrayUtils.isEmpty((Object[])Job.getJobManager().find((Object)dataSourceDescriptor))) {
                return;
            }
            final DisconnectJob disconnectJob = new DisconnectJob((DBPDataSourceContainer)dataSourceDescriptor);
            disconnectJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    IStatus result = disconnectJob.getConnectStatus();
                    if (onFinish != null) {
                        onFinish.run();
                    } else if (!result.isOK()) {
                        DBWorkbench.getPlatformUI().showError(disconnectJob.getName(), null, result);
                    }
                }
            });
            UIUtils.asyncExec(() -> ((DisconnectJob)disconnectJob).schedule());
        }
    }

    public static void reconnectDataSource(final DBRProgressMonitor monitor, final DBPDataSourceContainer dataSourceContainer) {
        DataSourceHandler.disconnectDataSource(dataSourceContainer, new Runnable(){

            @Override
            public void run() {
                DataSourceHandler.connectToDataSource(monitor, dataSourceContainer, null);
            }
        });
    }

    public static boolean checkAndCloseActiveTransaction(DBPDataSourceContainer container) {
        DBPDataSource dataSource = container.getDataSource();
        if (dataSource == null) {
            return true;
        }
        for (DBSInstance instance : dataSource.getAvailableInstances()) {
            if (DataSourceHandler.checkAndCloseActiveTransaction(instance.getAllContexts())) continue;
            return false;
        }
        return true;
    }

    public static boolean checkAndCloseActiveTransaction(DBCExecutionContext[] contexts) {
        if (contexts == null) {
            return true;
        }
        Boolean commitTxn = null;
        DBCExecutionContext[] dBCExecutionContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                DBCExecutionContext context;
                block10: {
                    context = dBCExecutionContextArray[n2];
                    if (!QMUtils.isTransactionActive((DBCExecutionContext)context)) break block9;
                    if (commitTxn != null) break block10;
                    TransactionCloseConfirmer closeConfirmer = new TransactionCloseConfirmer(context.getDataSource().getContainer().getName());
                    UIUtils.syncExec((Runnable)closeConfirmer);
                    switch (closeConfirmer.result) {
                        case 2: {
                            commitTxn = true;
                            break;
                        }
                        case 3: {
                            commitTxn = false;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                try {
                    boolean commit = commitTxn;
                    UIUtils.runInProgressService(monitor -> DataSourceHandler.closeActiveTransaction(monitor, context, commit));
                }
                catch (Throwable e) {
                    log.warn((Object)"Can't rollback active transaction before disconnect", e);
                }
            }
            ++n2;
        }
        return true;
    }

    public static void closeActiveTransaction(DBRProgressMonitor monitor, DBCExecutionContext context, boolean commitTxn) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "End active transaction");){
            monitor.subTask("End active transaction");
            EndTransactionTask task = new EndTransactionTask(session, commitTxn);
            RuntimeUtils.runTask((DBRRunnableWithProgress)task, (String)"Close active transactions", (long)3000L);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class EndTransactionTask
    implements DBRRunnableWithProgress {
        private final DBCSession session;
        private final boolean commit;

        private EndTransactionTask(DBCSession session, boolean commit) {
            this.session = session;
            this.commit = commit;
        }

        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.session.getExecutionContext());
            if (txnManager != null) {
                try {
                    if (this.commit) {
                        txnManager.commit(this.session);
                    } else {
                        txnManager.rollback(this.session, null);
                    }
                }
                catch (DBCException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
    }

    private static class TransactionCloseConfirmer
    implements Runnable {
        final String name;
        int result = 3;

        private TransactionCloseConfirmer(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            this.result = ConfirmationDialog.showConfirmDialog((ResourceBundle)DBeaverActivator.getCoreResourceBundle(), null, (String)"disconnect_txn", (int)6, (Object[])new Object[]{this.name});
        }
    }
}

