Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _atom = require('atom');

var _imageEditorView = require('./image-editor-view');

var _imageEditorView2 = _interopRequireDefault(_imageEditorView);

// Editor model for an image file

var ImageEditor = (function () {
  _createClass(ImageEditor, null, [{
    key: 'deserialize',
    value: function deserialize(_ref) {
      var filePath = _ref.filePath;

      if (_fsPlus2['default'].isFileSync(filePath)) {
        return new ImageEditor(filePath);
      } else {
        console.warn('Could not deserialize image editor for path \'' + filePath + '\' because that file no longer exists');
      }
    }
  }]);

  function ImageEditor(filePath) {
    var _this = this;

    _classCallCheck(this, ImageEditor);

    this.file = new _atom.File(filePath);
    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(this.file.onDidDelete(function () {
      var pane = atom.workspace.paneForURI(filePath);
      try {
        pane.destroyItem(pane.itemForURI(filePath));
      } catch (e) {
        console.warn('Could not destroy pane after external file was deleted: ' + e);
      }
      _this.subscriptions.dispose();
    }));
    this.emitter = new _atom.Emitter();
  }

  _createClass(ImageEditor, [{
    key: 'copy',
    value: function copy() {
      return new ImageEditor(this.getPath());
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return { filePath: this.getPath(), deserializer: this.constructor.name };
    }
  }, {
    key: 'terminatePendingState',
    value: function terminatePendingState() {
      if (this.isEqual(atom.workspace.getCenter().getActivePane().getPendingItem())) {
        this.emitter.emit('did-terminate-pending-state');
      }
    }
  }, {
    key: 'onDidTerminatePendingState',
    value: function onDidTerminatePendingState(callback) {
      return this.emitter.on('did-terminate-pending-state', callback);
    }

    // Register a callback for when the image file changes
  }, {
    key: 'onDidChange',
    value: function onDidChange(callback) {
      var changeSubscription = this.file.onDidChange(callback);
      this.subscriptions.add(changeSubscription);
      return changeSubscription;
    }

    // Register a callback for whne the image's title changes
  }, {
    key: 'onDidChangeTitle',
    value: function onDidChangeTitle(callback) {
      var renameSubscription = this.file.onDidRename(callback);
      this.subscriptions.add(renameSubscription);
      return renameSubscription;
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      if (this.view) {
        this.view.destroy();
      }
      this.emitter.emit('did-destroy');
    }
  }, {
    key: 'getAllowedLocations',
    value: function getAllowedLocations() {
      return ['center'];
    }

    // Retrieves the filename of the open file.
    //
    // This is `'untitled'` if the file is new and not saved to the disk.
    //
    // Returns a {String}.
  }, {
    key: 'getTitle',
    value: function getTitle() {
      var filePath = this.getPath();
      if (filePath) {
        return _path2['default'].basename(filePath);
      } else {
        return 'untitled';
      }
    }

    // Retrieves the absolute path to the image.
    //
    // Returns a {String} path.
  }, {
    key: 'getPath',
    value: function getPath() {
      return this.file.getPath();
    }

    // Retrieves the URI of the image.
    //
    // Returns a {String}.
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.getPath();
    }

    // Retrieves the encoded URI of the image.
    //
    // Returns a {String}.
  }, {
    key: 'getEncodedURI',
    value: function getEncodedURI() {
      return 'file://' + encodeURI(this.getPath().replace(/\\/g, '/')).replace(/#/g, '%23').replace(/\?/g, '%3F');
    }

    // Compares two {ImageEditor}s to determine equality.
    //
    // Equality is based on the condition that the two URIs are the same.
    //
    // Returns a {Boolean}.
  }, {
    key: 'isEqual',
    value: function isEqual(other) {
      return other instanceof ImageEditor && this.getURI() === other.getURI();
    }

    // Essential: Invoke the given callback when the editor is destroyed.
    //
    // * `callback` {Function} to be called when the editor is destroyed.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'onDidDestroy',
    value: function onDidDestroy(callback) {
      return this.emitter.on('did-destroy', callback);
    }
  }, {
    key: 'element',
    get: function get() {
      return this.view && this.view.element || document.createElement('div');
    }
  }, {
    key: 'view',
    get: function get() {
      if (!this.editorView) {
        try {
          this.editorView = new _imageEditorView2['default'](this);
        } catch (e) {
          console.warn('Could not create ImageEditorView. This can be intentional in the event of an image file being deleted by an external program.');
          return;
        }
      }
      return this.editorView;
    }
  }]);

  return ImageEditor;
})();

exports['default'] = ImageEditor;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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