'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _nodeEmoji = require('node-emoji');

var _commands = require('../atom/commands');

var _commands2 = _interopRequireDefault(_commands);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _commitView = require('./commit-view');

var _commitView2 = _interopRequireDefault(_commitView);

var _timeago = require('./timeago');

var _timeago2 = _interopRequireDefault(_timeago);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class RecentCommitView extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.undoLastCommit = event => {
      event.stopPropagation();
      this.props.undoLastCommit();
    };

    this.refRoot = new _refHolder2.default();
  }

  componentDidMount() {
    if (this.props.isSelected) {
      this.refRoot.map(root => root.scrollIntoViewIfNeeded(false));
    }
  }

  componentDidUpdate(prevProps) {
    if (this.props.isSelected && !prevProps.isSelected) {
      this.refRoot.map(root => root.scrollIntoViewIfNeeded(false));
    }
  }

  render() {
    const authorMoment = (0, _moment2.default)(this.props.commit.getAuthorDate() * 1000);
    const fullMessage = this.props.commit.getFullMessage();

    return _react2.default.createElement(
      'li',
      {
        ref: this.refRoot.setter,
        className: (0, _classnames2.default)('github-RecentCommit', {
          'most-recent': this.props.isMostRecent,
          'is-selected': this.props.isSelected
        }),
        onClick: this.props.openCommit },
      this.renderAuthors(),
      _react2.default.createElement(
        'span',
        {
          className: 'github-RecentCommit-message',
          title: (0, _nodeEmoji.emojify)(fullMessage) },
        (0, _nodeEmoji.emojify)(this.props.commit.getMessageSubject())
      ),
      this.props.isMostRecent && _react2.default.createElement(
        'button',
        {
          className: 'btn github-RecentCommit-undoButton',
          onClick: this.undoLastCommit },
        'Undo'
      ),
      _react2.default.createElement(_timeago2.default, {
        className: 'github-RecentCommit-time',
        type: 'time',
        displayStyle: 'short',
        time: authorMoment,
        title: authorMoment.format('MMM Do, YYYY')
      })
    );
  }

  renderAuthor(email) {
    const match = email.match(/^(\d+)\+[^@]+@users.noreply.github.com$/);

    let avatarUrl;
    if (match) {
      avatarUrl = 'https://avatars.githubusercontent.com/u/' + match[1] + '?s=32';
    } else {
      avatarUrl = 'https://avatars.githubusercontent.com/u/e?email=' + encodeURIComponent(email) + '&s=32';
    }

    return _react2.default.createElement('img', { className: 'github-RecentCommit-avatar',
      key: email,
      src: avatarUrl,
      title: email,
      alt: `${email}'s avatar'`
    });
  }

  renderAuthors() {
    const coAuthorEmails = this.props.commit.getCoAuthors().map(author => author.email);
    const authorEmails = [this.props.commit.getAuthorEmail(), ...coAuthorEmails];

    return _react2.default.createElement(
      'span',
      { className: 'github-RecentCommit-authors' },
      authorEmails.map(this.renderAuthor)
    );
  }

}

RecentCommitView.propTypes = {
  commit: _propTypes2.default.object.isRequired,
  undoLastCommit: _propTypes2.default.func.isRequired,
  isMostRecent: _propTypes2.default.bool.isRequired,
  openCommit: _propTypes2.default.func.isRequired,
  isSelected: _propTypes2.default.bool.isRequired
};
class RecentCommitsView extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.openSelectedCommit = () => this.props.openCommit({ sha: this.props.selectedCommitSha, preserveFocus: false });

    this.refRoot = new _refHolder2.default();
  }

  setFocus(focus) {
    if (focus === this.constructor.focus.RECENT_COMMIT) {
      return this.refRoot.map(element => {
        element.focus();
        return true;
      }).getOr(false);
    }

    return false;
  }

  getFocus(element) {
    return this.refRoot.map(e => e.contains(element)).getOr(false) ? this.constructor.focus.RECENT_COMMIT : null;
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-RecentCommits', tabIndex: '-1', ref: this.refRoot.setter },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: this.refRoot },
        _react2.default.createElement(_commands.Command, { command: 'core:move-down', callback: this.props.selectNextCommit }),
        _react2.default.createElement(_commands.Command, { command: 'core:move-up', callback: this.props.selectPreviousCommit }),
        _react2.default.createElement(_commands.Command, { command: 'github:dive', callback: this.openSelectedCommit })
      ),
      this.renderCommits()
    );
  }

  renderCommits() {
    if (this.props.commits.length === 0) {
      if (this.props.isLoading) {
        return _react2.default.createElement(
          'div',
          { className: 'github-RecentCommits-message' },
          'Recent commits'
        );
      } else {
        return _react2.default.createElement(
          'div',
          { className: 'github-RecentCommits-message' },
          'Make your first commit'
        );
      }
    } else {
      return _react2.default.createElement(
        'ul',
        { className: 'github-RecentCommits-list' },
        this.props.commits.map((commit, i) => {
          return _react2.default.createElement(RecentCommitView, {
            key: commit.getSha(),
            isMostRecent: i === 0,
            commit: commit,
            undoLastCommit: this.props.undoLastCommit,
            openCommit: () => this.props.openCommit({ sha: commit.getSha(), preserveFocus: true }),
            isSelected: this.props.selectedCommitSha === commit.getSha()
          });
        })
      );
    }
  }

  advanceFocusFrom(focus) {
    if (focus === this.constructor.focus.RECENT_COMMIT) {
      return Promise.resolve(this.constructor.focus.RECENT_COMMIT);
    }

    return Promise.resolve(null);
  }

  retreatFocusFrom(focus) {
    if (focus === this.constructor.focus.RECENT_COMMIT) {
      return Promise.resolve(_commitView2.default.lastFocus);
    }

    return Promise.resolve(null);
  }
}
exports.default = RecentCommitsView;
RecentCommitsView.propTypes = {
  // Model state
  commits: _propTypes2.default.arrayOf(_propTypes2.default.object).isRequired,
  isLoading: _propTypes2.default.bool.isRequired,
  selectedCommitSha: _propTypes2.default.string.isRequired,

  // Atom environment
  commandRegistry: _propTypes2.default.object.isRequired,

  // Action methods
  undoLastCommit: _propTypes2.default.func.isRequired,
  openCommit: _propTypes2.default.func.isRequired,
  selectNextCommit: _propTypes2.default.func.isRequired,
  selectPreviousCommit: _propTypes2.default.func.isRequired
};
RecentCommitsView.focus = {
  RECENT_COMMIT: Symbol('recent_commit')
};
RecentCommitsView.firstFocus = RecentCommitsView.focus.RECENT_COMMIT;
RecentCommitsView.lastFocus = RecentCommitsView.focus.RECENT_COMMIT;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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