'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _commands = require('../atom/commands');

var _commands2 = _interopRequireDefault(_commands);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class OpenCommitDialog extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.accept = async () => {
      const ref = this.getCommitRef();
      const valid = await this.props.isValidEntry(ref);
      if (valid === true) {
        this.props.didAccept({ ref });
      } else {
        this.setState({ error: `There is no commit associated with "${ref}" in this repository` });
      }
    };

    this.cancel = () => this.props.didCancel();

    this.editorRefs = baseName => {
      const elementName = `${baseName}Element`;
      const modelName = `${baseName}Editor`;
      const subName = `${baseName}Subs`;
      const changeMethodName = `didChange${baseName[0].toUpperCase()}${baseName.substring(1)}`;

      return element => {
        if (!element) {
          return;
        }

        this[elementName] = element;
        const editor = element.getModel();
        if (this[modelName] !== editor) {
          this[modelName] = editor;

          /* istanbul ignore if */
          if (this[subName]) {
            this[subName].dispose();
            this.subs.remove(this[subName]);
          }

          this[subName] = editor.onDidChange(this[changeMethodName]);
          this.subs.add(this[subName]);
        }
      };
    };

    this.didChangeCommitRef = () => new Promise(resolve => {
      this.setState({ error: null }, resolve);
    });

    this.state = {
      error: null
    };
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    setTimeout(() => this.commitRefElement.focus());
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  render() {
    return this.renderDialog();
  }

  renderDialog() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-OpenCommit modal' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-OpenCommit' },
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancel }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.accept })
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-DialogInputs' },
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel github-CommitRef' },
          'Commit sha or Git ref:',
          _react2.default.createElement('atom-text-editor', { mini: true, ref: this.editorRefs('commitRef'), tabIndex: '1' })
        ),
        this.state.error && _react2.default.createElement(
          'span',
          { className: 'error' },
          this.state.error
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-DialogButtons' },
        _react2.default.createElement(
          'button',
          { className: 'btn github-CancelButton', onClick: this.cancel, tabIndex: '3' },
          'Cancel'
        ),
        _react2.default.createElement(
          'button',
          {
            className: 'btn btn-primary icon icon-commit',
            onClick: this.accept,
            disabled: !!this.state.error || this.getCommitRef().length === 0,
            tabIndex: '2' },
          'Open Commit'
        )
      )
    );
  }

  getCommitRef() {
    return this.commitRefEditor ? this.commitRefEditor.getText() : '';
  }
}
exports.default = OpenCommitDialog;
OpenCommitDialog.propTypes = {
  commandRegistry: _propTypes2.default.object.isRequired,
  didAccept: _propTypes2.default.func.isRequired,
  didCancel: _propTypes2.default.func.isRequired,
  isValidEntry: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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