'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _author = require('../models/author');

var _author2 = _interopRequireDefault(_author);

var _commands = require('../atom/commands');

var _commands2 = _interopRequireDefault(_commands);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CoAuthorForm extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'confirm', 'cancel', 'onNameChange', 'onEmailChange', 'validate', 'focusFirstInput');

    this.state = {
      name: this.props.name,
      email: '',
      submitDisabled: true
    };
  }

  componentDidMount() {
    setTimeout(this.focusFirstInput);
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-CoAuthorForm native-key-bindings' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-CoAuthorForm' },
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancel }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.confirm })
      ),
      _react2.default.createElement(
        'label',
        { className: 'github-CoAuthorForm-row' },
        _react2.default.createElement(
          'span',
          { className: 'github-CoAuthorForm-label' },
          'Name:'
        ),
        _react2.default.createElement('input', {
          type: 'text',
          placeholder: 'Co-author name',
          ref: e => this.nameInput = e,
          className: 'input-text github-CoAuthorForm-name',
          value: this.state.name,
          onChange: this.onNameChange,
          tabIndex: '1'
        })
      ),
      _react2.default.createElement(
        'label',
        { className: 'github-CoAuthorForm-row' },
        _react2.default.createElement(
          'span',
          { className: 'github-CoAuthorForm-label' },
          'Email:'
        ),
        _react2.default.createElement('input', {
          type: 'email',
          placeholder: 'foo@bar.com',
          ref: e => this.emailInput = e,
          className: 'input-text github-CoAuthorForm-email',
          value: this.state.email,
          onChange: this.onEmailChange,
          tabIndex: '2'
        })
      ),
      _react2.default.createElement(
        'footer',
        { className: 'github-CoAuthorForm-row has-buttons' },
        _react2.default.createElement(
          'button',
          { className: 'btn github-CancelButton', tabIndex: '3', onClick: this.cancel },
          'Cancel'
        ),
        _react2.default.createElement(
          'button',
          { className: 'btn btn-primary', disabled: this.state.submitDisabled, tabIndex: '4', onClick: this.confirm },
          'Add Co-Author'
        )
      )
    );
  }

  confirm() {
    if (this.isInputValid()) {
      this.props.onSubmit(new _author2.default(this.state.email, this.state.name));
    }
  }

  cancel() {
    this.props.onCancel();
  }

  onNameChange(e) {
    this.setState({ name: e.target.value }, this.validate);
  }

  onEmailChange(e) {
    this.setState({ email: e.target.value }, this.validate);
  }

  validate() {
    if (this.isInputValid()) {
      this.setState({ submitDisabled: false });
    }
  }

  isInputValid() {
    // email validation with regex has a LOT of corner cases, dawg.
    // https://stackoverflow.com/questions/48055431/can-it-cause-harm-to-validate-email-addresses-with-a-regex
    // to avoid bugs for users with nonstandard email addresses,
    // just check to make sure email address contains `@` and move on with our lives.
    return this.state.name && this.state.email.includes('@');
  }

  focusFirstInput() {
    this.nameInput.focus();
  }
}
exports.default = CoAuthorForm;
CoAuthorForm.propTypes = {
  commandRegistry: _propTypes2.default.object.isRequired,
  onSubmit: _propTypes2.default.func,
  onCancel: _propTypes2.default.func,
  name: _propTypes2.default.string
};
CoAuthorForm.defaultProps = {
  onSubmit: () => {},
  onCancel: () => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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