'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ItemTypePropType = exports.UserStorePropType = exports.MergeConflictItemPropType = exports.MultiFilePatchPropType = exports.FilePatchItemPropType = exports.IssueishPropType = exports.OperationStateObserverPropType = exports.EnableableOperationPropType = exports.RangePropType = exports.PointPropType = exports.RefHolderPropType = exports.RelayConnectionPropType = exports.AuthorPropType = exports.CommitPropType = exports.BranchSetPropType = exports.RemoteSetPropType = exports.SearchPropType = exports.BranchPropType = exports.EndpointPropType = exports.RemotePropType = exports.GithubLoginModelPropType = exports.WorkdirContextPoolPropType = exports.DOMNodePropType = undefined;

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DOMNodePropType = exports.DOMNodePropType = (props, propName, componentName) => {
  if (props[propName] instanceof HTMLElement) {
    return null;
  } else {
    return new Error(`Invalid prop '${propName}' supplied to '${componentName}'. Value is not DOM element.`);
  }
};

const WorkdirContextPoolPropType = exports.WorkdirContextPoolPropType = _propTypes2.default.shape({
  getContext: _propTypes2.default.func.isRequired
});

const GithubLoginModelPropType = exports.GithubLoginModelPropType = _propTypes2.default.shape({
  getToken: _propTypes2.default.func.isRequired,
  setToken: _propTypes2.default.func.isRequired,
  removeToken: _propTypes2.default.func.isRequired,
  getScopes: _propTypes2.default.func.isRequired,
  onDidUpdate: _propTypes2.default.func.isRequired
});

const RemotePropType = exports.RemotePropType = _propTypes2.default.shape({
  getName: _propTypes2.default.func.isRequired,
  getUrl: _propTypes2.default.func.isRequired,
  isGithubRepo: _propTypes2.default.func.isRequired,
  getOwner: _propTypes2.default.func.isRequired,
  getRepo: _propTypes2.default.func.isRequired,
  getEndpoint: _propTypes2.default.func.isRequired
});

const EndpointPropType = exports.EndpointPropType = _propTypes2.default.shape({
  getGraphQLRoot: _propTypes2.default.func.isRequired,
  getRestRoot: _propTypes2.default.func.isRequired,
  getRestURI: _propTypes2.default.func.isRequired
});

const BranchPropType = exports.BranchPropType = _propTypes2.default.shape({
  getName: _propTypes2.default.func.isRequired,
  isDetached: _propTypes2.default.func.isRequired,
  isPresent: _propTypes2.default.func.isRequired
});

const SearchPropType = exports.SearchPropType = _propTypes2.default.shape({
  getName: _propTypes2.default.func.isRequired,
  createQuery: _propTypes2.default.func.isRequired
});

const RemoteSetPropType = exports.RemoteSetPropType = _propTypes2.default.shape({
  withName: _propTypes2.default.func.isRequired,
  isEmpty: _propTypes2.default.func.isRequired,
  size: _propTypes2.default.func.isRequired,
  [Symbol.iterator]: _propTypes2.default.func.isRequired
});

const BranchSetPropType = exports.BranchSetPropType = _propTypes2.default.shape({
  getNames: _propTypes2.default.func.isRequired,
  getPullTargets: _propTypes2.default.func.isRequired,
  getPushSources: _propTypes2.default.func.isRequired
});

const CommitPropType = exports.CommitPropType = _propTypes2.default.shape({
  getSha: _propTypes2.default.func.isRequired,
  getMessageSubject: _propTypes2.default.func.isRequired,
  isUnbornRef: _propTypes2.default.func.isRequired,
  isPresent: _propTypes2.default.func.isRequired
});

const AuthorPropType = exports.AuthorPropType = _propTypes2.default.shape({
  getEmail: _propTypes2.default.func.isRequired,
  getFullName: _propTypes2.default.func.isRequired
});

const RelayConnectionPropType = exports.RelayConnectionPropType = nodePropType => _propTypes2.default.shape({
  edges: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    cursor: _propTypes2.default.string,
    node: nodePropType
  })),
  pageInfo: _propTypes2.default.shape({
    endCursor: _propTypes2.default.string,
    hasNextPage: _propTypes2.default.bool,
    hasPreviousPage: _propTypes2.default.bool,
    startCursor: _propTypes2.default.string
  }),
  totalCount: _propTypes2.default.number
});

const RefHolderPropType = exports.RefHolderPropType = _propTypes2.default.shape({
  isEmpty: _propTypes2.default.func.isRequired,
  get: _propTypes2.default.func.isRequired,
  setter: _propTypes2.default.func.isRequired,
  observe: _propTypes2.default.func.isRequired
});

const PointPropType = exports.PointPropType = _propTypes2.default.shape({
  row: _propTypes2.default.number.isRequired,
  column: _propTypes2.default.number.isRequired,
  isEqual: _propTypes2.default.func.isRequired
});

const RangePropType = exports.RangePropType = _propTypes2.default.shape({
  start: PointPropType.isRequired,
  end: PointPropType.isRequired,
  isEqual: _propTypes2.default.func.isRequired
});

const EnableableOperationPropType = exports.EnableableOperationPropType = _propTypes2.default.shape({
  isEnabled: _propTypes2.default.func.isRequired,
  run: _propTypes2.default.func.isRequired,
  getMessage: _propTypes2.default.func.isRequired,
  why: _propTypes2.default.func.isRequired
});

const OperationStateObserverPropType = exports.OperationStateObserverPropType = _propTypes2.default.shape({
  onDidComplete: _propTypes2.default.func.isRequired,
  dispose: _propTypes2.default.func.isRequired
});

const IssueishPropType = exports.IssueishPropType = _propTypes2.default.shape({
  getNumber: _propTypes2.default.func.isRequired,
  getTitle: _propTypes2.default.func.isRequired,
  getGitHubURL: _propTypes2.default.func.isRequired,
  getAuthorLogin: _propTypes2.default.func.isRequired,
  getAuthorAvatarURL: _propTypes2.default.func.isRequired,
  getCreatedAt: _propTypes2.default.func.isRequired,
  getHeadRefName: _propTypes2.default.func.isRequired,
  getHeadRepositoryID: _propTypes2.default.func.isRequired,
  getStatusCounts: _propTypes2.default.func.isRequired
});

const FilePatchItemPropType = exports.FilePatchItemPropType = _propTypes2.default.shape({
  filePath: _propTypes2.default.string.isRequired,
  status: _propTypes2.default.string.isRequired
});

const MultiFilePatchPropType = exports.MultiFilePatchPropType = _propTypes2.default.shape({
  getFilePatches: _propTypes2.default.func.isRequired
});

const statusNames = ['added', 'deleted', 'modified', 'typechange', 'equivalent'];

const MergeConflictItemPropType = exports.MergeConflictItemPropType = _propTypes2.default.shape({
  filePath: _propTypes2.default.string.isRequired,
  status: _propTypes2.default.shape({
    file: _propTypes2.default.oneOf(statusNames).isRequired,
    ours: _propTypes2.default.oneOf(statusNames).isRequired,
    theirs: _propTypes2.default.oneOf(statusNames).isRequired
  }).isRequired
});

const UserStorePropType = exports.UserStorePropType = _propTypes2.default.shape({
  getUsers: _propTypes2.default.func.isRequired,
  onDidUpdate: _propTypes2.default.func.isRequired
});

// Require item classes lazily to prevent circular imports
let lazyItemConstructors = null;
function createItemTypePropType(required) {
  return function (props, propName, componentName) {
    if (lazyItemConstructors === null) {
      lazyItemConstructors = new Set();
      for (const itemPath of ['./items/changed-file-item', './items/commit-preview-item', './items/commit-detail-item', './items/issueish-detail-item']) {
        lazyItemConstructors.add(require(itemPath).default);
      }
    }

    if (props[propName] === undefined || props[propName] === null) {
      /* istanbul ignore else */
      if (required) {
        return new Error(`Missing required prop ${propName} on component ${componentName}.`);
      } else {
        return undefined;
      }
    }

    /* istanbul ignore if */
    if (!lazyItemConstructors.has(props[propName])) {
      const choices = Array.from(lazyItemConstructors, each => each.name).join(', ');
      return new Error(`Invalid prop "${propName}" supplied to ${componentName}. Must be one of ${choices}.`);
    }

    return undefined;
  };
}

const ItemTypePropType = exports.ItemTypePropType = createItemTypePropType(false);
ItemTypePropType.isRequired = createItemTypePropType(true);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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